/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.metaobject;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import org.gradle.api.internal.DynamicObjectUtil;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.metaobject.GetPropertyResult;
import org.gradle.internal.metaobject.InvokeMethodResult;
import org.gradle.internal.metaobject.SetPropertyResult;

public class ConfigureDelegate
extends GroovyObjectSupport {
    protected final DynamicObject _owner;
    protected final DynamicObject _delegate;
    private final ThreadLocal<Boolean> _configuring = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public ConfigureDelegate(Closure configureClosure, Object delegate) {
        this._owner = DynamicObjectUtil.asDynamicObject(configureClosure.getOwner());
        this._delegate = DynamicObjectUtil.asDynamicObject(delegate);
    }

    public String toString() {
        return this._delegate.toString();
    }

    protected void _configure(String name, Object[] params, InvokeMethodResult result) {
    }

    protected void _configure(String name, GetPropertyResult result) {
    }

    public Object invokeMethod(String name, Object paramsObj) {
        Object[] params = (Object[])paramsObj;
        boolean isAlreadyConfiguring = this._configuring.get();
        this._configuring.set(true);
        try {
            InvokeMethodResult result = new InvokeMethodResult();
            this._delegate.invokeMethod(name, result, params);
            if (result.isFound()) {
                Object object = result.getResult();
                return object;
            }
            MissingMethodException failure = null;
            if (!isAlreadyConfiguring) {
                try {
                    this._configure(name, params, result);
                }
                catch (MissingMethodException e) {
                    failure = e;
                }
                if (result.isFound()) {
                    Object object = result.getResult();
                    return object;
                }
            }
            this._owner.invokeMethod(name, result, params);
            if (result.isFound()) {
                Object object = result.getResult();
                return object;
            }
            if (failure != null) {
                throw failure;
            }
            throw this._delegate.methodMissingException(name, params);
        }
        finally {
            this._configuring.set(isAlreadyConfiguring);
        }
    }

    public void setProperty(String property, Object newValue) {
        SetPropertyResult result = new SetPropertyResult();
        this._delegate.setProperty(property, newValue, result);
        if (result.isFound()) {
            return;
        }
        this._owner.setProperty(property, newValue, result);
        if (result.isFound()) {
            return;
        }
        throw this._delegate.setMissingProperty(property);
    }

    public Object getProperty(String name) {
        boolean isAlreadyConfiguring = this._configuring.get();
        this._configuring.set(true);
        try {
            GetPropertyResult result = new GetPropertyResult();
            this._delegate.getProperty(name, result);
            if (result.isFound()) {
                Object object = result.getValue();
                return object;
            }
            this._owner.getProperty(name, result);
            if (result.isFound()) {
                Object object = result.getValue();
                return object;
            }
            if (!isAlreadyConfiguring) {
                this._configure(name, result);
                if (result.isFound()) {
                    Object object = result.getValue();
                    return object;
                }
            }
            throw this._delegate.getMissingProperty(name);
        }
        finally {
            this._configuring.set(isAlreadyConfiguring);
        }
    }
}

