/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.wrapper;

import com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.plugins.StartScriptGenerator;
import org.gradle.api.internal.tasks.options.Option;
import org.gradle.api.internal.tasks.options.OptionValues;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.IoActions;
import org.gradle.internal.UncheckedException;
import org.gradle.util.DistributionLocator;
import org.gradle.util.GUtil;
import org.gradle.util.GradleVersion;
import org.gradle.util.WrapUtil;
import org.gradle.wrapper.GradleWrapperMain;

public class Wrapper
extends DefaultTask {
    public static final String DEFAULT_DISTRIBUTION_PARENT_NAME = "wrapper/dists";
    private Object scriptFile = "gradlew";
    private Object jarFile = "gradle/wrapper/gradle-wrapper.jar";
    private String distributionPath = "wrapper/dists";
    private PathBase distributionBase = PathBase.GRADLE_USER_HOME;
    private String distributionUrl;
    private GradleVersion gradleVersion;
    private DistributionType distributionType = DistributionType.BIN;
    private String archivePath = "wrapper/dists";
    private PathBase archiveBase = PathBase.GRADLE_USER_HOME;
    private final DistributionLocator locator = new DistributionLocator();

    public Wrapper() {
        this.gradleVersion = GradleVersion.current();
    }

    @Inject
    protected FileLookup getFileLookup() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    void generate() {
        File jarFileDestination = this.getJarFile();
        File unixScript = this.getScriptFile();
        FileResolver resolver = this.getFileLookup().getFileResolver(unixScript.getParentFile());
        String jarFileRelativePath = resolver.resolveAsRelativePath((Object)jarFileDestination);
        this.writeProperties(this.getPropertiesFile());
        this.writeWrapperTo(jarFileDestination);
        StartScriptGenerator generator = new StartScriptGenerator();
        generator.setApplicationName("Gradle");
        generator.setMainClassName(GradleWrapperMain.class.getName());
        generator.setClasspath((Iterable)WrapUtil.toList((Object[])new String[]{jarFileRelativePath}));
        generator.setOptsEnvironmentVar("GRADLE_OPTS");
        generator.setExitEnvironmentVar("GRADLE_EXIT_CONSOLE");
        generator.setAppNameSystemProperty("org.gradle.appname");
        generator.setScriptRelPath(unixScript.getName());
        generator.generateUnixScript(unixScript);
        generator.generateWindowsScript(this.getBatchScript());
    }

    private void writeWrapperTo(File destination) {
        InputStream gradleWrapperJar = Wrapper.class.getResourceAsStream("/gradle-wrapper.jar");
        if (gradleWrapperJar == null) {
            throw new GradleException("Cannot locate wrapper JAR resource.");
        }
        ZipInputStream zipInputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            zipInputStream = new ZipInputStream(gradleWrapperJar);
            zipOutputStream = new ZipOutputStream(new FileOutputStream(destination));
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                zipOutputStream.putNextEntry(entry);
                if (!entry.isDirectory()) {
                    ByteStreams.copy((InputStream)zipInputStream, (OutputStream)zipOutputStream);
                }
                zipOutputStream.closeEntry();
                entry = zipInputStream.getNextEntry();
            }
            this.addBuildReceipt(zipOutputStream);
        }
        catch (IOException e) {
            try {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
            catch (Throwable throwable) {
                IoActions.closeQuietly(zipInputStream);
                IoActions.closeQuietly(zipOutputStream);
                throw throwable;
            }
        }
        IoActions.closeQuietly((Closeable)zipInputStream);
        IoActions.closeQuietly((Closeable)zipOutputStream);
    }

    private void addBuildReceipt(ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry buildReceipt = new ZipEntry("build-receipt.properties");
        zipOutputStream.putNextEntry(buildReceipt);
        String contents = "versionNumber=" + GradleVersion.current().getVersion();
        zipOutputStream.write(contents.getBytes(StandardCharsets.ISO_8859_1));
        zipOutputStream.closeEntry();
    }

    private void writeProperties(File propertiesFileDestination) {
        Properties wrapperProperties = new Properties();
        wrapperProperties.put("distributionUrl", this.getDistributionUrl());
        wrapperProperties.put("distributionBase", this.distributionBase.toString());
        wrapperProperties.put("distributionPath", this.distributionPath);
        wrapperProperties.put("zipStoreBase", this.archiveBase.toString());
        wrapperProperties.put("zipStorePath", this.archivePath);
        GUtil.saveProperties((Properties)wrapperProperties, (File)propertiesFileDestination);
    }

    @OutputFile
    public File getScriptFile() {
        return this.getProject().file(this.scriptFile);
    }

    public void setScriptFile(Object scriptFile) {
        this.scriptFile = scriptFile;
    }

    @OutputFile
    public File getBatchScript() {
        File scriptFile = this.getScriptFile();
        return new File(scriptFile.getParentFile(), scriptFile.getName().replaceFirst("(\\.[^\\.]+)?$", ".bat"));
    }

    @OutputFile
    public File getJarFile() {
        return this.getProject().file(this.jarFile);
    }

    public void setJarFile(Object jarFile) {
        this.jarFile = jarFile;
    }

    @OutputFile
    public File getPropertiesFile() {
        File jarFileDestination = this.getJarFile();
        return new File(jarFileDestination.getParentFile(), jarFileDestination.getName().replaceAll("\\.jar$", ".properties"));
    }

    @Input
    public String getDistributionPath() {
        return this.distributionPath;
    }

    public void setDistributionPath(String distributionPath) {
        this.distributionPath = distributionPath;
    }

    @Input
    public String getGradleVersion() {
        return this.gradleVersion.getVersion();
    }

    @Option(option="gradle-version", description="The version of the Gradle distribution required by the wrapper.")
    public void setGradleVersion(String gradleVersion) {
        this.gradleVersion = GradleVersion.version((String)gradleVersion);
    }

    @Input
    public DistributionType getDistributionType() {
        return this.distributionType;
    }

    @Option(option="distribution-type", description="The type of the Gradle distribution to be used by the wrapper.")
    public void setDistributionType(DistributionType distributionType) {
        this.distributionType = distributionType;
    }

    @OptionValues(value={"distribution-type"})
    public List<DistributionType> getAvailableDistributionTypes() {
        return Arrays.asList(DistributionType.values());
    }

    @Input
    public String getDistributionUrl() {
        if (this.distributionUrl != null) {
            return this.distributionUrl;
        }
        if (this.gradleVersion != null) {
            return this.locator.getDistributionFor(this.gradleVersion, this.distributionType.name().toLowerCase(Locale.ENGLISH)).toString();
        }
        return null;
    }

    @Option(option="gradle-distribution-url", description="The URL to download the Gradle distribution from.")
    public void setDistributionUrl(String url) {
        this.distributionUrl = url;
    }

    @Input
    public PathBase getDistributionBase() {
        return this.distributionBase;
    }

    public void setDistributionBase(PathBase distributionBase) {
        this.distributionBase = distributionBase;
    }

    @Input
    public String getArchivePath() {
        return this.archivePath;
    }

    public void setArchivePath(String archivePath) {
        this.archivePath = archivePath;
    }

    @Input
    public PathBase getArchiveBase() {
        return this.archiveBase;
    }

    public void setArchiveBase(PathBase archiveBase) {
        this.archiveBase = archiveBase;
    }

    public static enum PathBase {
        PROJECT,
        GRADLE_USER_HOME;

    }

    public static enum DistributionType {
        BIN,
        ALL;

    }
}

