/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.Constants;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.util.SessionIdGeneratorBase;
import org.apache.catalina.util.StandardSessionIdGenerator;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.ActionCode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public abstract class AuthenticatorBase
extends ValveBase
implements Authenticator {
    private static final Log log = LogFactory.getLog(AuthenticatorBase.class);
    protected static final String AUTH_HEADER_NAME = "WWW-Authenticate";
    protected static final String REALM_NAME = "Authentication required";
    protected boolean alwaysUseSession = false;
    protected boolean cache = true;
    protected boolean changeSessionIdOnAuthentication = true;
    protected Context context = null;
    protected static final String info = "org.apache.catalina.authenticator.AuthenticatorBase/1.0";
    protected boolean disableProxyCaching = true;
    protected boolean securePagesWithPragma = false;
    protected String secureRandomClass = null;
    protected String secureRandomAlgorithm = "SHA1PRNG";
    protected String secureRandomProvider = null;
    protected SessionIdGeneratorBase sessionIdGenerator = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.authenticator");
    protected SingleSignOn sso = null;
    private static final String DATE_ONE = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).format(new Date(1L));

    public AuthenticatorBase() {
        super(true);
    }

    public boolean getAlwaysUseSession() {
        return this.alwaysUseSession;
    }

    public void setAlwaysUseSession(boolean alwaysUseSession) {
        this.alwaysUseSession = alwaysUseSession;
    }

    public boolean getCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    @Override
    public Container getContainer() {
        return this.context;
    }

    @Override
    public void setContainer(Container container) {
        if (container != null && !(container instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("authenticator.notContext"));
        }
        super.setContainer(container);
        this.context = (Context)container;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public boolean getDisableProxyCaching() {
        return this.disableProxyCaching;
    }

    public void setDisableProxyCaching(boolean nocache) {
        this.disableProxyCaching = nocache;
    }

    public boolean getSecurePagesWithPragma() {
        return this.securePagesWithPragma;
    }

    public void setSecurePagesWithPragma(boolean securePagesWithPragma) {
        this.securePagesWithPragma = securePagesWithPragma;
    }

    public boolean getChangeSessionIdOnAuthentication() {
        return this.changeSessionIdOnAuthentication;
    }

    public void setChangeSessionIdOnAuthentication(boolean changeSessionIdOnAuthentication) {
        this.changeSessionIdOnAuthentication = changeSessionIdOnAuthentication;
    }

    public String getSecureRandomClass() {
        return this.secureRandomClass;
    }

    public void setSecureRandomClass(String secureRandomClass) {
        this.secureRandomClass = secureRandomClass;
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
    }

    public String getSecureRandomProvider() {
        return this.secureRandomProvider;
    }

    public void setSecureRandomProvider(String secureRandomProvider) {
        this.secureRandomProvider = secureRandomProvider;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        boolean authRequired;
        Realm realm;
        SecurityConstraint[] constraints;
        String decodedRequestURI;
        SavedRequest savedRequest;
        Session session;
        Principal principal;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Security checking request " + request.getMethod() + " " + request.getRequestURI()));
        }
        LoginConfig config = this.context.getLoginConfig();
        if (this.cache && (principal = request.getUserPrincipal()) == null && (session = request.getSessionInternal(false)) != null && (principal = session.getPrincipal()) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("We have cached auth type " + session.getAuthType() + " for principal " + session.getPrincipal()));
            }
            request.setAuthType(session.getAuthType());
            request.setUserPrincipal(principal);
        }
        String contextPath = this.context.getPath();
        String requestURI = request.getDecodedRequestURI();
        if (requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check") && !this.authenticate(request, response, config)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Failed authenticate() test ??" + requestURI));
            }
            return;
        }
        Session session2 = request.getSessionInternal(false);
        if (session2 != null && (savedRequest = (SavedRequest)session2.getNote("org.apache.catalina.authenticator.REQUEST")) != null && (decodedRequestURI = request.getDecodedRequestURI()) != null && decodedRequestURI.equals(savedRequest.getDecodedRequestURI()) && !this.authenticate(request, response)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Failed authenticate() test");
            }
            return;
        }
        Wrapper wrapper = (Wrapper)request.getMappingData().wrapper;
        if (wrapper != null) {
            wrapper.servletSecurityAnnotationScan();
        }
        if ((constraints = (realm = this.context.getRealm()).findSecurityConstraints(request, this.context)) == null && !this.context.getPreemptiveAuthentication()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Not subject to any constraint");
            }
            this.getNext().invoke(request, response);
            return;
        }
        if (constraints != null && this.disableProxyCaching && !"POST".equalsIgnoreCase(request.getMethod())) {
            if (this.securePagesWithPragma) {
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
            } else {
                response.setHeader("Cache-Control", "private");
            }
            response.setHeader("Expires", DATE_ONE);
        }
        if (constraints != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Calling hasUserDataPermission()");
            }
            if (!realm.hasUserDataPermission(request, response, constraints)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)" Failed hasUserDataPermission() test");
                }
                return;
            }
        }
        if (constraints == null) {
            authRequired = false;
        } else {
            authRequired = true;
            for (int i = 0; i < constraints.length && authRequired; ++i) {
                String[] roles;
                if (!constraints[i].getAuthConstraint()) {
                    authRequired = false;
                    continue;
                }
                if (constraints[i].getAllRoles() || (roles = constraints[i].findAuthRoles()) != null && roles.length != 0) continue;
                authRequired = false;
            }
        }
        if (!authRequired && this.context.getPreemptiveAuthentication()) {
            boolean bl = authRequired = request.getCoyoteRequest().getMimeHeaders().getValue("authorization") != null;
        }
        if (!authRequired && this.context.getPreemptiveAuthentication() && "CLIENT_CERT".equals(this.getAuthMethod())) {
            X509Certificate[] certs = this.getRequestCertificates(request);
            boolean bl = authRequired = certs != null && certs.length > 0;
        }
        if (authRequired) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Calling authenticate()");
            }
            if (!this.authenticate(request, response, config)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)" Failed authenticate() test");
                }
                return;
            }
        }
        if (constraints != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Calling accessControl()");
            }
            if (!realm.hasResourcePermission(request, response, constraints, this.context)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)" Failed accessControl() test");
                }
                return;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Successfully passed all security constraints");
        }
        this.getNext().invoke(request, response);
    }

    protected X509Certificate[] getRequestCertificates(Request request) throws IllegalStateException {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certs == null || certs.length < 1) {
            try {
                request.getCoyoteRequest().action(ActionCode.REQ_SSL_CERTIFICATE, null);
                certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return certs;
    }

    protected void associate(String ssoId, Session session) {
        if (this.sso == null) {
            return;
        }
        this.sso.associate(ssoId, session);
    }

    @Override
    public boolean authenticate(Request request, HttpServletResponse response) throws IOException {
        if (this.context == null || this.context.getLoginConfig() == null) {
            return true;
        }
        return this.authenticate(request, response, this.context.getLoginConfig());
    }

    @Override
    public abstract boolean authenticate(Request var1, HttpServletResponse var2, LoginConfig var3) throws IOException;

    protected boolean checkForCachedAuthentication(Request request, HttpServletResponse response, boolean useSSO) {
        String username;
        Principal principal = request.getUserPrincipal();
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (principal != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("authenticator.check.found", principal.getName()));
            }
            if (ssoId != null) {
                this.associate(ssoId, request.getSessionInternal(true));
            }
            return true;
        }
        if (useSSO && ssoId != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("authenticator.check.sso", ssoId));
            }
            if (this.reauthenticateFromSSO(ssoId, request)) {
                return true;
            }
        }
        if (request.getCoyoteRequest().getRemoteUserNeedsAuthorization() && (username = request.getCoyoteRequest().getRemoteUser().toString()) != null) {
            String authType;
            Principal authorized;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("authenticator.check.authorize", username));
            }
            if ((authorized = this.context.getRealm().authenticate(username)) == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("authenticator.check.authorizeFail", username));
                }
                authorized = new GenericPrincipal(username, null, null);
            }
            if ((authType = request.getAuthType()) == null || authType.length() == 0) {
                authType = this.getAuthMethod();
            }
            this.register(request, response, authorized, authType, username, null);
            return true;
        }
        return false;
    }

    protected boolean reauthenticateFromSSO(String ssoId, Request request) {
        Realm realm;
        if (this.sso == null || ssoId == null) {
            return false;
        }
        boolean reauthenticated = false;
        Container parent = this.getContainer();
        if (parent != null && (realm = parent.getRealm()) != null) {
            reauthenticated = this.sso.reauthenticate(ssoId, realm, request);
        }
        if (reauthenticated) {
            this.associate(ssoId, request.getSessionInternal(true));
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Reauthenticated cached principal '" + request.getUserPrincipal().getName() + "' with auth type '" + request.getAuthType() + "'"));
            }
        }
        return reauthenticated;
    }

    public void register(Request request, HttpServletResponse response, Principal principal, String authType, String username, String password) {
        if (log.isDebugEnabled()) {
            String name = principal == null ? "none" : principal.getName();
            log.debug((Object)("Authenticated '" + name + "' with type '" + authType + "'"));
        }
        request.setAuthType(authType);
        request.setUserPrincipal(principal);
        Session session = request.getSessionInternal(false);
        if (session != null) {
            if (this.changeSessionIdOnAuthentication && principal != null) {
                Manager manager = request.getContext().getManager();
                manager.changeSessionId(session);
                request.changeSessionId(session.getId());
            }
        } else if (this.alwaysUseSession) {
            session = request.getSessionInternal(true);
        }
        if (this.cache && session != null) {
            session.setAuthType(authType);
            session.setPrincipal(principal);
            if (username != null) {
                session.setNote("org.apache.catalina.session.USERNAME", username);
            } else {
                session.removeNote("org.apache.catalina.session.USERNAME");
            }
            if (password != null) {
                session.setNote("org.apache.catalina.session.PASSWORD", password);
            } else {
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
        }
        if (this.sso == null) {
            return;
        }
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (ssoId == null) {
            ssoId = this.sessionIdGenerator.generateSessionId();
            Cookie cookie = new Cookie(Constants.SINGLE_SIGN_ON_COOKIE, ssoId);
            cookie.setMaxAge(-1);
            cookie.setPath("/");
            cookie.setSecure(request.isSecure());
            String ssoDomain = this.sso.getCookieDomain();
            if (ssoDomain != null) {
                cookie.setDomain(ssoDomain);
            }
            if (request.getServletContext().getSessionCookieConfig().isHttpOnly() || request.getContext().getUseHttpOnly()) {
                cookie.setHttpOnly(true);
            }
            response.addCookie(cookie);
            this.sso.register(ssoId, principal, authType, username, password);
            request.setNote("org.apache.catalina.request.SSOID", ssoId);
        } else {
            if (principal == null) {
                this.sso.deregister(ssoId);
                request.removeNote("org.apache.catalina.request.SSOID");
                return;
            }
            this.sso.update(ssoId, principal, authType, username, password);
        }
        if (session == null) {
            session = request.getSessionInternal(true);
        }
        this.sso.associate(ssoId, session);
    }

    @Override
    public void login(String username, String password, Request request) throws ServletException {
        Principal principal = this.doLogin(request, username, password);
        this.register(request, request.getResponse(), principal, this.getAuthMethod(), username, password);
    }

    protected abstract String getAuthMethod();

    protected Principal doLogin(Request request, String username, String password) throws ServletException {
        Principal p = this.context.getRealm().authenticate(username, password);
        if (p == null) {
            throw new ServletException(sm.getString("authenticator.loginFail"));
        }
        return p;
    }

    @Override
    public void logout(Request request) throws ServletException {
        Principal p = request.getPrincipal();
        if (p instanceof GenericPrincipal) {
            try {
                ((GenericPrincipal)p).logout();
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                log.debug((Object)sm.getString("authenticator.tomcatPrincipalLogoutFail"), t);
            }
        }
        this.register(request, request.getResponse(), null, null, null, null);
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        Container parent = this.context.getParent();
        while (this.sso == null && parent != null) {
            Valve[] valves = parent.getPipeline().getValves();
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                this.sso = (SingleSignOn)valves[i];
                break;
            }
            if (this.sso != null) continue;
            parent = parent.getParent();
        }
        if (log.isDebugEnabled()) {
            if (this.sso != null) {
                log.debug((Object)("Found SingleSignOn Valve at " + this.sso));
            } else {
                log.debug((Object)"No SingleSignOn Valve is present");
            }
        }
        this.sessionIdGenerator = new StandardSessionIdGenerator();
        this.sessionIdGenerator.setSecureRandomAlgorithm(this.getSecureRandomAlgorithm());
        this.sessionIdGenerator.setSecureRandomClass(this.getSecureRandomClass());
        this.sessionIdGenerator.setSecureRandomProvider(this.getSecureRandomProvider());
        super.startInternal();
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.sso = null;
    }
}

