/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.RangeCodegenUtil;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0015\u0010\t\u001a\u00070\u0001\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0012\u001a\u00020\r*\u00020\u0013\u001a\f\u0010\u0014\u001a\u00020\r*\u00020\u0015H\u0002\u001a\u001a\u0010\u0016\u001a\u00020\r*\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002\u001a\f\u0010\u001a\u001a\u00020\r*\u00020\u0013H\u0002\u001a\f\u0010\u001b\u001a\u00020\r*\u00020\u0013H\u0002\u001a.\u0010\u001c\u001a\u00020\r*\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\r0 \u00a2\u0006\u0002\b!H\u0086\b\u001a\u001a\u0010\"\u001a\u00020\r*\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002\u001a\n\u0010#\u001a\u00020\r*\u00020\u0013\u001a\n\u0010$\u001a\u00020\r*\u00020\u0013\u001a\n\u0010%\u001a\u00020\r*\u00020\u0013\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"2\u0010\u0004\u001a&\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u00010\u0001 \u0002*\u0012\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"JLCLASS_TO_KCLASS", "", "kotlin.jvm.PlatformType", "KCLASS_TO_JLCLASS", "UNBOXING_METHOD_NAMES", "Lorg/jetbrains/kotlin/com/google/common/collect/ImmutableSet;", "buildFqNameByInternal", "Lorg/jetbrains/kotlin/name/FqName;", "internalClassName", "getValuesTypeOfProgressionClass", "Lorg/jetbrains/annotations/NotNull;", "progressionClassInternalName", "isProgressionClass", "", "isUnboxingMethodName", "name", "isWrapperClassName", "isWrapperClassNameOrNumber", "isBoxing", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "isBoxingMethodDescriptor", "Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;", "isIteratorMethodCallOfProgression", "values", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "isJavaLangClassBoxing", "isJavaLangClassUnboxing", "isMethodInsnWith", "opcode", "", "condition", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "isNextMethodCallOfProgressionIterator", "isPrimitiveBoxing", "isPrimitiveUnboxing", "isUnboxing", "kotlin-compiler"})
public final class BoxingInterpreterKt {
    private static final ImmutableSet<String> UNBOXING_METHOD_NAMES = ImmutableSet.of("booleanValue", "charValue", "byteValue", "shortValue", "intValue", "floatValue", new String[]{"longValue", "doubleValue"});
    private static final String KCLASS_TO_JLCLASS = Type.getMethodDescriptor(AsmTypes.JAVA_CLASS_TYPE, AsmTypes.K_CLASS_TYPE);
    private static final String JLCLASS_TO_KCLASS = Type.getMethodDescriptor(AsmTypes.K_CLASS_TYPE, AsmTypes.JAVA_CLASS_TYPE);

    public static final boolean isUnboxing(@NotNull AbstractInsnNode $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return BoxingInterpreterKt.isPrimitiveUnboxing($receiver) || BoxingInterpreterKt.isJavaLangClassUnboxing($receiver);
    }

    public static final boolean isBoxing(@NotNull AbstractInsnNode $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return BoxingInterpreterKt.isPrimitiveBoxing($receiver) || BoxingInterpreterKt.isJavaLangClassBoxing($receiver);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPrimitiveUnboxing(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 182;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        String string = $receiver2.owner;
        Intrinsics.checkExpressionValueIsNotNull(string, "owner");
        if (!BoxingInterpreterKt.isWrapperClassNameOrNumber(string)) return false;
        String string2 = $receiver2.name;
        Intrinsics.checkExpressionValueIsNotNull(string2, "name");
        if (!BoxingInterpreterKt.isUnboxingMethodName(string2)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isJavaLangClassUnboxing(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 184;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        if (!Intrinsics.areEqual($receiver2.owner, "kotlin/jvm/JvmClassMappingKt")) return false;
        if (!Intrinsics.areEqual($receiver2.name, "getJavaClass")) return false;
        if (!Intrinsics.areEqual($receiver2.desc, KCLASS_TO_JLCLASS)) return false;
        return true;
    }

    public static final boolean isMethodInsnWith(@NotNull AbstractInsnNode $receiver, int opcode, @NotNull Function1<? super MethodInsnNode, Boolean> condition) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(condition, "condition");
        return $receiver.getOpcode() == opcode && $receiver instanceof MethodInsnNode && condition.invoke((MethodInsnNode)$receiver) != false;
    }

    private static final boolean isWrapperClassNameOrNumber(String internalClassName) {
        return BoxingInterpreterKt.isWrapperClassName(internalClassName) || Intrinsics.areEqual(internalClassName, Type.getInternalName(Number.class));
    }

    private static final boolean isWrapperClassName(String internalClassName) {
        return JvmPrimitiveType.isWrapperClassName(BoxingInterpreterKt.buildFqNameByInternal(internalClassName));
    }

    private static final FqName buildFqNameByInternal(String internalClassName) {
        return new FqName(Type.getObjectType(internalClassName).getClassName());
    }

    private static final boolean isUnboxingMethodName(String name2) {
        return UNBOXING_METHOD_NAMES.contains(name2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPrimitiveBoxing(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 184;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        String string = $receiver2.owner;
        Intrinsics.checkExpressionValueIsNotNull(string, "owner");
        if (!BoxingInterpreterKt.isWrapperClassName(string)) return false;
        if (!Intrinsics.areEqual($receiver2.name, "valueOf")) return false;
        if (!BoxingInterpreterKt.isBoxingMethodDescriptor($receiver2)) return false;
        return true;
    }

    private static final boolean isBoxingMethodDescriptor(@NotNull MethodInsnNode $receiver) {
        Type ownerType = Type.getObjectType($receiver.owner);
        return Intrinsics.areEqual($receiver.desc, Type.getMethodDescriptor(ownerType, AsmUtil.unboxType(ownerType)));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isJavaLangClassBoxing(@NotNull AbstractInsnNode $receiver) {
        void $receiver$iv;
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 184;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        if (!Intrinsics.areEqual($receiver2.owner, "kotlin/jvm/internal/Reflection")) return false;
        if (!Intrinsics.areEqual($receiver2.name, "getOrCreateKotlinClass")) return false;
        if (!Intrinsics.areEqual($receiver2.desc, JLCLASS_TO_KCLASS)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isNextMethodCallOfProgressionIterator(@NotNull AbstractInsnNode $receiver, List<? extends BasicValue> values2) {
        void $receiver$iv;
        if (!(values2.get(0) instanceof ProgressionIteratorBasicValue)) return false;
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 185;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        if (!Intrinsics.areEqual($receiver2.name, "next")) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isIteratorMethodCallOfProgression(@NotNull AbstractInsnNode $receiver, List<? extends BasicValue> values2) {
        void $receiver$iv;
        AbstractInsnNode abstractInsnNode = $receiver;
        int opcode$iv = 185;
        if ($receiver$iv.getOpcode() != opcode$iv) return false;
        if (!($receiver$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
        Type firstArgType = values2.get(0).getType();
        if (firstArgType == null) return false;
        String string = firstArgType.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull(string, "firstArgType.internalName");
        if (!BoxingInterpreterKt.isProgressionClass(string)) return false;
        if (!Intrinsics.areEqual($receiver2.name, "iterator")) return false;
        return true;
    }

    private static final boolean isProgressionClass(String internalClassName) {
        return RangeCodegenUtil.isRangeOrProgression(BoxingInterpreterKt.buildFqNameByInternal(internalClassName));
    }

    private static final String getValuesTypeOfProgressionClass(String progressionClassInternalName) {
        Object object;
        PrimitiveType type2;
        Object object2 = RangeCodegenUtil.getPrimitiveRangeOrProgressionElementType(BoxingInterpreterKt.buildFqNameByInternal(progressionClassInternalName));
        if (object2 == null || (object2 = (type2 = (object = object2)).getTypeName().asString()) == null) {
            object = "type should be not null";
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return object2;
    }

    public static final /* synthetic */ boolean access$isIteratorMethodCallOfProgression(@NotNull AbstractInsnNode $receiver, @NotNull List values2) {
        return BoxingInterpreterKt.isIteratorMethodCallOfProgression($receiver, values2);
    }

    @NotNull
    public static final /* synthetic */ String access$getValuesTypeOfProgressionClass(@NotNull String progressionClassInternalName) {
        return BoxingInterpreterKt.getValuesTypeOfProgressionClass(progressionClassInternalName);
    }

    public static final /* synthetic */ boolean access$isNextMethodCallOfProgressionIterator(@NotNull AbstractInsnNode $receiver, @NotNull List values2) {
        return BoxingInterpreterKt.isNextMethodCallOfProgressionIterator($receiver, values2);
    }

    public static final /* synthetic */ boolean access$isProgressionClass(@NotNull String internalClassName) {
        return BoxingInterpreterKt.isProgressionClass(internalClassName);
    }
}

