/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.resource.AbstractExternalResource;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;

public class DefaultExternalResource
extends AbstractExternalResource {
    private final URI uri;
    private final ExternalResourceReadResponse response;

    public DefaultExternalResource(URI uri, ExternalResourceReadResponse response) {
        this.uri = uri;
        this.response = response;
    }

    public URI getURI() {
        return this.uri;
    }

    public ExternalResourceMetaData getMetaData() {
        return this.response.getMetaData();
    }

    public boolean isLocal() {
        return this.response.isLocal();
    }

    protected InputStream openStream() throws IOException {
        return this.response.openStream();
    }

    public void close() {
        try {
            this.response.close();
        }
        catch (IOException e) {
            throw new ResourceException(this.uri, String.format("Could not close resource '%s'.", this.uri), e);
        }
    }
}

