/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.GenerateEclipseProject;
import org.gradle.plugins.ide.eclipse.model.EclipseProject;
import org.gradle.plugins.ide.internal.configurer.HierarchicalElementDeduplicator;
import org.gradle.plugins.ide.internal.configurer.NameDeduplicationAdapter;

public class EclipseNameDeduper {
    private static final Predicate<Project> HAS_ECLIPSE_PLUGIN = new Predicate<Project>(){

        public boolean apply(Project project) {
            return EclipseNameDeduper.hasEclipsePlugin(project);
        }
    };
    private static final Function<Project, EclipseProject> GET_ECLIPSE_PROJECT = new Function<Project, EclipseProject>(){

        public EclipseProject apply(Project p) {
            return EclipseNameDeduper.getEclipseProject(p);
        }
    };

    public void configureRoot(Project rootProject) {
        Set projects = Sets.filter((Set)rootProject.getAllprojects(), HAS_ECLIPSE_PLUGIN);
        ImmutableMap eclipseProjects = Maps.uniqueIndex((Iterable)projects, GET_ECLIPSE_PROJECT);
        HierarchicalElementDeduplicator<EclipseProject> deduplicator = new HierarchicalElementDeduplicator<EclipseProject>(new EclipseDeduplicationAdapter((Map)eclipseProjects));
        Map<EclipseProject, String> deduplicated = deduplicator.deduplicate((Iterable<EclipseProject>)eclipseProjects.keySet());
        for (Map.Entry<EclipseProject, String> entry : deduplicated.entrySet()) {
            entry.getKey().setName(entry.getValue());
        }
    }

    private static EclipseProject getEclipseProject(Project project) {
        return ((GenerateEclipseProject)project.getTasks().getByName("eclipseProject")).getProjectModel();
    }

    private static boolean hasEclipsePlugin(Project project) {
        return project.getPlugins().hasPlugin(EclipsePlugin.class);
    }

    private static class EclipseDeduplicationAdapter
    implements NameDeduplicationAdapter<EclipseProject> {
        final Map<EclipseProject, Project> eclipseProjects;

        private EclipseDeduplicationAdapter(Map<EclipseProject, Project> eclipseProjects) {
            this.eclipseProjects = eclipseProjects;
        }

        @Override
        public String getName(EclipseProject element) {
            return element.getName();
        }

        @Override
        public EclipseProject getParent(EclipseProject element) {
            Project parent = this.eclipseProjects.get(element).getParent();
            if (parent == null) {
                return null;
            }
            return EclipseNameDeduper.hasEclipsePlugin(parent) ? EclipseNameDeduper.getEclipseProject(parent) : null;
        }
    }
}

