/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.upload.CyclicUploadDependencyException;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.io.AbstractIOTask;
import org.openstreetmap.josm.gui.io.UploadStrategySpecification;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiPrimitiveGoneException;
import org.openstreetmap.josm.io.OsmServerWriter;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class UploadLayerTask
extends AbstractIOTask {
    private OsmServerWriter writer;
    private final OsmDataLayer layer;
    private final ProgressMonitor monitor;
    private final Changeset changeset;
    private Collection<OsmPrimitive> toUpload;
    private final Set<IPrimitive> processedPrimitives;
    private final UploadStrategySpecification strategy;

    public UploadLayerTask(UploadStrategySpecification uploadStrategySpecification, OsmDataLayer osmDataLayer, ProgressMonitor progressMonitor, Changeset changeset) {
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "layer");
        CheckParameterUtil.ensureParameterNotNull(uploadStrategySpecification, "strategy");
        this.layer = osmDataLayer;
        this.monitor = Optional.ofNullable(progressMonitor).orElse(NullProgressMonitor.INSTANCE);
        this.changeset = changeset;
        this.strategy = uploadStrategySpecification;
        this.processedPrimitives = new HashSet<IPrimitive>();
    }

    protected OsmPrimitive getPrimitive(OsmPrimitiveType osmPrimitiveType, long l) {
        for (OsmPrimitive osmPrimitive : this.toUpload) {
            if (!OsmPrimitiveType.from(osmPrimitive).equals((Object)osmPrimitiveType) || osmPrimitive.getId() != l) continue;
            return osmPrimitive;
        }
        return null;
    }

    protected void recoverFromGoneOnServer(OsmApiPrimitiveGoneException osmApiPrimitiveGoneException) throws OsmTransferException {
        if (!osmApiPrimitiveGoneException.isKnownPrimitive()) {
            throw osmApiPrimitiveGoneException;
        }
        OsmPrimitive osmPrimitive = this.getPrimitive(osmApiPrimitiveGoneException.getPrimitiveType(), osmApiPrimitiveGoneException.getPrimitiveId());
        if (osmPrimitive == null) {
            throw osmApiPrimitiveGoneException;
        }
        if (osmPrimitive.isDeleted()) {
            Main.warn(I18n.tr("Object ''{0}'' is already deleted on the server. Skipping this object and retrying to upload.", osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance())));
            this.processedPrimitives.addAll(this.writer.getProcessedPrimitives());
            this.processedPrimitives.add(osmPrimitive);
            this.toUpload.removeAll(this.processedPrimitives);
            return;
        }
        throw osmApiPrimitiveGoneException;
    }

    @Override
    public void run() {
        this.monitor.indeterminateSubTask(I18n.tr("Preparing objects to upload ...", new Object[0]));
        APIDataSet aPIDataSet = new APIDataSet(this.layer.data);
        try {
            aPIDataSet.adjustRelationUploadOrder();
        }
        catch (CyclicUploadDependencyException cyclicUploadDependencyException) {
            this.setLastException(cyclicUploadDependencyException);
            return;
        }
        this.toUpload = aPIDataSet.getPrimitives();
        if (this.toUpload.isEmpty()) {
            return;
        }
        this.writer = new OsmServerWriter();
        try {
            while (true) {
                try {
                    ProgressMonitor progressMonitor = this.monitor.createSubTaskMonitor(-1, false);
                    if (this.isCanceled()) {
                        return;
                    }
                    this.writer.uploadOsm(this.strategy, this.toUpload, this.changeset, progressMonitor);
                    this.processedPrimitives.addAll(this.writer.getProcessedPrimitives());
                }
                catch (OsmApiPrimitiveGoneException osmApiPrimitiveGoneException) {
                    this.recoverFromGoneOnServer(osmApiPrimitiveGoneException);
                    continue;
                }
                break;
            }
            if (this.strategy.isCloseChangesetAfterUpload() && this.changeset != null && this.changeset.getId() > 0) {
                OsmApi.getOsmApi().closeChangeset(this.changeset, this.monitor.createSubTaskMonitor(0, false));
            }
        }
        catch (OsmTransferException osmTransferException) {
            if (this.isCanceled()) {
                Main.info("Ignoring exception caught because upload is canceled. Exception is: " + osmTransferException);
                return;
            }
            this.setLastException(osmTransferException);
        }
        if (this.isCanceled()) {
            return;
        }
        this.layer.cleanupAfterUpload(this.processedPrimitives);
        this.layer.onPostUploadToServer();
    }

    @Override
    public void cancel() {
        this.setCanceled(true);
        if (this.writer != null) {
            this.writer.cancel();
        }
    }
}

