/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.MapViewGraphics;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.ColorScale;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Utils;

public class GpxDrawHelper
implements SystemOfMeasurement.SoMChangeListener,
MapViewPaintable.LayerPainter,
MapViewPaintable.PaintableInvalidationListener,
GpxData.GpxDataChangeListener {
    public static final ColorProperty DEFAULT_COLOR = new ColorProperty(I18n.marktr("gps point"), Color.magenta);
    private final GpxData data;
    private final GpxLayer layer;
    private boolean forceLines;
    private boolean alphaLines;
    private boolean direction;
    private int lineWidth;
    private int maxLineLength;
    private boolean lines;
    private boolean large;
    private int largesize;
    private boolean hdopCircle;
    private boolean alternateDirection;
    private int delta;
    private double minTrackDurationForTimeColoring;
    private int hdoprange;
    private static final double PHI = Utils.toRadians(15.0);
    private boolean computeCacheInSync;
    private int computeCacheMaxLineLengthUsed;
    private Color computeCacheColorUsed;
    private boolean computeCacheColorDynamic;
    private ColorMode computeCacheColored;
    private int computeCacheColorTracksTune;
    private int computeCacheHeatMapDrawColorTableIdx;
    private boolean computeCacheHeatMapDrawPointMode;
    private int computeCacheHeatMapDrawGain;
    private int computeCacheHeatMapDrawLowerLimit;
    private ColorMode colored;
    private int colorTracksTune;
    private boolean colorModeDynamic;
    private Color neutralColor;
    private int largePointAlpha;
    private ColorScale velocityScale;
    private ColorScale hdopScale;
    private ColorScale dateScale;
    private ColorScale directionScale;
    private int hdopAlpha;
    private static final int ll0 = 9;
    private static final int sl4 = 5;
    private static final int sl9 = 3;
    private static final int[][] dir = new int[][]{{5, 9, 9, 5}, {-3, 9, 3, 9}, {-9, 5, -5, 9}, {-9, -3, -9, 3}, {-5, -9, -9, -5}, {3, -9, -3, -9}, {9, -5, 5, -9}, {9, 3, 9, -3}};
    private boolean heatMapEnabled;
    private boolean heatMapDrawExtraLine;
    private int heatMapDrawColorTableIdx;
    private boolean heatMapDrawPointMode;
    private int heatMapDrawGain;
    private int heatMapDrawLowerLimit;
    private BufferedImage heatMapImgGray;
    private Graphics2D heatMapGraph2d;
    Rectangle heatMapCacheScreenBounds = new Rectangle();
    MapViewState heatMapMapViewState;
    int heatMapCacheLineWith;
    private final List<Integer> heatMapPolyX = new ArrayList<Integer>();
    private final List<Integer> heatMapPolyY = new ArrayList<Integer>();
    private static Color[] heatMapLutColorJosmInferno = GpxDrawHelper.createColorFromResource("inferno");
    private static Color[] heatMapLutColorJosmViridis = GpxDrawHelper.createColorFromResource("viridis");
    private static Color[] heatMapLutColorJosmBrown2Green = GpxDrawHelper.createColorFromResource("brown2green");
    private static Color[] heatMapLutColorJosmRed2Blue = GpxDrawHelper.createColorFromResource("red2blue");
    private Color[] heatMapLutColor = GpxDrawHelper.createColorLut(0, Color.BLACK, Color.WHITE);
    private boolean gpxLayerInvalidated;

    private void setupColors() {
        this.hdopAlpha = Main.pref.getInteger("hdop.color.alpha", -1);
        this.velocityScale = ColorScale.createHSBScale(256);
        this.hdopScale = ColorScale.createHSBScale(256).makeReversed().addTitle(I18n.tr("HDOP", new Object[0]));
        this.dateScale = ColorScale.createHSBScale(256).addTitle(I18n.tr("Time", new Object[0]));
        this.directionScale = ColorScale.createCyclicScale(256).setIntervalCount(4).addTitle(I18n.tr("Direction", new Object[0]));
        this.systemOfMeasurementChanged(null, null);
    }

    @Override
    public void systemOfMeasurementChanged(String string, String string2) {
        SystemOfMeasurement systemOfMeasurement = SystemOfMeasurement.getSystemOfMeasurement();
        this.velocityScale.addTitle(I18n.tr("Velocity, {0}", systemOfMeasurement.speedName));
        this.layer.invalidate();
    }

    public GpxDrawHelper(GpxLayer gpxLayer) {
        this.layer = gpxLayer;
        this.data = gpxLayer.data;
        this.data.addChangeListener(this);
        this.layer.addInvalidationListener(this);
        SystemOfMeasurement.addSoMChangeListener(this);
        this.setupColors();
    }

    private static String specName(String string) {
        return "layer " + string;
    }

    public Color getColor(String string, boolean bl) {
        if (bl || this.getColorMode(string) == ColorMode.NONE) {
            return DEFAULT_COLOR.getChildColor(GpxDrawHelper.specName(string)).get();
        }
        return null;
    }

    public ColorMode getColorMode(String string) {
        try {
            int n = Main.pref.getInteger("draw.rawgps.colors", GpxDrawHelper.specName(string), 0);
            return ColorMode.fromIndex(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Main.warn(indexOutOfBoundsException);
            return ColorMode.NONE;
        }
    }

    public static Color getGenericColor() {
        return DEFAULT_COLOR.get();
    }

    public void readPreferences(String string) {
        String string2 = GpxDrawHelper.specName(string);
        this.forceLines = Main.pref.getBoolean("draw.rawgps.lines.force", string2, false);
        this.direction = Main.pref.getBoolean("draw.rawgps.direction", string2, false);
        this.lineWidth = Main.pref.getInteger("draw.rawgps.linewidth", string2, 0);
        this.alphaLines = Main.pref.getBoolean("draw.rawgps.lines.alpha-blend", string2, false);
        if (!this.data.fromServer) {
            this.maxLineLength = Main.pref.getInteger("draw.rawgps.max-line-length.local", string2, -1);
            this.lines = Main.pref.getBoolean("draw.rawgps.lines.local", string2, true);
        } else {
            this.maxLineLength = Main.pref.getInteger("draw.rawgps.max-line-length", string2, 200);
            this.lines = Main.pref.getBoolean("draw.rawgps.lines", string2, true);
        }
        this.large = Main.pref.getBoolean("draw.rawgps.large", string2, false);
        this.largesize = Main.pref.getInteger("draw.rawgps.large.size", string2, 3);
        this.hdopCircle = Main.pref.getBoolean("draw.rawgps.hdopcircle", string2, false);
        this.colored = this.getColorMode(string);
        this.alternateDirection = Main.pref.getBoolean("draw.rawgps.alternatedirection", string2, false);
        this.delta = Main.pref.getInteger("draw.rawgps.min-arrow-distance", string2, 40);
        this.colorTracksTune = Main.pref.getInteger("draw.rawgps.colorTracksTune", string2, 45);
        this.colorModeDynamic = Main.pref.getBoolean("draw.rawgps.colors.dynamic", string2, false);
        this.hdoprange = Main.pref.getInteger("hdop.range", 7);
        this.minTrackDurationForTimeColoring = Main.pref.getInteger("draw.rawgps.date-coloring-min-dt", 60);
        this.largePointAlpha = Main.pref.getInteger("draw.rawgps.large.alpha", -1) & 0xFF;
        this.heatMapEnabled = Main.pref.getBoolean("draw.rawgps.heatmap.enabled", string2, false);
        this.heatMapDrawExtraLine = Main.pref.getBoolean("draw.rawgps.heatmap.line-extra", string2, false);
        this.heatMapDrawColorTableIdx = Main.pref.getInteger("draw.rawgps.heatmap.colormap", string2, 0);
        this.heatMapDrawPointMode = Main.pref.getBoolean("draw.rawgps.heatmap.use-points", string2, false);
        this.heatMapDrawGain = Main.pref.getInteger("draw.rawgps.heatmap.gain", string2, 0);
        this.heatMapDrawLowerLimit = Main.pref.getInteger("draw.rawgps.heatmap.lower-limit", string2, 0);
        this.heatMapDrawGain = Utils.clamp(this.heatMapDrawGain, -10, 10);
        this.neutralColor = this.getColor(string, true);
        this.velocityScale.setNoDataColor(this.neutralColor);
        this.dateScale.setNoDataColor(this.neutralColor);
        this.hdopScale.setNoDataColor(this.neutralColor);
        this.directionScale.setNoDataColor(this.neutralColor);
        this.largesize += this.lineWidth;
    }

    @Override
    public void paint(MapViewGraphics mapViewGraphics) {
        List<WayPoint> list = this.listVisibleSegments(mapViewGraphics.getClipBounds().getLatLonBoundsBox());
        if (!list.isEmpty()) {
            this.readPreferences(this.layer.getName());
            this.drawAll(mapViewGraphics.getDefaultGraphics(), mapViewGraphics.getMapView(), list);
            if (mapViewGraphics.getMapView().getLayerManager().getActiveLayer() == this.layer) {
                this.drawColorBar(mapViewGraphics.getDefaultGraphics(), mapViewGraphics.getMapView());
            }
        }
    }

    private List<WayPoint> listVisibleSegments(Bounds bounds) {
        WayPoint wayPoint = null;
        LinkedList<WayPoint> linkedList = new LinkedList<WayPoint>();
        this.ensureTrackVisibilityLength();
        for (Collection<WayPoint> collection : this.data.getLinesIterable(this.layer.trackVisibility)) {
            for (WayPoint wayPoint2 : collection) {
                Bounds bounds2 = new Bounds(wayPoint2.getCoor());
                if (wayPoint2.drawLine && wayPoint != null) {
                    bounds2.extend(wayPoint.getCoor());
                }
                if (bounds2.intersects(bounds)) {
                    if (wayPoint != null && (linkedList.isEmpty() || linkedList.getLast() != wayPoint)) {
                        if (wayPoint.drawLine) {
                            WayPoint wayPoint3 = new WayPoint(wayPoint);
                            wayPoint3.drawLine = false;
                            linkedList.add(wayPoint3);
                        } else {
                            linkedList.add(wayPoint);
                        }
                    }
                    linkedList.add(wayPoint2);
                }
                wayPoint = wayPoint2;
            }
        }
        return linkedList;
    }

    private void ensureTrackVisibilityLength() {
        int n = this.data.getTracks().size();
        if (n == this.layer.trackVisibility.length) {
            return;
        }
        int n2 = Math.min(n, this.layer.trackVisibility.length);
        this.layer.trackVisibility = Arrays.copyOf(this.layer.trackVisibility, n);
        for (int i = n2; i < n; ++i) {
            this.layer.trackVisibility[i] = true;
        }
    }

    public void drawAll(Graphics2D graphics2D, MapView mapView, List<WayPoint> list) {
        long l = System.currentTimeMillis();
        this.checkCache();
        if (!this.computeCacheInSync) {
            this.calculateColors();
        }
        this.fixColors(list);
        Composite composite = graphics2D.getComposite();
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Main.pref.getBoolean("mappaint.gpx.use-antialiasing", false) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.lineWidth != 0) {
            graphics2D.setStroke(new BasicStroke(this.lineWidth, 1, 1));
        }
        boolean bl = this.heatMapEnabled || ColorMode.HEATMAP == this.colored;
        float f = 1.0f;
        if (composite instanceof AlphaComposite) {
            f = ((AlphaComposite)composite).getAlpha();
        }
        if (bl) {
            this.drawHeatMap(graphics2D, mapView, list);
        } else if (!this.alphaLines) {
            this.drawLines(graphics2D, mapView, list);
        } else {
            this.drawLinesAlpha(graphics2D, mapView, list, f);
        }
        if (this.alphaLines || bl) {
            graphics2D.setComposite(AlphaComposite.SrcOver.derive(0.25f * f));
        }
        this.drawArrows(graphics2D, mapView, list);
        this.drawPoints(graphics2D, mapView, list);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        graphics2D.setComposite(composite);
        if (Main.isDebugEnabled() && !list.isEmpty()) {
            long l2 = System.currentTimeMillis() - l;
            Main.debug("gpxdraw::draw takes " + Utils.getDurationString(l2) + "(segments= " + list.size() + ", per 10000 = " + Utils.getDurationString(10000L * l2 / (long)list.size()) + ")");
        }
    }

    public void calculateColors() {
        double d = 1.0E10;
        double d2 = -1.0E10;
        Object object3 = null;
        if (this.colorModeDynamic) {
            double d3;
            if (this.colored == ColorMode.VELOCITY) {
                ArrayList arrayList = new ArrayList();
                for (Collection<WayPoint> collection : this.data.getLinesIterable(null)) {
                    if (!this.forceLines) {
                        object3 = null;
                    }
                    for (Object object : collection) {
                        if (!object.isLatLonKnown()) continue;
                        if (object3 != null && ((WayPoint)object).time > ((WayPoint)object3).time) {
                            d3 = ((WayPoint)object).getCoor().greatCircleDistance(((WayPoint)object3).getCoor()) / (((WayPoint)object).time - ((WayPoint)object3).time);
                            arrayList.add(d3);
                        }
                        object3 = object;
                    }
                }
                Collections.sort(arrayList);
                if (arrayList.isEmpty()) {
                    this.velocityScale.setRange(0.0, 33.333333333333336);
                } else {
                    d = (Double)arrayList.get(arrayList.size() / 20);
                    d2 = (Double)arrayList.get(arrayList.size() * 19 / 20);
                    this.velocityScale.setRange(d, d2);
                }
            } else if (this.colored == ColorMode.HDOP) {
                for (Collection collection : this.data.getLinesIterable(null)) {
                    for (WayPoint wayPoint : collection) {
                        Object object;
                        object = wayPoint.get("hdop");
                        if (object == null) continue;
                        d3 = ((Float)object).doubleValue();
                        if (d3 > d2) {
                            d2 = d3;
                        }
                        if (!(d3 < d)) continue;
                        d = d3;
                    }
                }
                if (d >= d2) {
                    this.hdopScale.setRange(0.0, 100.0);
                } else {
                    this.hdopScale.setRange(d, d2);
                }
            }
            object3 = null;
        } else {
            this.velocityScale.setRange(0.0, this.colorTracksTune);
            this.hdopScale.setRange(0.0, this.hdoprange);
        }
        double d4 = (double)System.currentTimeMillis() / 1000.0;
        if (this.colored == ColorMode.TIME) {
            Date[] dateArray = this.data.getMinMaxTimeForAllTracks();
            if (dateArray.length >= 2) {
                d = (double)dateArray[0].getTime() / 1000.0;
                d2 = (double)dateArray[1].getTime() / 1000.0;
            } else {
                d = 0.0;
                d2 = d4;
            }
            this.dateScale.setRange(d, d2);
        }
        for (Collection<WayPoint> collection : this.data.getLinesIterable(null)) {
            if (!this.forceLines) {
                object3 = null;
            }
            for (WayPoint wayPoint : collection) {
                LatLon latLon = wayPoint.getCoor();
                wayPoint.customColoring = this.neutralColor;
                if (Double.isNaN(latLon.lat()) || Double.isNaN(latLon.lon())) continue;
                Color color = null;
                if (this.colored == ColorMode.HDOP) {
                    Float f = (Float)wayPoint.get("hdop");
                    color = this.hdopScale.getColor(f);
                }
                if (object3 != null) {
                    double d5;
                    double d6 = latLon.greatCircleDistance(((WayPoint)object3).getCoor());
                    boolean bl = false;
                    switch (this.colored) {
                        case VELOCITY: {
                            d5 = wayPoint.time - ((WayPoint)object3).time;
                            if (d5 > 0.0) {
                                color = this.velocityScale.getColor(d6 / d5);
                                break;
                            }
                            color = this.velocityScale.getNoDataColor();
                            break;
                        }
                        case DIRECTION: {
                            double d7 = ((WayPoint)object3).getCoor().bearing(wayPoint.getCoor());
                            color = this.directionScale.getColor(d7);
                            break;
                        }
                        case TIME: {
                            double d8 = wayPoint.time;
                            if (d8 > 0.0 && d8 <= d4 && d2 - d > this.minTrackDurationForTimeColoring) {
                                color = this.dateScale.getColor(d8);
                                break;
                            }
                            color = this.dateScale.getNoDataColor();
                            break;
                        }
                    }
                    if (!bl && (this.maxLineLength == -1 || d6 <= (double)this.maxLineLength)) {
                        wayPoint.drawLine = true;
                        d5 = ((WayPoint)object3).getCoor().bearing(wayPoint.getCoor());
                        wayPoint.dir = (int)(d5 / Math.PI * 4.0 + 1.5) % 8;
                    } else {
                        wayPoint.drawLine = false;
                    }
                } else {
                    wayPoint.drawLine = false;
                    color = this.neutralColor;
                }
                if (color != null) {
                    wayPoint.customColoring = color;
                }
                object3 = wayPoint;
            }
        }
        if (ColorMode.HEATMAP == this.colored) {
            this.heatMapLutColor = GpxDrawHelper.createColorLut(this.heatMapDrawLowerLimit, GpxDrawHelper.selectColorMap(this.neutralColor != null ? this.neutralColor : Color.WHITE, this.heatMapDrawColorTableIdx));
            this.heatMapMapViewState = null;
        }
        this.computeCacheInSync = true;
    }

    private void drawLines(Graphics2D graphics2D, MapView mapView, List<WayPoint> list) {
        if (this.lines) {
            Point point = null;
            for (WayPoint wayPoint : list) {
                if (!wayPoint.isLatLonKnown()) {
                    point = null;
                    continue;
                }
                Point point2 = mapView.getPoint(wayPoint.getEastNorth());
                if (wayPoint.drawLine && point != null && (point.x != point2.x || point.y != point2.y)) {
                    graphics2D.setColor(wayPoint.customColoring);
                    graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
                }
                point = point2;
            }
        }
    }

    private void drawArrows(Graphics2D graphics2D, MapView mapView, List<WayPoint> list) {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        if (this.lines && this.direction && !this.alternateDirection) {
            serializable3 = null;
            serializable2 = null;
            for (WayPoint wayPoint : list) {
                if (!wayPoint.isLatLonKnown()) {
                    serializable3 = null;
                    continue;
                }
                if (!wayPoint.drawLine) continue;
                serializable = mapView.getPoint(wayPoint.getEastNorth());
                if (serializable3 != null && (serializable2 == null || ((Point)serializable).x < serializable2.x - this.delta || ((Point)serializable).x > serializable2.x + this.delta || ((Point)serializable).y < serializable2.y - this.delta || ((Point)serializable).y > serializable2.y + this.delta)) {
                    graphics2D.setColor(wayPoint.customColoring);
                    double d = Math.atan2((double)((Point)serializable).y - (double)((Point)serializable3).y, (double)((Point)serializable).x - (double)((Point)serializable3).x) + Math.PI;
                    graphics2D.drawLine(((Point)serializable).x, ((Point)serializable).y, (int)((double)((Point)serializable).x + 10.0 * Math.cos(d - PHI)), (int)((double)((Point)serializable).y + 10.0 * Math.sin(d - PHI)));
                    graphics2D.drawLine(((Point)serializable).x, ((Point)serializable).y, (int)((double)((Point)serializable).x + 10.0 * Math.cos(d + PHI)), (int)((double)((Point)serializable).y + 10.0 * Math.sin(d + PHI)));
                    serializable2 = serializable;
                }
                serializable3 = serializable;
            }
        }
        if (this.lines && this.direction && this.alternateDirection) {
            serializable3 = null;
            serializable2 = null;
            for (WayPoint wayPoint : list) {
                serializable = wayPoint.getCoor();
                if (Double.isNaN(((LatLon)serializable).lat()) || Double.isNaN(((LatLon)serializable).lon()) || !wayPoint.drawLine) continue;
                Point point = mapView.getPoint(wayPoint.getEastNorth());
                if (serializable3 != null && (serializable2 == null || point.x < serializable2.x - this.delta || point.x > serializable2.x + this.delta || point.y < serializable2.y - this.delta || point.y > serializable2.y + this.delta)) {
                    graphics2D.setColor(wayPoint.customColoring);
                    graphics2D.drawLine(point.x, point.y, point.x + dir[wayPoint.dir][0], point.y + dir[wayPoint.dir][1]);
                    graphics2D.drawLine(point.x, point.y, point.x + dir[wayPoint.dir][2], point.y + dir[wayPoint.dir][3]);
                    serializable2 = point;
                }
                serializable3 = point;
            }
        }
    }

    private void drawPoints(Graphics2D graphics2D, MapView mapView, List<WayPoint> list) {
        Serializable serializable;
        if (this.large || this.hdopCircle) {
            int n = this.largesize / 2;
            for (WayPoint wayPoint : list) {
                serializable = wayPoint.getCoor();
                if (Double.isNaN(serializable.lat()) || Double.isNaN(serializable.lon())) continue;
                Point point = mapView.getPoint(wayPoint.getEastNorth());
                if (this.hdopCircle && wayPoint.get("hdop") != null) {
                    float f = ((Float)wayPoint.get("hdop")).floatValue();
                    if (f < 0.0f) {
                        f = 0.0f;
                    }
                    Color color = this.hdopAlpha < 0 ? wayPoint.customColoring : new Color(wayPoint.customColoring.getRGB() & 0xFFFFFF | this.hdopAlpha << 24, true);
                    graphics2D.setColor(color);
                    int n2 = mapView.getPoint((LatLon)new LatLon((double)wayPoint.getCoor().lat(), (double)(wayPoint.getCoor().lon() + 12.0 * (double)f * 360.0 / 4.0E7))).x - point.x;
                    graphics2D.drawArc(point.x - n2 / 2, point.y - n2 / 2, n2, n2, 0, 360);
                }
                if (!this.large) continue;
                if (wayPoint.customColoring != null) {
                    Color color = this.largePointAlpha < 0 ? wayPoint.customColoring : new Color(wayPoint.customColoring.getRGB() & 0xFFFFFF | this.largePointAlpha << 24, true);
                    graphics2D.setColor(color);
                }
                graphics2D.fillRect(point.x - n, point.y - n, this.largesize, this.largesize);
            }
        }
        if (!this.large && this.lines) {
            graphics2D.setColor(this.neutralColor);
            for (WayPoint wayPoint : list) {
                LatLon latLon = wayPoint.getCoor();
                if (Double.isNaN(latLon.lat()) || Double.isNaN(latLon.lon()) || wayPoint.drawLine) continue;
                serializable = mapView.getPoint(wayPoint.getEastNorth());
                graphics2D.drawRect(((Point)serializable).x, ((Point)serializable).y, 0, 0);
            }
        }
        if (!this.large && !this.lines) {
            graphics2D.setColor(this.neutralColor);
            for (WayPoint wayPoint : list) {
                LatLon latLon = wayPoint.getCoor();
                if (Double.isNaN(latLon.lat()) || Double.isNaN(latLon.lon())) continue;
                serializable = mapView.getPoint(wayPoint.getEastNorth());
                graphics2D.setColor(wayPoint.customColoring);
                graphics2D.drawRect(((Point)serializable).x, ((Point)serializable).y, 0, 0);
            }
        }
    }

    private void drawLinesAlpha(Graphics2D graphics2D, MapView mapView, List<WayPoint> list, float f) {
        Composite composite = graphics2D.getComposite();
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        int n = Utils.clamp(this.lineWidth, 1, 20);
        double d = mapView.getDist100Pixel() / 50.0;
        float f2 = (float)Utils.clamp(0.5 / d / (double)(n + 1), 0.01, 0.5) * f;
        int n2 = (int)((double)this.lineWidth / d) + 1;
        graphics2D.setStroke(new BasicStroke(n2, 1, 1));
        graphics2D.setComposite(AlphaComposite.SrcOver.derive(f2));
        Point point = null;
        for (WayPoint wayPoint : list) {
            Point point2 = mapView.getPoint(wayPoint.getEastNorth());
            if (point != null && wayPoint.drawLine && !point.equals(point2)) {
                graphics2D.setColor(wayPoint.customColoring);
                graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
            }
            point = point2;
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        graphics2D.setComposite(composite);
    }

    protected static BufferedImage createImageGradientMap(int n, int n2, Color ... colorArray) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        float[] fArray = new float[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            fArray[i] = (float)i * (1.0f / (float)colorArray.length);
        }
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(0.0f, 0.0f, n, n2, fArray, colorArray, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected static Color[] createColorLut(int n, Color ... colorArray) {
        Raster raster = GpxDrawHelper.createImageGradientMap(256, 1, colorArray).getData();
        int[] nArray = new int[1];
        Color[] colorArray2 = new Color[256];
        for (int i = 0; i < 256; ++i) {
            raster.getDataElements(i, 0, nArray);
            Color color = new Color(nArray[0]);
            int n2 = i > n ? (int)(Math.sin((double)(i - n) * 0.006159985595274104) * 255.0) : 0;
            int n3 = n2 = n2 > 0 ? 20 + n2 : 0;
            if (n2 > 255) {
                n2 = 255;
            }
            if (i > 240 && 255 == n2) {
                n2 -= i - 240;
            }
            colorArray2[i] = new Color(color.getRed(), color.getGreen(), color.getBlue(), n2);
        }
        return colorArray2;
    }

    protected static Color darkerColor(Color color, float f) {
        float f2 = (float)color.getRed() / 255.0f;
        float f3 = (float)color.getGreen() / 255.0f;
        float f4 = (float)color.getBlue() / 255.0f;
        return new Color(f2 * f, f3 * f, f4 * f);
    }

    protected static Color[] createColorFromResource(String string) {
        Object object;
        String string2 = "resource://data/gpx/" + string + ".txt";
        ArrayList<Color> arrayList = new ArrayList<Color>();
        try {
            object = new CachedFile(string2);
            Throwable throwable = null;
            try (BufferedReader bufferedReader = ((CachedFile)object).getContentReader();){
                String string3;
                while ((string3 = bufferedReader.readLine()) != null) {
                    String[] stringArray = string3.split(",");
                    if (stringArray.length < 3 || stringArray[0].startsWith("#")) continue;
                    float f = Float.parseFloat(stringArray[0]);
                    float f2 = Float.parseFloat(stringArray[1]);
                    float f3 = Float.parseFloat(stringArray[2]);
                    float f4 = f < 1.0f && f2 < 1.0f && f3 < 1.0f ? 1.0f : 255.0f;
                    arrayList.add(new Color(f / f4, f2 / f4, f3 / f4));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((CachedFile)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((CachedFile)object).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new JosmRuntimeException(iOException);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(Color.BLACK);
            arrayList.add(Color.WHITE);
        } else {
            object = (Color)arrayList.get(arrayList.size() - 1);
            arrayList.add(GpxDrawHelper.darkerColor((Color)object, 0.975f));
            arrayList.add(GpxDrawHelper.darkerColor((Color)object, 0.95f));
        }
        return GpxDrawHelper.createColorLut(0, arrayList.toArray(new Color[arrayList.size()]));
    }

    protected static Color[] selectColorMap(Color color, int n) {
        Color[] colorArray = GpxDrawHelper.createColorLut(0, color.darker(), color, color.brighter(), Color.WHITE);
        Color[] colorArray2 = GpxDrawHelper.createColorLut(0, Color.WHITE, Color.WHITE, color);
        Color[] colorArray3 = GpxDrawHelper.createColorLut(0, Color.WHITE, Color.GREEN.darker(), Color.YELLOW, Color.RED);
        Color[][] colorArrayArray = new Color[][]{colorArray, colorArray2, colorArray3, heatMapLutColorJosmInferno, heatMapLutColorJosmViridis, heatMapLutColorJosmBrown2Green, heatMapLutColorJosmRed2Blue};
        Color[] colorArray4 = colorArray;
        if (n < colorArrayArray.length) {
            colorArray4 = colorArrayArray[n];
        }
        return colorArray4;
    }

    public static ImageIcon getColorMapImageIcon(Color color, int n, int n2) {
        return new ImageIcon(GpxDrawHelper.createImageGradientMap(n2, n2, GpxDrawHelper.selectColorMap(color, n)));
    }

    private void drawHeatGrayLineMap(Graphics2D graphics2D, MapView mapView, List<WayPoint> list, Composite composite, Stroke stroke, Composite composite2, Stroke stroke2) {
        boolean bl = composite != null && stroke != null;
        graphics2D.setStroke(stroke2);
        graphics2D.setComposite(composite2);
        WayPoint wayPoint = !list.isEmpty() ? list.get(list.size() - 1) : null;
        for (WayPoint wayPoint2 : list) {
            Point point = mapView.getPoint(wayPoint2.getEastNorth());
            if (!wayPoint2.drawLine || wayPoint == wayPoint2) {
                int[] nArray = this.heatMapPolyX.stream().mapToInt(Integer::intValue).toArray();
                int[] nArray2 = this.heatMapPolyY.stream().mapToInt(Integer::intValue).toArray();
                graphics2D.drawPolyline(nArray, nArray2, nArray.length);
                if (bl && this.heatMapDrawExtraLine) {
                    graphics2D.setStroke(stroke);
                    graphics2D.setComposite(composite);
                    graphics2D.drawPolyline(nArray, nArray2, nArray.length);
                    graphics2D.setStroke(stroke2);
                    graphics2D.setComposite(composite2);
                }
                this.heatMapPolyX.clear();
                this.heatMapPolyY.clear();
            }
            this.heatMapPolyX.add((int)point.getX());
            this.heatMapPolyY.add((int)point.getY());
        }
    }

    private void drawHeatMapGrayMap(Graphics2D graphics2D, BufferedImage bufferedImage, int n, int n2) {
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n3 = Math.max(1, n);
        int n4 = Math.max(1, n);
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        boolean bl = n2 > 0 && (0 == n || n > 10);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(n2));
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < n6; i += n4) {
            int n9 = n5 * (i + 0);
            int n10 = n5 * (i + 1);
            for (int j = 0; j < n5; j += n3) {
                int n11;
                int n12 = 0;
                int n13 = 0;
                int n14 = n9 + j;
                for (n11 = 0; n11 < n3 && n14 + n11 < n10; ++n11) {
                    n12 += nArray[n14 + n11] & 0xFF;
                    ++n13;
                }
                int n15 = n12 = n13 > 0 ? n12 / n13 : 0;
                if (0 == j) {
                    n7 = 0;
                    n8 = n12 - 1;
                }
                n11 = (n11 = 0) != 0 || n8 == 0 || n12 == 0 ? 1 : 0;
                n11 = n11 != 0 || Math.abs(n8 - n12) > 0 ? 1 : 0;
                int n16 = n11 = n11 != 0 || i >= n6 - n4 ? 1 : 0;
                if (n11 == 0) continue;
                if (n8 > 0) {
                    graphics2D.setColor(this.heatMapLutColor[n8]);
                    if (bl) {
                        graphics2D.drawRect(n7, i, n3 + j - n7, n4);
                    } else {
                        graphics2D.fillRect(n7, i, n3 + j - n7, n4);
                    }
                }
                n7 = j;
                n8 = n12;
            }
        }
        graphics2D.setStroke(stroke);
    }

    private void drawHeatMap(Graphics2D graphics2D, MapView mapView, List<WayPoint> list) {
        boolean bl;
        int n;
        boolean bl2;
        Rectangle rectangle = new Rectangle(mapView.getWidth(), mapView.getHeight());
        MapViewState mapViewState = mapView.getState();
        double d = mapView.getDist100Pixel() / 50.0;
        int n2 = 0 == this.lineWidth ? 1 : Utils.clamp(this.lineWidth, 1, 20);
        boolean bl3 = bl2 = null == this.heatMapImgGray || !this.heatMapCacheScreenBounds.equals(rectangle);
        if (bl2) {
            this.heatMapImgGray = new BufferedImage(rectangle.width, rectangle.height, 2);
            this.heatMapGraph2d = this.heatMapImgGray.createGraphics();
            this.heatMapGraph2d.setBackground(new Color(0, 0, 0, 255));
            this.heatMapGraph2d.setColor(Color.WHITE);
            this.heatMapGraph2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.heatMapGraph2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            this.heatMapGraph2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            this.heatMapGraph2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            this.heatMapGraph2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            this.heatMapGraph2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            this.heatMapGraph2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            this.heatMapCacheScreenBounds = rectangle;
        }
        int n3 = (n = (int)Math.max(1.5 * ((double)n2 / d) + 1.0, 2.0)) > 2 ? n2 - 1 : 0;
        float f = (float)Utils.clamp(0.4 / d / (double)(n2 + 1), 0.01, 0.4);
        float f2 = 1.0f + (float)this.heatMapDrawGain / 10.0f * 0.85f;
        float f3 = (float)Utils.clamp((double)f * 0.65 * (double)f2, 0.001, 0.9);
        float f4 = (float)Utils.clamp((double)f * 1.0 * (double)f2, 0.001, 0.9);
        float f5 = (float)Utils.clamp((double)f / 1.5 * (double)f2, 0.001, 0.9);
        boolean bl4 = bl = !mapViewState.equalsInWindow(this.heatMapMapViewState) || this.gpxLayerInvalidated || this.heatMapCacheLineWith != n2;
        if (bl2 || bl) {
            this.heatMapGraph2d.clearRect(0, 0, this.heatMapImgGray.getWidth(), this.heatMapImgGray.getHeight());
            if (this.heatMapDrawPointMode) {
                this.heatMapGraph2d.setComposite(AlphaComposite.SrcOver.derive(f3));
                GpxDrawHelper.drawHeatGrayDotMap(this.heatMapGraph2d, mapView, list, n);
            } else {
                this.drawHeatGrayLineMap(this.heatMapGraph2d, mapView, list, n3 > 1 ? AlphaComposite.SrcOver.derive(f5) : null, new BasicStroke(n3, 1, 1), AlphaComposite.SrcOver.derive(f4), new BasicStroke(n, 1, 1));
            }
            this.heatMapMapViewState = mapViewState;
            this.heatMapCacheLineWith = n2;
            this.gpxLayerInvalidated = false;
        }
        this.drawHeatMapGrayMap(graphics2D, this.heatMapImgGray, n > 2 ? (int)((float)n * 1.25f) : 1, this.lineWidth > 2 ? this.lineWidth - 2 : 1);
    }

    private static void drawHeatGrayDotMap(Graphics2D graphics2D, MapView mapView, List<WayPoint> list, int n) {
        double d = list.size();
        double d2 = Math.min(d > 25000.0 ? (d - 25000.0) / d : 0.0, (double)0.7f);
        double d3 = 100.0 / mapView.getDist100Pixel() * 2.168;
        double d4 = 100.0 / mapView.getDist100Pixel() * 4.218;
        Point point = null;
        for (WayPoint wayPoint : list) {
            Point point2 = mapView.getPoint(wayPoint.getEastNorth());
            if (wayPoint.drawLine && null != point) {
                GpxDrawHelper.drawHeatSurfaceLine(graphics2D, point2, point, n, d3, d4, d2);
            }
            point = point2;
        }
    }

    private static void drawHeatSurfaceLine(Graphics2D graphics2D, Point point, Point point2, int n, double d, double d2, double d3) {
        int n2 = (int)point.getX();
        int n3 = (int)(point2.getX() - (double)n2);
        int n4 = (int)point.getY();
        int n5 = (int)(point2.getY() - (double)n4);
        Random random = new Random(n2 + n4 + n3 + n5);
        int n6 = (int)Math.abs(point.distance(point2));
        double d4 = Math.max(1.0f / (float)n6, n6 > 100 ? 0.1f : 0.2f);
        int n7 = Math.min(n / 2, 1) + 1;
        d *= 1.0 - d3;
        d2 *= 1.0 - d3;
        for (double d5 = 0.0; d5 < 0.9999; d5 += d4) {
            double d6 = (double)n2 + d5 * (double)n3;
            double d7 = (double)n4 + d5 * (double)n5;
            for (int i = 0; i < n7; ++i) {
                int n8 = (int)(d6 + random.nextGaussian() * (i > 0 ? d : d / 4.0));
                int n9 = (int)(d7 + random.nextGaussian() * (i > 0 ? d2 : d2 / 4.0));
                if (!(random.nextDouble() >= d3)) continue;
                graphics2D.fillRect(n8 - n, n9 - n, n, n);
            }
        }
    }

    private void fixColors(List<WayPoint> list) {
        for (WayPoint wayPoint : list) {
            if (wayPoint.customColoring != null) continue;
            wayPoint.customColoring = this.neutralColor;
        }
    }

    private void checkCache() {
        if (this.computeCacheMaxLineLengthUsed != this.maxLineLength || this.computeCacheColored != this.colored || this.computeCacheColorTracksTune != this.colorTracksTune || this.computeCacheColorDynamic != this.colorModeDynamic || this.computeCacheHeatMapDrawColorTableIdx != this.heatMapDrawColorTableIdx || !this.neutralColor.equals(this.computeCacheColorUsed) || this.computeCacheHeatMapDrawPointMode != this.heatMapDrawPointMode || this.computeCacheHeatMapDrawGain != this.heatMapDrawGain || this.computeCacheHeatMapDrawLowerLimit != this.heatMapDrawLowerLimit) {
            this.computeCacheMaxLineLengthUsed = this.maxLineLength;
            this.computeCacheInSync = false;
            this.computeCacheColorUsed = this.neutralColor;
            this.computeCacheColored = this.colored;
            this.computeCacheColorTracksTune = this.colorTracksTune;
            this.computeCacheColorDynamic = this.colorModeDynamic;
            this.computeCacheHeatMapDrawColorTableIdx = this.heatMapDrawColorTableIdx;
            this.computeCacheHeatMapDrawPointMode = this.heatMapDrawPointMode;
            this.computeCacheHeatMapDrawGain = this.heatMapDrawGain;
            this.computeCacheHeatMapDrawLowerLimit = this.heatMapDrawLowerLimit;
        }
    }

    @Override
    public void gpxDataChanged(GpxData.GpxDataChangeEvent gpxDataChangeEvent) {
        this.computeCacheInSync = false;
    }

    public void drawColorBar(Graphics2D graphics2D, MapView mapView) {
        int n = mapView.getWidth();
        graphics2D.setComposite(AlphaComposite.SrcOver.derive(1.0f));
        if (this.colored == ColorMode.HDOP) {
            this.hdopScale.drawColorBar(graphics2D, n - 30, 50, 20, 100, 1.0);
        } else if (this.colored == ColorMode.VELOCITY) {
            SystemOfMeasurement systemOfMeasurement = SystemOfMeasurement.getSystemOfMeasurement();
            this.velocityScale.drawColorBar(graphics2D, n - 30, 50, 20, 100, systemOfMeasurement.speedValue);
        } else if (this.colored == ColorMode.DIRECTION) {
            this.directionScale.drawColorBar(graphics2D, n - 30, 50, 20, 100, 57.29577951308232);
        }
    }

    @Override
    public void paintableInvalidated(MapViewPaintable.PaintableInvalidationEvent paintableInvalidationEvent) {
        this.gpxLayerInvalidated = true;
    }

    @Override
    public void detachFromMapView(MapViewPaintable.MapViewEvent mapViewEvent) {
        SystemOfMeasurement.removeSoMChangeListener(this);
        this.layer.removeInvalidationListener(this);
        this.data.removeChangeListener(this);
    }

    public static enum ColorMode {
        NONE,
        VELOCITY,
        HDOP,
        DIRECTION,
        TIME,
        HEATMAP;


        static ColorMode fromIndex(int n) {
            return ColorMode.values()[n];
        }

        int toIndex() {
            return Arrays.asList(ColorMode.values()).indexOf((Object)this);
        }
    }
}

