/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.gunit.GrammarInfo;
import org.antlr.gunit.gUnitTestInput;
import org.antlr.gunit.gUnitTestSuite;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class JUnitCodeGen {
    public GrammarInfo grammarInfo;
    public Map<String, String> ruleWithReturn;
    private String outputDirectoryPath = ".";
    private static final Handler console = new ConsoleHandler();
    private static final Logger logger = Logger.getLogger(JUnitCodeGen.class.getName());

    public JUnitCodeGen(GrammarInfo grammarInfo) throws ClassNotFoundException {
        this(grammarInfo, JUnitCodeGen.determineClassLoader());
    }

    private static ClassLoader determineClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = JUnitCodeGen.class.getClassLoader();
        }
        return classLoader;
    }

    public JUnitCodeGen(GrammarInfo grammarInfo, ClassLoader classLoader) throws ClassNotFoundException {
        Method[] methodArray;
        this.grammarInfo = grammarInfo;
        this.ruleWithReturn = new HashMap<String, String>();
        Class clazz = this.locateParserClass(grammarInfo, classLoader);
        Method[] methodArray2 = methodArray = clazz.getDeclaredMethods();
        int n = methodArray2.length;
        for (int i = 0; i < n; ++i) {
            Method method = methodArray2[i];
            if (method.getReturnType().getName().equals("void")) continue;
            this.ruleWithReturn.put(method.getName(), method.getReturnType().getName().replace('$', '.'));
        }
    }

    private Class locateParserClass(GrammarInfo grammarInfo, ClassLoader classLoader) throws ClassNotFoundException {
        String string = grammarInfo.getGrammarName() + "Parser";
        if (grammarInfo.getHeader() != null) {
            string = grammarInfo.getHeader() + "." + string;
        }
        return classLoader.loadClass(string);
    }

    public String getOutputDirectoryPath() {
        return this.outputDirectoryPath;
    }

    public void setOutputDirectoryPath(String string) {
        this.outputDirectoryPath = string;
    }

    public void compile() throws IOException {
        String string = this.grammarInfo.getTreeGrammarName() != null ? "Test" + this.grammarInfo.getTreeGrammarName() : "Test" + this.grammarInfo.getGrammarName();
        String string2 = this.grammarInfo.getGrammarName() + "Lexer";
        String string3 = this.grammarInfo.getGrammarName() + "Parser";
        CommonGroupLoader commonGroupLoader = new CommonGroupLoader("org/antlr/gunit", null);
        StringTemplateGroup.registerGroupLoader(commonGroupLoader);
        StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
        StringBuffer stringBuffer = this.compileToBuffer(string, string2, string3);
        this.writeTestFile(".", string + ".java", stringBuffer.toString());
    }

    public StringBuffer compileToBuffer(String string, String string2, String string3) {
        StringTemplateGroup stringTemplateGroup = StringTemplateGroup.loadGroup("junit");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.genClassHeader(stringTemplateGroup, string, string2, string3));
        stringBuffer.append(this.genTestRuleMethods(stringTemplateGroup));
        stringBuffer.append("\n\n}");
        return stringBuffer;
    }

    protected String genClassHeader(StringTemplateGroup stringTemplateGroup, String string, String string2, String string3) {
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("classHeader");
        if (this.grammarInfo.getHeader() != null) {
            stringTemplate.setAttribute("header", "package " + this.grammarInfo.getHeader() + ";");
        }
        stringTemplate.setAttribute("junitFileName", string);
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        boolean bl = false;
        boolean bl2 = false;
        if (this.grammarInfo.getHeader() != null) {
            bl2 = true;
            string7 = "./" + this.grammarInfo.getHeader().replace('.', '/');
            string4 = this.grammarInfo.getHeader() + "." + string2;
            string5 = this.grammarInfo.getHeader() + "." + string3;
            if (this.grammarInfo.getTreeGrammarName() != null) {
                string6 = this.grammarInfo.getHeader() + "." + this.grammarInfo.getTreeGrammarName();
                bl = true;
            }
        } else {
            string4 = string2;
            string5 = string3;
            if (this.grammarInfo.getTreeGrammarName() != null) {
                string6 = this.grammarInfo.getTreeGrammarName();
                bl = true;
            }
        }
        stringTemplate.setAttribute("hasPackage", new Boolean(bl2));
        stringTemplate.setAttribute("packagePath", string7);
        stringTemplate.setAttribute("lexerPath", string4);
        stringTemplate.setAttribute("parserPath", string5);
        stringTemplate.setAttribute("treeParserPath", string6);
        stringTemplate.setAttribute("isTreeGrammar", new Boolean(bl));
        return stringTemplate.toString();
    }

    protected String genTestRuleMethods(StringTemplateGroup stringTemplateGroup) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.grammarInfo.getTreeGrammarName() != null) {
            Iterator<gUnitTestSuite> iterator = this.grammarInfo.getRuleTestSuites().iterator();
            while (iterator.hasNext()) {
                gUnitTestSuite gUnitTestSuite2 = iterator.next();
                int n = 0;
                Iterator<gUnitTestInput> iterator2 = gUnitTestSuite2.testSuites.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string;
                    String string2;
                    StringTemplate stringTemplate;
                    gUnitTestInput gUnitTestInput2 = iterator2.next();
                    ++n;
                    if (gUnitTestSuite2.testSuites.get(gUnitTestInput2).getType() == 7 && this.ruleWithReturn.containsKey(gUnitTestSuite2.getTreeRuleName())) {
                        stringTemplate = stringTemplateGroup.getInstanceOf("testTreeRuleMethod2");
                        string2 = JUnitCodeGen.escapeForJava(gUnitTestInput2.testInput);
                        string = gUnitTestSuite2.testSuites.get(gUnitTestInput2).getText();
                        stringTemplate.setAttribute("methodName", "test" + this.changeFirstCapital(gUnitTestSuite2.getTreeRuleName()) + "_walks_" + this.changeFirstCapital(gUnitTestSuite2.getRuleName()) + n);
                        stringTemplate.setAttribute("testTreeRuleName", '\"' + gUnitTestSuite2.getTreeRuleName() + '\"');
                        stringTemplate.setAttribute("testRuleName", '\"' + gUnitTestSuite2.getRuleName() + '\"');
                        stringTemplate.setAttribute("testInput", '\"' + string2 + '\"');
                        stringTemplate.setAttribute("returnType", this.ruleWithReturn.get(gUnitTestSuite2.getTreeRuleName()));
                        stringTemplate.setAttribute("isFile", new Boolean(gUnitTestInput2.inputIsFile));
                        stringTemplate.setAttribute("expecting", string);
                    } else {
                        stringTemplate = stringTemplateGroup.getInstanceOf("testTreeRuleMethod");
                        string2 = JUnitCodeGen.escapeForJava(gUnitTestInput2.testInput);
                        string = gUnitTestSuite2.testSuites.get(gUnitTestInput2).getText();
                        stringTemplate.setAttribute("methodName", "test" + this.changeFirstCapital(gUnitTestSuite2.getTreeRuleName()) + "_walks_" + this.changeFirstCapital(gUnitTestSuite2.getRuleName()) + n);
                        stringTemplate.setAttribute("testTreeRuleName", '\"' + gUnitTestSuite2.getTreeRuleName() + '\"');
                        stringTemplate.setAttribute("testRuleName", '\"' + gUnitTestSuite2.getRuleName() + '\"');
                        stringTemplate.setAttribute("testInput", '\"' + string2 + '\"');
                        stringTemplate.setAttribute("isFile", new Boolean(gUnitTestInput2.inputIsFile));
                        stringTemplate.setAttribute("tokenType", this.getTypeString(gUnitTestSuite2.testSuites.get(gUnitTestInput2).getType()));
                        if (gUnitTestSuite2.testSuites.get(gUnitTestInput2).getType() == 7) {
                            stringTemplate.setAttribute("expecting", string);
                        } else if (gUnitTestSuite2.testSuites.get(gUnitTestInput2).getType() == 10) {
                            stringTemplate.setAttribute("expecting", string);
                        } else {
                            stringTemplate.setAttribute("expecting", '\"' + JUnitCodeGen.escapeForJava(string) + '\"');
                        }
                    }
                    stringBuffer.append(stringTemplate.toString());
                }
            }
        } else {
            Iterator<gUnitTestSuite> iterator = this.grammarInfo.getRuleTestSuites().iterator();
            while (iterator.hasNext()) {
                gUnitTestSuite gUnitTestSuite3 = iterator.next();
                int n = 0;
                Iterator<gUnitTestInput> iterator3 = gUnitTestSuite3.testSuites.keySet().iterator();
                while (iterator3.hasNext()) {
                    String string;
                    String string3;
                    StringTemplate stringTemplate;
                    gUnitTestInput gUnitTestInput3 = iterator3.next();
                    ++n;
                    if (gUnitTestSuite3.testSuites.get(gUnitTestInput3).getType() == 7 && this.ruleWithReturn.containsKey(gUnitTestSuite3.getRuleName())) {
                        stringTemplate = stringTemplateGroup.getInstanceOf("testRuleMethod2");
                        string3 = JUnitCodeGen.escapeForJava(gUnitTestInput3.testInput);
                        string = gUnitTestSuite3.testSuites.get(gUnitTestInput3).getText();
                        stringTemplate.setAttribute("methodName", "test" + this.changeFirstCapital(gUnitTestSuite3.getRuleName()) + n);
                        stringTemplate.setAttribute("testRuleName", '\"' + gUnitTestSuite3.getRuleName() + '\"');
                        stringTemplate.setAttribute("testInput", '\"' + string3 + '\"');
                        stringTemplate.setAttribute("returnType", this.ruleWithReturn.get(gUnitTestSuite3.getRuleName()));
                        stringTemplate.setAttribute("isFile", new Boolean(gUnitTestInput3.inputIsFile));
                        stringTemplate.setAttribute("expecting", string);
                    } else {
                        string3 = gUnitTestSuite3.isLexicalRule() ? gUnitTestSuite3.getLexicalRuleName() : gUnitTestSuite3.getRuleName();
                        stringTemplate = stringTemplateGroup.getInstanceOf("testRuleMethod");
                        string = JUnitCodeGen.escapeForJava(gUnitTestInput3.testInput);
                        String string4 = gUnitTestSuite3.testSuites.get(gUnitTestInput3).getText();
                        stringTemplate.setAttribute("isLexicalRule", new Boolean(gUnitTestSuite3.isLexicalRule()));
                        stringTemplate.setAttribute("methodName", "test" + this.changeFirstCapital(string3) + n);
                        stringTemplate.setAttribute("testRuleName", '\"' + string3 + '\"');
                        stringTemplate.setAttribute("testInput", '\"' + string + '\"');
                        stringTemplate.setAttribute("isFile", new Boolean(gUnitTestInput3.inputIsFile));
                        stringTemplate.setAttribute("tokenType", this.getTypeString(gUnitTestSuite3.testSuites.get(gUnitTestInput3).getType()));
                        if (gUnitTestSuite3.testSuites.get(gUnitTestInput3).getType() == 7) {
                            stringTemplate.setAttribute("expecting", string4);
                        } else if (gUnitTestSuite3.testSuites.get(gUnitTestInput3).getType() == 10) {
                            stringTemplate.setAttribute("expecting", string4);
                        } else {
                            stringTemplate.setAttribute("expecting", '\"' + JUnitCodeGen.escapeForJava(string4) + '\"');
                        }
                    }
                    stringBuffer.append(stringTemplate.toString());
                }
            }
        }
        return stringBuffer.toString();
    }

    public String getTypeString(int n) {
        String string;
        switch (n) {
            case 4: {
                string = "org.antlr.gunit.gUnitParser.OK";
                break;
            }
            case 5: {
                string = "org.antlr.gunit.gUnitParser.FAIL";
                break;
            }
            case 11: {
                string = "org.antlr.gunit.gUnitParser.STRING";
                break;
            }
            case 12: {
                string = "org.antlr.gunit.gUnitParser.ML_STRING";
                break;
            }
            case 10: {
                string = "org.antlr.gunit.gUnitParser.RETVAL";
                break;
            }
            case 13: {
                string = "org.antlr.gunit.gUnitParser.AST";
                break;
            }
            default: {
                string = "org.antlr.gunit.gUnitParser.EOF";
            }
        }
        return string;
    }

    protected void writeTestFile(String string, String string2, String string3) {
        try {
            File file = new File(string, string2);
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string3);
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "can't write file", iOException);
        }
    }

    public static String escapeForJava(String string) {
        string = string.replace("\\", "\\\\");
        string = string.replace("\"", "\\\"");
        string = string.replace("\n", "\\n").replace("\t", "\\t").replace("\r", "\\r").replace("\b", "\\b").replace("\f", "\\f");
        return string;
    }

    protected String changeFirstCapital(String string) {
        String string2 = String.valueOf(string.charAt(0));
        return string2.toUpperCase() + string.substring(1);
    }

    static {
        logger.addHandler(console);
    }
}

