/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.Base64;
import com.eteks.sweethome3d.io.ContentDigestManager;
import com.eteks.sweethome3d.io.DefaultLibrary;
import com.eteks.sweethome3d.io.URLContentClassLoader;
import com.eteks.sweethome3d.model.CatalogDoorOrWindow;
import com.eteks.sweethome3d.model.CatalogLight;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.Library;
import com.eteks.sweethome3d.model.LightSource;
import com.eteks.sweethome3d.model.Sash;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFurnitureCatalog
extends FurnitureCatalog {
    public static final String PLUGIN_FURNITURE_CATALOG_FAMILY = "PluginFurnitureCatalog";
    private static final String CONTRIBUTED_FURNITURE_CATALOG_FAMILY = "ContributedFurnitureCatalog";
    private static final String ADDITIONAL_FURNITURE_CATALOG_FAMILY = "AdditionalFurnitureCatalog";
    private List<Library> libraries;
    private static final Map<File, URL> pluginFurnitureCatalogUrlUpdates = new HashMap<File, URL>();

    public DefaultFurnitureCatalog() {
        this((File)null);
    }

    public DefaultFurnitureCatalog(File file) {
        this(null, file);
    }

    public DefaultFurnitureCatalog(UserPreferences userPreferences, File file) {
        File[] fileArray;
        if (file == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        this(userPreferences, fileArray);
    }

    public DefaultFurnitureCatalog(UserPreferences userPreferences, File[] fileArray) {
        this.libraries = new ArrayList<Library>();
        HashMap<FurnitureCategory, Map<CatalogPieceOfFurniture, Integer>> hashMap = new HashMap<FurnitureCategory, Map<CatalogPieceOfFurniture, Integer>>();
        ArrayList<String> arrayList = new ArrayList<String>();
        this.readDefaultFurnitureCatalogs(userPreferences, hashMap, arrayList);
        if (fileArray != null) {
            for (File file : fileArray) {
                File[] fileArray2 = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isFile();
                    }
                });
                if (fileArray2 == null) continue;
                Arrays.sort(fileArray2, Collections.reverseOrder(OperatingSystem.getFileVersionComparator()));
                for (File file2 : fileArray2) {
                    this.readPluginFurnitureCatalog(file2, arrayList);
                }
            }
        }
    }

    public DefaultFurnitureCatalog(URL[] uRLArray) {
        this(uRLArray, null);
    }

    public DefaultFurnitureCatalog(URL[] uRLArray, URL uRL) {
        this.libraries = new ArrayList<Library>();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkCreateClassLoader();
            }
            for (URL uRL2 : uRLArray) {
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(PLUGIN_FURNITURE_CATALOG_FAMILY, Locale.getDefault(), new URLContentClassLoader(uRL2));
                    this.libraries.add(0, new DefaultLibrary(uRL2.toExternalForm(), "Furniture library", resourceBundle));
                    this.readFurniture(resourceBundle, uRL2, uRL, arrayList);
                }
                catch (MissingResourceException missingResourceException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        catch (AccessControlException accessControlException) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(PLUGIN_FURNITURE_CATALOG_FAMILY, Locale.getDefault());
            this.readFurniture(resourceBundle, null, uRL, arrayList);
        }
    }

    public List<Library> getLibraries() {
        return Collections.unmodifiableList(this.libraries);
    }

    private void readPluginFurnitureCatalog(File file, List<String> list) {
        try {
            Object object;
            Object object2;
            Object object3;
            long l = file.lastModified();
            URL uRL = pluginFurnitureCatalogUrlUpdates.get(file);
            if (file.canWrite() && (uRL == null || uRL.openConnection().getLastModified() < l)) {
                object3 = TemporaryURLContent.copyToTemporaryURLContent(new URLContent(file.toURI().toURL()));
                object2 = ((URLContent)object3).getURL();
                pluginFurnitureCatalogUrlUpdates.put(file, (URL)object2);
                object = object2;
            } else {
                object = uRL != null ? uRL : file.toURI().toURL();
            }
            object3 = new URLContentClassLoader((URL)object);
            object2 = ResourceBundle.getBundle(PLUGIN_FURNITURE_CATALOG_FAMILY, Locale.getDefault(), (ClassLoader)object3);
            this.libraries.add(0, new DefaultLibrary(file.getCanonicalPath(), "Furniture library", (ResourceBundle)object2));
            this.readFurniture((ResourceBundle)object2, (URL)object, null, list);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readDefaultFurnitureCatalogs(UserPreferences userPreferences, Map<FurnitureCategory, Map<CatalogPieceOfFurniture, Integer>> map, List<String> list) {
        String string = DefaultFurnitureCatalog.class.getName();
        this.readFurnitureCatalog(string, userPreferences, map, list);
        String string2 = string.substring(0, string.lastIndexOf("."));
        this.readFurnitureCatalog(string2 + "." + CONTRIBUTED_FURNITURE_CATALOG_FAMILY, userPreferences, map, list);
        this.readFurnitureCatalog(string2 + "." + ADDITIONAL_FURNITURE_CATALOG_FAMILY, userPreferences, map, list);
    }

    private void readFurnitureCatalog(final String string, final UserPreferences userPreferences, Map<FurnitureCategory, Map<CatalogPieceOfFurniture, Integer>> map, List<String> list) {
        ResourceBundle resourceBundle;
        if (userPreferences != null) {
            resourceBundle = new ResourceBundle(){

                @Override
                protected Object handleGetObject(String string2) {
                    try {
                        return userPreferences.getLocalizedString(string, string2, new Object[0]);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new MissingResourceException("Unknown key " + string2, string + "_" + Locale.getDefault(), string2);
                    }
                }

                @Override
                public Enumeration<String> getKeys() {
                    throw new UnsupportedOperationException();
                }
            };
        } else {
            try {
                resourceBundle = ResourceBundle.getBundle(string);
            }
            catch (MissingResourceException missingResourceException) {
                return;
            }
        }
        this.readFurniture(resourceBundle, null, null, list);
    }

    private void readFurniture(ResourceBundle resourceBundle, URL uRL, URL uRL2, List<String> list) {
        CatalogPieceOfFurniture catalogPieceOfFurniture;
        int n = 1;
        while ((catalogPieceOfFurniture = this.readPieceOfFurniture(resourceBundle, n, uRL, uRL2)) != null) {
            block4: {
                block3: {
                    if (catalogPieceOfFurniture.getId() == null) break block3;
                    if (list.contains(catalogPieceOfFurniture.getId())) break block4;
                    list.add(catalogPieceOfFurniture.getId());
                }
                FurnitureCategory furnitureCategory = this.readFurnitureCategory(resourceBundle, n);
                this.add(furnitureCategory, catalogPieceOfFurniture);
            }
            ++n;
        }
    }

    protected CatalogPieceOfFurniture readPieceOfFurniture(ResourceBundle resourceBundle, int n, URL uRL, URL uRL2) {
        String string = null;
        try {
            string = resourceBundle.getString(PropertyKey.NAME.getKey(n));
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        String string2 = this.getOptionalString(resourceBundle, PropertyKey.ID.getKey(n), null);
        String string3 = this.getOptionalString(resourceBundle, PropertyKey.DESCRIPTION.getKey(n), null);
        String string4 = this.getOptionalString(resourceBundle, PropertyKey.INFORMATION.getKey(n), null);
        String string5 = this.getOptionalString(resourceBundle, PropertyKey.TAGS.getKey(n), null);
        String[] stringArray = string5 != null ? string5.split("\\s*,\\s*") : new String[]{};
        String string6 = this.getOptionalString(resourceBundle, PropertyKey.CREATION_DATE.getKey(n), null);
        Long l = null;
        if (string6 != null) {
            try {
                l = new SimpleDateFormat("yyyy-MM-dd").parse(string6).getTime();
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException("Can't parse date " + string6, parseException);
            }
        }
        String string7 = this.getOptionalString(resourceBundle, PropertyKey.GRADE.getKey(n), null);
        Float f = null;
        if (string7 != null) {
            f = Float.valueOf(string7);
        }
        Content content = this.getContent(resourceBundle, PropertyKey.ICON.getKey(n), PropertyKey.ICON_DIGEST.getKey(n), uRL, uRL2, false, false);
        Content content2 = this.getContent(resourceBundle, PropertyKey.PLAN_ICON.getKey(n), PropertyKey.PLAN_ICON_DIGEST.getKey(n), uRL, uRL2, false, true);
        boolean bl = this.getOptionalBoolean(resourceBundle, PropertyKey.MULTI_PART_MODEL.getKey(n), false);
        Content content3 = this.getContent(resourceBundle, PropertyKey.MODEL.getKey(n), PropertyKey.MODEL_DIGEST.getKey(n), uRL, uRL2, bl, false);
        float f2 = Float.parseFloat(resourceBundle.getString(PropertyKey.WIDTH.getKey(n)));
        float f3 = Float.parseFloat(resourceBundle.getString(PropertyKey.DEPTH.getKey(n)));
        float f4 = Float.parseFloat(resourceBundle.getString(PropertyKey.HEIGHT.getKey(n)));
        float f5 = this.getOptionalFloat(resourceBundle, PropertyKey.ELEVATION.getKey(n), 0.0f);
        float f6 = this.getOptionalFloat(resourceBundle, PropertyKey.DROP_ON_TOP_ELEVATION.getKey(n), f4) / f4;
        boolean bl2 = Boolean.parseBoolean(resourceBundle.getString(PropertyKey.MOVABLE.getKey(n)));
        boolean bl3 = Boolean.parseBoolean(resourceBundle.getString(PropertyKey.DOOR_OR_WINDOW.getKey(n)));
        String string8 = this.getOptionalString(resourceBundle, PropertyKey.STAIRCASE_CUT_OUT_SHAPE.getKey(n), null);
        float[][] fArray = this.getModelRotation(resourceBundle, PropertyKey.MODEL_ROTATION.getKey(n));
        String string9 = this.getOptionalString(resourceBundle, PropertyKey.CREATOR.getKey(n), null);
        boolean bl4 = this.getOptionalBoolean(resourceBundle, PropertyKey.RESIZABLE.getKey(n), true);
        boolean bl5 = this.getOptionalBoolean(resourceBundle, PropertyKey.DEFORMABLE.getKey(n), true);
        boolean bl6 = this.getOptionalBoolean(resourceBundle, PropertyKey.TEXTURABLE.getKey(n), true);
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(resourceBundle.getString(PropertyKey.PRICE.getKey(n)));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        BigDecimal bigDecimal2 = null;
        try {
            bigDecimal2 = new BigDecimal(resourceBundle.getString(PropertyKey.VALUE_ADDED_TAX_PERCENTAGE.getKey(n)));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        String string10 = this.getOptionalString(resourceBundle, PropertyKey.CURRENCY.getKey(n), null);
        if (bl3) {
            String string11 = this.getOptionalString(resourceBundle, PropertyKey.DOOR_OR_WINDOW_CUT_OUT_SHAPE.getKey(n), null);
            float f7 = this.getOptionalFloat(resourceBundle, PropertyKey.DOOR_OR_WINDOW_WALL_THICKNESS.getKey(n), f3) / f3;
            float f8 = this.getOptionalFloat(resourceBundle, PropertyKey.DOOR_OR_WINDOW_WALL_DISTANCE.getKey(n), 0.0f) / f3;
            Sash[] sashArray = this.getDoorOrWindowSashes(resourceBundle, n, f2, f3);
            return new CatalogDoorOrWindow(string2, string, string3, string4, stringArray, l, f, content, content2, content3, f2, f3, f4, f5, f6, bl2, string11, f7, f8, sashArray, fArray, string9, bl4, bl5, bl6, bigDecimal, bigDecimal2, string10);
        }
        LightSource[] lightSourceArray = this.getLightSources(resourceBundle, n, f2, f3, f4);
        if (lightSourceArray != null) {
            return new CatalogLight(string2, string, string3, string4, stringArray, l, f, content, content2, content3, f2, f3, f4, f5, f6, bl2, lightSourceArray, string8, fArray, string9, bl4, bl5, bl6, bigDecimal, bigDecimal2, string10);
        }
        return new CatalogPieceOfFurniture(string2, string, string3, string4, stringArray, l, f, content, content2, content3, f2, f3, f4, f5, f6, bl2, string8, fArray, string9, bl4, bl5, bl6, bigDecimal, bigDecimal2, string10);
    }

    protected FurnitureCategory readFurnitureCategory(ResourceBundle resourceBundle, int n) {
        String string = resourceBundle.getString(PropertyKey.CATEGORY.getKey(n));
        return new FurnitureCategory(string);
    }

    private Content getContent(ResourceBundle resourceBundle, String string, String string2, URL uRL, URL uRL2, boolean bl, boolean bl2) {
        URLContent uRLContent;
        Object object;
        String string3;
        String string4 = string3 = bl2 ? this.getOptionalString(resourceBundle, string, null) : resourceBundle.getString(string);
        if (bl2 && string3 == null) {
            return null;
        }
        try {
            if (uRL2 == null) {
                object = new URL(string3);
            } else {
                Object object2 = object = string3.startsWith("?") ? new URL(uRL2 + string3) : new URL(uRL2, string3);
                if (string3.indexOf(33) >= 0 && !string3.startsWith("jar:")) {
                    object = new URL("jar:" + object);
                }
            }
            uRLContent = new URLContent((URL)object);
        }
        catch (MalformedURLException malformedURLException) {
            if (uRL == null) {
                uRLContent = new ResourceURLContent(DefaultFurnitureCatalog.class, string3, bl);
            }
            try {
                uRLContent = new ResourceURLContent(new URL("jar:" + uRL + "!" + string3), bl);
            }
            catch (MalformedURLException malformedURLException2) {
                throw new IllegalArgumentException("Invalid URL", malformedURLException2);
            }
        }
        object = this.getOptionalString(resourceBundle, string2, null);
        if (object != null && ((String)object).length() > 0) {
            try {
                ContentDigestManager.getInstance().setContentDigest(uRLContent, Base64.decode((String)object));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return uRLContent;
    }

    private float[][] getModelRotation(ResourceBundle resourceBundle, String string) {
        try {
            String string2 = resourceBundle.getString(string);
            String[] stringArray = string2.split(" ", 9);
            if (stringArray.length == 9) {
                return new float[][]{{Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2])}, {Float.parseFloat(stringArray[3]), Float.parseFloat(stringArray[4]), Float.parseFloat(stringArray[5])}, {Float.parseFloat(stringArray[6]), Float.parseFloat(stringArray[7]), Float.parseFloat(stringArray[8])}};
            }
            return null;
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private Sash[] getDoorOrWindowSashes(ResourceBundle resourceBundle, int n, float f, float f2) throws MissingResourceException {
        Sash[] sashArray;
        String string = this.getOptionalString(resourceBundle, PropertyKey.DOOR_OR_WINDOW_SASH_X_AXIS.getKey(n), null);
        if (string != null) {
            String[] stringArray = string.split(" ");
            String[] stringArray2 = resourceBundle.getString(PropertyKey.DOOR_OR_WINDOW_SASH_Y_AXIS.getKey(n)).split(" ");
            if (stringArray2.length != stringArray.length) {
                throw new IllegalArgumentException("Expected " + stringArray.length + " values in " + PropertyKey.DOOR_OR_WINDOW_SASH_Y_AXIS.getKey(n) + " key");
            }
            String[] stringArray3 = resourceBundle.getString(PropertyKey.DOOR_OR_WINDOW_SASH_WIDTH.getKey(n)).split(" ");
            if (stringArray3.length != stringArray.length) {
                throw new IllegalArgumentException("Expected " + stringArray.length + " values in " + PropertyKey.DOOR_OR_WINDOW_SASH_WIDTH.getKey(n) + " key");
            }
            String[] stringArray4 = resourceBundle.getString(PropertyKey.DOOR_OR_WINDOW_SASH_START_ANGLE.getKey(n)).split(" ");
            if (stringArray4.length != stringArray.length) {
                throw new IllegalArgumentException("Expected " + stringArray.length + " values in " + PropertyKey.DOOR_OR_WINDOW_SASH_START_ANGLE.getKey(n) + " key");
            }
            String[] stringArray5 = resourceBundle.getString(PropertyKey.DOOR_OR_WINDOW_SASH_END_ANGLE.getKey(n)).split(" ");
            if (stringArray5.length != stringArray.length) {
                throw new IllegalArgumentException("Expected " + stringArray.length + " values in " + PropertyKey.DOOR_OR_WINDOW_SASH_END_ANGLE.getKey(n) + " key");
            }
            sashArray = new Sash[stringArray.length];
            for (int i = 0; i < sashArray.length; ++i) {
                sashArray[i] = new Sash(Float.parseFloat(stringArray[i]) / f, Float.parseFloat(stringArray2[i]) / f2, Float.parseFloat(stringArray3[i]) / f, (float)Math.toRadians(Float.parseFloat(stringArray4[i])), (float)Math.toRadians(Float.parseFloat(stringArray5[i])));
            }
        } else {
            sashArray = new Sash[]{};
        }
        return sashArray;
    }

    private LightSource[] getLightSources(ResourceBundle resourceBundle, int n, float f, float f2, float f3) throws MissingResourceException {
        LightSource[] lightSourceArray = null;
        String string = this.getOptionalString(resourceBundle, PropertyKey.LIGHT_SOURCE_X.getKey(n), null);
        if (string != null) {
            String[] stringArray;
            String[] stringArray2 = string.split(" ");
            String[] stringArray3 = resourceBundle.getString(PropertyKey.LIGHT_SOURCE_Y.getKey(n)).split(" ");
            if (stringArray3.length != stringArray2.length) {
                throw new IllegalArgumentException("Expected " + stringArray2.length + " values in " + PropertyKey.LIGHT_SOURCE_Y.getKey(n) + " key");
            }
            String[] stringArray4 = resourceBundle.getString(PropertyKey.LIGHT_SOURCE_Z.getKey(n)).split(" ");
            if (stringArray4.length != stringArray2.length) {
                throw new IllegalArgumentException("Expected " + stringArray2.length + " values in " + PropertyKey.LIGHT_SOURCE_Z.getKey(n) + " key");
            }
            String[] stringArray5 = resourceBundle.getString(PropertyKey.LIGHT_SOURCE_COLOR.getKey(n)).split(" ");
            if (stringArray5.length != stringArray2.length) {
                throw new IllegalArgumentException("Expected " + stringArray2.length + " values in " + PropertyKey.LIGHT_SOURCE_COLOR.getKey(n) + " key");
            }
            String string2 = this.getOptionalString(resourceBundle, PropertyKey.LIGHT_SOURCE_DIAMETER.getKey(n), null);
            if (string2 != null) {
                stringArray = string2.split(" ");
                if (stringArray.length != stringArray2.length) {
                    throw new IllegalArgumentException("Expected " + stringArray2.length + " values in " + PropertyKey.LIGHT_SOURCE_DIAMETER.getKey(n) + " key");
                }
            } else {
                stringArray = null;
            }
            lightSourceArray = new LightSource[stringArray2.length];
            for (int i = 0; i < lightSourceArray.length; ++i) {
                int n2 = stringArray5[i].startsWith("#") ? Integer.parseInt(stringArray5[i].substring(1), 16) : Integer.parseInt(stringArray5[i]);
                lightSourceArray[i] = new LightSource(Float.parseFloat(stringArray2[i]) / f, Float.parseFloat(stringArray3[i]) / f2, Float.parseFloat(stringArray4[i]) / f3, n2, stringArray != null ? Float.valueOf(Float.parseFloat(stringArray[i]) / f) : null);
            }
        }
        return lightSourceArray;
    }

    private String getOptionalString(ResourceBundle resourceBundle, String string, String string2) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    private float getOptionalFloat(ResourceBundle resourceBundle, String string, float f) {
        try {
            return Float.parseFloat(resourceBundle.getString(string));
        }
        catch (MissingResourceException missingResourceException) {
            return f;
        }
    }

    private boolean getOptionalBoolean(ResourceBundle resourceBundle, String string, boolean bl) {
        try {
            return Boolean.parseBoolean(resourceBundle.getString(string));
        }
        catch (MissingResourceException missingResourceException) {
            return bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyKey {
        ID("id"),
        NAME("name"),
        DESCRIPTION("description"),
        INFORMATION("information"),
        TAGS("tags"),
        CREATION_DATE("creationDate"),
        GRADE("grade"),
        CATEGORY("category"),
        ICON("icon"),
        ICON_DIGEST("iconDigest"),
        PLAN_ICON("planIcon"),
        PLAN_ICON_DIGEST("planIconDigest"),
        MODEL("model"),
        MODEL_DIGEST("modelDigest"),
        MULTI_PART_MODEL("multiPartModel"),
        WIDTH("width"),
        DEPTH("depth"),
        HEIGHT("height"),
        MOVABLE("movable"),
        DOOR_OR_WINDOW("doorOrWindow"),
        DOOR_OR_WINDOW_CUT_OUT_SHAPE("doorOrWindowCutOutShape"),
        DOOR_OR_WINDOW_WALL_THICKNESS("doorOrWindowWallThickness"),
        DOOR_OR_WINDOW_WALL_DISTANCE("doorOrWindowWallDistance"),
        DOOR_OR_WINDOW_SASH_X_AXIS("doorOrWindowSashXAxis"),
        DOOR_OR_WINDOW_SASH_Y_AXIS("doorOrWindowSashYAxis"),
        DOOR_OR_WINDOW_SASH_WIDTH("doorOrWindowSashWidth"),
        DOOR_OR_WINDOW_SASH_START_ANGLE("doorOrWindowSashStartAngle"),
        DOOR_OR_WINDOW_SASH_END_ANGLE("doorOrWindowSashEndAngle"),
        LIGHT_SOURCE_X("lightSourceX"),
        LIGHT_SOURCE_Y("lightSourceY"),
        LIGHT_SOURCE_Z("lightSourceZ"),
        LIGHT_SOURCE_COLOR("lightSourceColor"),
        LIGHT_SOURCE_DIAMETER("lightSourceDiameter"),
        STAIRCASE_CUT_OUT_SHAPE("staircaseCutOutShape"),
        ELEVATION("elevation"),
        DROP_ON_TOP_ELEVATION("dropOnTopElevation"),
        MODEL_ROTATION("modelRotation"),
        CREATOR("creator"),
        RESIZABLE("resizable"),
        DEFORMABLE("deformable"),
        TEXTURABLE("texturable"),
        PRICE("price"),
        VALUE_ADDED_TAX_PERCENTAGE("valueAddedTaxPercentage"),
        CURRENCY("currency");

        private String keyPrefix;

        private PropertyKey(String string2) {
            this.keyPrefix = string2;
        }

        public String getKey(int n) {
            return this.keyPrefix + "#" + n;
        }
    }
}

