/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.HelpView;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpController
implements Controller {
    private static final String SEARCH_RESULT_PROTOCOL = "search";
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final PropertyChangeSupport propertyChangeSupport;
    private final List<URL> history;
    private int historyIndex;
    private HelpView helpView;
    private URL helpPage;
    private URL browserPage;
    private boolean previousPageEnabled;
    private boolean nextPageEnabled;
    private String highlightedText;

    public HelpController(UserPreferences userPreferences, ViewFactory viewFactory) {
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.history = new ArrayList<URL>();
        this.historyIndex = -1;
        this.showPage(this.getHelpIndexPageURL());
    }

    @Override
    public HelpView getView() {
        if (this.helpView == null) {
            this.helpView = this.viewFactory.createHelpView(this.preferences, this);
            this.addLanguageListener(this.preferences);
        }
        return this.helpView;
    }

    public void displayView() {
        this.getView().displayView();
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    private void setHelpPage(URL uRL) {
        if (uRL != this.helpPage) {
            URL uRL2 = this.helpPage;
            this.helpPage = uRL;
            this.propertyChangeSupport.firePropertyChange(Property.HELP_PAGE.name(), uRL2, uRL);
        }
    }

    public URL getHelpPage() {
        return this.helpPage;
    }

    private void setBrowserPage(URL uRL) {
        if (uRL != this.browserPage) {
            URL uRL2 = this.browserPage;
            this.browserPage = uRL;
            this.propertyChangeSupport.firePropertyChange(Property.BROWSER_PAGE.name(), uRL2, uRL);
        }
    }

    public URL getBrowserPage() {
        return this.browserPage;
    }

    private void setPreviousPageEnabled(boolean bl) {
        if (bl != this.previousPageEnabled) {
            this.previousPageEnabled = bl;
            this.propertyChangeSupport.firePropertyChange(Property.PREVIOUS_PAGE_ENABLED.name(), !bl, bl);
        }
    }

    public boolean isPreviousPageEnabled() {
        return this.previousPageEnabled;
    }

    private void setNextPageEnabled(boolean bl) {
        if (bl != this.nextPageEnabled) {
            this.nextPageEnabled = bl;
            this.propertyChangeSupport.firePropertyChange(Property.NEXT_PAGE_ENABLED.name(), !bl, bl);
        }
    }

    public boolean isNextPageEnabled() {
        return this.nextPageEnabled;
    }

    public void setHighlightedText(String string) {
        if (!(string == this.highlightedText || string != null && string.equals(this.highlightedText))) {
            String string2 = this.highlightedText;
            this.highlightedText = string;
            this.propertyChangeSupport.firePropertyChange(Property.HIGHLIGHTED_TEXT.name(), string2, string);
        }
    }

    public String getHighlightedText() {
        return this.getHelpPage() == null || SEARCH_RESULT_PROTOCOL.equals(this.getHelpPage().getProtocol()) ? null : this.highlightedText;
    }

    private void addLanguageListener(UserPreferences userPreferences) {
        userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new LanguageChangeListener(this));
    }

    public void showPrevious() {
        this.setHelpPage(this.history.get(--this.historyIndex));
        this.setPreviousPageEnabled(this.historyIndex > 0);
        this.setNextPageEnabled(true);
    }

    public void showNext() {
        this.setHelpPage(this.history.get(++this.historyIndex));
        this.setPreviousPageEnabled(true);
        this.setNextPageEnabled(this.historyIndex < this.history.size() - 1);
    }

    public void showPage(URL uRL) {
        if (this.isBrowserPage(uRL)) {
            this.setBrowserPage(uRL);
        } else if (this.historyIndex == -1 || !this.history.get(this.historyIndex).equals(uRL)) {
            this.setHelpPage(uRL);
            for (int i = this.history.size() - 1; i > this.historyIndex; --i) {
                this.history.remove(i);
            }
            this.history.add(uRL);
            this.setPreviousPageEnabled(++this.historyIndex > 0);
            this.setNextPageEnabled(false);
        }
    }

    protected boolean isBrowserPage(URL uRL) {
        String string = uRL.getProtocol();
        return string.equals("http") || string.equals("https");
    }

    private URL getHelpIndexPageURL() {
        String string = this.preferences.getLocalizedString(HelpController.class, "helpIndex", new Object[0]);
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = HelpController.class.getName();
            string2 = string2.substring(0, string2.lastIndexOf(".")).replace('.', '/');
            String string3 = string.startsWith("/") ? string.substring(1) : string2 + '/' + string;
            for (ClassLoader classLoader : this.preferences.getResourceClassLoaders()) {
                try {
                    return new ResourceURLContent(classLoader, string3).getURL();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
            try {
                return new ResourceURLContent(HelpController.class, string).getURL();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                return new ResourceURLContent(HelpController.class, "resources/help/en/index.html").getURL();
            }
        }
    }

    public void search(String string) {
        URL uRL = this.getHelpIndexPageURL();
        String[] stringArray = this.getLowerCaseSearchedWords(string);
        List<HelpDocument> list = this.searchInHelpDocuments(uRL, stringArray);
        URL uRL2 = null;
        try {
            uRL2 = new ResourceURLContent(HelpController.class, "resources/help/images/applicationIcon32.png").getURL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        final StringBuilder stringBuilder = new StringBuilder("<html><head><meta http-equiv='content-type' content='text/html;charset=UTF-8'><link href='" + new ResourceURLContent(HelpController.class, "resources/help/help.css").getURL() + "' rel='stylesheet'></head><body bgcolor='#ffffff'>\n<div id='banner'><div id='helpheader'>  <a class='bread' href='" + uRL + "'> " + this.preferences.getLocalizedString(HelpController.class, "helpTitle", new Object[0]) + "</a></div></div><div id='mainbox' align='left'>  <table width='100%' border='0' cellspacing='0' cellpadding='0'>    <tr valign='bottom' height='32'>      <td width='3' height='32'>&nbsp;</td>" + (uRL2 != null ? "<td width='32' height='32'><img src='" + uRL2 + "' height='32' width='32'></td>" : "") + "      <td width='8' height='32'>&nbsp;&nbsp;</td>      <td valign='bottom' height='32'><font id='topic'>" + this.preferences.getLocalizedString(HelpController.class, "searchResult", new Object[0]) + "</font></td>    </tr>    <tr height='10'><td colspan='4' height='10'>&nbsp;</td></tr>  </table>  <table width='100%' border='0' cellspacing='0' cellpadding='3'>");
        if (list.size() == 0) {
            String string2 = this.preferences.getLocalizedString(HelpController.class, "searchNotFound", string);
            stringBuilder.append("<tr><td><p>" + string2 + "</td></tr>");
        } else {
            String string3 = this.preferences.getLocalizedString(HelpController.class, "searchFound", string);
            stringBuilder.append("<tr><td colspan='2'><p>" + string3 + "</td></tr>");
            URL uRL3 = new ResourceURLContent(HelpController.class, "resources/searchRelevance.gif").getURL();
            for (HelpDocument helpDocument : list) {
                stringBuilder.append("<tr><td valign='middle' nowrap><a href='" + helpDocument.getBase() + "'>" + helpDocument.getTitle() + "</a></td><td valign='middle'>");
                for (int i = 0; i < helpDocument.getRelevance() && i < 50; ++i) {
                    stringBuilder.append("<img src='" + uRL3 + "' width='4' height='12'>");
                }
                stringBuilder.append("</td></tr>");
            }
        }
        stringBuilder.append("</table></div></body></html>");
        try {
            this.showPage(new URL(null, "search://" + stringBuilder.hashCode(), new URLStreamHandler(){

                protected URLConnection openConnection(URL uRL) throws IOException {
                    return new URLConnection(uRL){

                        public void connect() throws IOException {
                        }

                        public InputStream getInputStream() throws IOException {
                            return new ByteArrayInputStream(stringBuilder.toString().getBytes("UTF-8"));
                        }
                    };
                }
            }));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private String[] getLowerCaseSearchedWords(String string) {
        String[] stringArray = string.split("\\s");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].toLowerCase().trim();
        }
        return stringArray;
    }

    private List<HelpDocument> searchInHelpDocuments(URL uRL, String[] stringArray) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        arrayList.add(uRL);
        ArrayList<HelpDocument> arrayList2 = new ArrayList<HelpDocument>();
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                URL uRL2 = (URL)arrayList.get(i);
                HelpDocument helpDocument = new HelpDocument(uRL2, stringArray);
                helpDocument.parse();
                if (helpDocument.getRelevance() > 0) {
                    arrayList2.add(helpDocument);
                }
                for (URL uRL3 : helpDocument.getReferencedDocuments()) {
                    String string = uRL3.getFile().toLowerCase();
                    if (!string.endsWith(".html") || arrayList.contains(uRL3)) continue;
                    arrayList.add(uRL3);
                }
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Collections.sort(arrayList2, new Comparator<HelpDocument>(){

            @Override
            public int compare(HelpDocument helpDocument, HelpDocument helpDocument2) {
                return helpDocument2.getRelevance() - helpDocument.getRelevance();
            }
        });
        return arrayList2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HelpDocument
    extends HTMLDocument {
        private Set<URL> referencedDocuments = new HashSet<URL>();
        private String[] searchedWords;
        private int relevance;
        private String title = "";

        public HelpDocument(URL uRL, String[] stringArray) {
            this.searchedWords = stringArray;
            this.setBase(uRL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse() throws IOException {
            HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
            Reader reader = null;
            try {
                reader = new InputStreamReader(this.getBase().openStream(), "ISO-8859-1");
                this.putProperty("IgnoreCharsetDirective", Boolean.FALSE);
                try {
                    hTMLEditorKit.read(reader, (Document)this, 0);
                }
                catch (ChangedCharSetException changedCharSetException) {
                    String string = changedCharSetException.getCharSetSpec();
                    String string2 = string.substring(string.indexOf("=") + 1).trim();
                    reader.close();
                    reader = new InputStreamReader(this.getBase().openStream(), string2);
                    this.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
                    hTMLEditorKit.read(reader, (Document)this, 0);
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        public Set<URL> getReferencedDocuments() {
            return this.referencedDocuments;
        }

        public int getRelevance() {
            return this.relevance;
        }

        public String getTitle() {
            return this.title;
        }

        private void addReferencedDocument(String string) {
            try {
                URL uRL = new URL(this.getBase(), string);
                if (!HelpController.this.isBrowserPage(uRL)) {
                    URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile());
                    this.referencedDocuments.add(uRL2);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }

        @Override
        public HTMLEditorKit.ParserCallback getReader(int n) {
            return new HelpReader();
        }

        private class HelpReader
        extends HTMLEditorKit.ParserCallback {
            private boolean inTitle;

            private HelpReader() {
            }

            public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
                if (tag.equals(HTML.Tag.A)) {
                    String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.HREF);
                    if (string != null) {
                        HelpDocument.this.addReferencedDocument(string);
                    }
                } else if (tag.equals(HTML.Tag.TITLE)) {
                    this.inTitle = true;
                }
            }

            public void handleEndTag(HTML.Tag tag, int n) {
                if (tag.equals(HTML.Tag.TITLE)) {
                    this.inTitle = false;
                }
            }

            public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
                if (tag.equals(HTML.Tag.META)) {
                    String string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.NAME);
                    String string2 = (String)mutableAttributeSet.getAttribute(HTML.Attribute.CONTENT);
                    if ("keywords".equalsIgnoreCase(string) && string2 != null) {
                        this.searchWords(string2);
                    }
                }
            }

            public void handleText(char[] cArray, int n) {
                String string = new String(cArray);
                if (this.inTitle) {
                    HelpDocument.this.title = HelpDocument.this.title + string;
                }
                this.searchWords(string);
            }

            private void searchWords(String string) {
                String string2 = string.toLowerCase();
                for (String string3 : HelpDocument.this.searchedWords) {
                    for (int i = 0; i < string2.length() && (i = string2.indexOf(string3, i)) != -1; i += string3.length() + 1) {
                        HelpDocument.this.relevance++;
                        if (!this.inTitle) continue;
                        HelpDocument.this.relevance++;
                    }
                }
            }
        }
    }

    private static class LanguageChangeListener
    implements PropertyChangeListener {
        private WeakReference<HelpController> helpController;

        public LanguageChangeListener(HelpController helpController) {
            this.helpController = new WeakReference<HelpController>(helpController);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HelpController helpController = (HelpController)this.helpController.get();
            if (helpController == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
            } else {
                helpController.history.clear();
                helpController.historyIndex = -1;
                helpController.showPage(helpController.getHelpIndexPageURL());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        HELP_PAGE,
        BROWSER_PAGE,
        PREVIOUS_PAGE_ENABLED,
        NEXT_PAGE_ENABLED,
        HIGHLIGHTED_TEXT;

    }
}

