/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnClassLoader;
import org.zaproxy.zap.control.AddOnCollection;
import org.zaproxy.zap.control.AddOnInstaller;
import org.zaproxy.zap.control.AddOnLoaderUtils;
import org.zaproxy.zap.control.AddOnRunIssuesUtils;
import org.zaproxy.zap.control.AddOnUninstallationProgressCallback;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;

public class AddOnLoader
extends URLClassLoader {
    public static final String ADDONS_BLOCK_LIST = "addons.block";
    private static final String ADDONS_RUNNABLE_BASE_KEY = "runnableAddOns";
    private static final String ADDONS_RUNNABLE_KEY = "runnableAddOns.addon";
    private static final String ADDON_RUNNABLE_ID_KEY = "id";
    private static final String ADDON_RUNNABLE_VERSION_KEY = "version";
    private static final String ADDON_RUNNABLE_ALL_EXTENSIONS_KEY = "extensions.extension";
    private static final AddOnUninstallationProgressCallback NULL_CALLBACK = new NullUninstallationProgressCallBack();
    private static final Logger logger = Logger.getLogger(AddOnLoader.class);
    private AddOnCollection aoc = null;
    private List<File> jars = new ArrayList<File>();
    private List<String> blockList = new ArrayList<String>();
    private Map<AddOn, List<String>> runnableAddOns;
    private List<String> idsAddOnsWithRunningIssuesSinceLastRun;
    private Map<String, AddOnClassLoader> addOnLoaders = new HashMap<String, AddOnClassLoader>();

    public AddOnLoader(File[] fileArray) {
        super(new URL[0], AddOnLoader.class.getClassLoader());
        this.loadBlockList();
        this.aoc = new AddOnCollection(fileArray);
        this.loadAllAddOns();
        if (fileArray != null) {
            for (File file : fileArray) {
                try {
                    this.addDirectory(file);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        for (File file : this.jars) {
            try {
                this.addURL(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                logger.error((Object)malformedURLException.getMessage(), (Throwable)malformedURLException);
            }
        }
        for (Map.Entry entry : this.addOnLoaders.entrySet()) {
            AddOnInstaller.installMissingAddOnFiles((AddOnClassLoader)entry.getValue(), this.getAddOnCollection().getAddOn((String)entry.getKey()));
        }
    }

    public List<String> getIdsAddOnsWithRunningIssuesSinceLastRun() {
        return Collections.unmodifiableList(this.idsAddOnsWithRunningIssuesSinceLastRun);
    }

    private void loadAllAddOns() {
        this.runnableAddOns = new HashMap<AddOn, List<String>>();
        this.idsAddOnsWithRunningIssuesSinceLastRun = new ArrayList<String>();
        Map<AddOn, List<String>> map = AddOnLoader.loadAddOnsRunState(this.aoc);
        ArrayList<AddOn> arrayList = new ArrayList<AddOn>();
        Iterator<AddOn> iterator = this.aoc.getAddOns().iterator();
        while (iterator.hasNext()) {
            AddOn addOn = iterator.next();
            if (this.canLoadAddOn(addOn)) {
                AddOn.AddOnRunRequirements addOnRunRequirements = AddOnLoader.calculateRunRequirements(addOn, this.aoc.getAddOns());
                if (addOnRunRequirements.isRunnable()) {
                    List<Object> list;
                    if (addOn.hasExtensionsWithDeps()) {
                        list = AddOnLoader.getRunnableExtensionsWithDeps(addOnRunRequirements);
                        List<String> list2 = map.get(addOn);
                        if (list2 != null && !list2.isEmpty()) {
                            list2.removeAll(list);
                            if (!list2.isEmpty()) {
                                this.idsAddOnsWithRunningIssuesSinceLastRun.add(addOn.getId());
                            }
                        }
                    } else {
                        list = Collections.emptyList();
                    }
                    this.runnableAddOns.put(addOn, list);
                    arrayList.add(addOn);
                    continue;
                }
                if (map.get(addOn) == null) continue;
                this.idsAddOnsWithRunningIssuesSinceLastRun.add(addOn.getId());
                continue;
            }
            iterator.remove();
        }
        AddOnLoader.saveAddOnsRunState(this.runnableAddOns);
        for (AddOn addOn : arrayList) {
            addOn.setInstallationStatus(AddOn.InstallationStatus.INSTALLED);
            this.createAndAddAddOnClassLoader(addOn);
        }
    }

    private static List<String> getRunnableExtensionsWithDeps(AddOn.AddOnRunRequirements addOnRunRequirements) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AddOn.ExtensionRunRequirements extensionRunRequirements : addOnRunRequirements.getExtensionRequirements()) {
            if (!extensionRunRequirements.isRunnable()) continue;
            arrayList.add(extensionRunRequirements.getClassname());
        }
        return arrayList;
    }

    private boolean canLoadAddOn(AddOn addOn) {
        if (this.blockList.contains(addOn.getId())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Can't load add-on " + addOn.getName() + " it's on the block list (add-on uninstalled but the file couldn't be removed)."));
            }
            return false;
        }
        if (!addOn.canLoadInCurrentVersion()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Can't load add-on " + addOn.getName() + " because of ZAP version constraints; Not before=" + addOn.getNotBeforeVersion() + " Not from=" + addOn.getNotFromVersion() + " Current Version=" + Constant.PROGRAM_VERSION));
            }
            return false;
        }
        return true;
    }

    private static AddOn.AddOnRunRequirements calculateRunRequirements(AddOn addOn, Collection<AddOn> collection) {
        AddOn.AddOnRunRequirements addOnRunRequirements = addOn.calculateRunRequirements(collection);
        if (!addOnRunRequirements.isRunnable() && logger.isDebugEnabled()) {
            logger.debug((Object)("Can't run add-on " + addOn.getName() + " because of missing requirements: " + AddOnRunIssuesUtils.getRunningIssues(addOnRunRequirements)));
        }
        return addOnRunRequirements;
    }

    private AddOnClassLoader createAndAddAddOnClassLoader(AddOn addOn) {
        try {
            AddOnClassLoader addOnClassLoader = this.addOnLoaders.get(addOn.getId());
            if (addOnClassLoader != null) {
                return addOnClassLoader;
            }
            List<String> list = addOn.getIdsAddOnDependencies();
            if (list.isEmpty()) {
                addOnClassLoader = new AddOnClassLoader(addOn.getFile().toURI().toURL(), (ClassLoader)this, addOn.getAddOnClassnames());
                this.addOnLoaders.put(addOn.getId(), addOnClassLoader);
                return addOnClassLoader;
            }
            ArrayList<AddOnClassLoader> arrayList = new ArrayList<AddOnClassLoader>(list.size());
            for (String string : list) {
                addOnClassLoader = this.addOnLoaders.get(string);
                if (addOnClassLoader == null) {
                    addOnClassLoader = this.createAndAddAddOnClassLoader(this.aoc.getAddOn(string));
                }
                arrayList.add(addOnClassLoader);
            }
            addOnClassLoader = new AddOnClassLoader(addOn.getFile().toURI().toURL(), this, arrayList, addOn.getAddOnClassnames());
            this.addOnLoaders.put(addOn.getId(), addOnClassLoader);
            return addOnClassLoader;
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)malformedURLException.getMessage(), (Throwable)malformedURLException);
            throw new RuntimeException("Failed to convert URL for AddOnClassLoader " + addOn.getFile().toURI(), malformedURLException);
        }
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        try {
            return this.loadClass(string, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            for (AddOnClassLoader addOnClassLoader : this.addOnLoaders.values()) {
                try {
                    return addOnClassLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                }
            }
            throw new ClassNotFoundException(string);
        }
    }

    @Override
    public URL getResource(String string) {
        URL uRL = super.getResource(string);
        if (uRL != null) {
            return uRL;
        }
        for (AddOnClassLoader addOnClassLoader : this.addOnLoaders.values()) {
            uRL = addOnClassLoader.findResourceInAddOn(string);
            if (uRL == null) continue;
            return uRL;
        }
        return uRL;
    }

    public AddOnCollection getAddOnCollection() {
        return this.aoc;
    }

    private void addDirectory(File file) {
        if (file == null) {
            logger.error((Object)"Null directory supplied");
            return;
        }
        if (!file.exists()) {
            logger.error((Object)("No such directory: " + file.getAbsolutePath()));
            return;
        }
        if (!file.isDirectory()) {
            logger.error((Object)("Not a directory: " + file.getAbsolutePath()));
            return;
        }
        File[] fileArray = file.listFiles(new JarFilenameFilter());
        if (fileArray != null) {
            for (File file2 : fileArray) {
                this.jars.add(file2);
            }
        }
    }

    public synchronized void addAddon(AddOn addOn) {
        if (!addOn.canLoadInCurrentVersion()) {
            throw new IllegalArgumentException("Cant load add-on " + addOn.getName() + " Not before=" + addOn.getNotBeforeVersion() + " Not from=" + addOn.getNotFromVersion() + " Version=" + Constant.PROGRAM_VERSION);
        }
        if (!this.aoc.addAddOn(addOn)) {
            return;
        }
        this.addAddOnImpl(addOn);
    }

    private void addAddOnImpl(AddOn addOn) {
        if (AddOn.InstallationStatus.INSTALLED == addOn.getInstallationStatus()) {
            return;
        }
        if (this.blockList.contains(addOn.getId())) {
            this.blockList.remove(addOn.getId());
            this.saveBlockList();
        }
        if (!AddOnLoader.isDynamicallyInstallable(addOn)) {
            return;
        }
        AddOn.AddOnRunRequirements addOnRunRequirements = AddOnLoader.calculateRunRequirements(addOn, this.aoc.getInstalledAddOns());
        if (!addOnRunRequirements.isRunnable()) {
            addOn.setInstallationStatus(AddOn.InstallationStatus.NOT_INSTALLED);
            return;
        }
        AddOnInstaller.install(this.createAndAddAddOnClassLoader(addOn), addOn);
        addOn.setInstallationStatus(AddOn.InstallationStatus.INSTALLED);
        Control.getSingleton().getExtensionLoader().addOnInstalled(addOn);
        if (this.runnableAddOns.get(addOn) == null) {
            this.runnableAddOns.put(addOn, AddOnLoader.getRunnableExtensionsWithDeps(addOnRunRequirements));
            AddOnLoader.saveAddOnsRunState(this.runnableAddOns);
        }
        this.checkAndLoadDependentExtensions();
        this.checkAndInstallAddOnsNotInstalled();
        if (View.isInitialised()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    View.getSingleton().refreshTabViewMenus();
                }
            });
        }
    }

    private void checkAndInstallAddOnsNotInstalled() {
        ArrayList<AddOn> arrayList = new ArrayList<AddOn>();
        for (AddOn addOn : this.aoc.getAddOns()) {
            AddOn.AddOnRunRequirements addOnRunRequirements;
            if (AddOn.InstallationStatus.NOT_INSTALLED != addOn.getInstallationStatus() || this.addOnLoaders.get(addOn.getId()) != null || !(addOnRunRequirements = addOn.calculateRunRequirements(this.aoc.getInstalledAddOns())).isRunnable()) continue;
            arrayList.add(addOn);
        }
        for (AddOn addOn : arrayList) {
            this.addAddOnImpl(addOn);
        }
    }

    private void checkAndLoadDependentExtensions() {
        boolean bl = false;
        for (Map.Entry<String, AddOnClassLoader> entry : new HashMap<String, AddOnClassLoader>(this.addOnLoaders).entrySet()) {
            AddOn addOn = this.aoc.getAddOn(entry.getKey());
            for (String string : addOn.getExtensionsWithDeps()) {
                AddOn.AddOnRunRequirements addOnRunRequirements;
                AddOn.ExtensionRunRequirements extensionRunRequirements;
                if (addOn.isExtensionLoaded(string) || !(extensionRunRequirements = (addOnRunRequirements = addOn.calculateExtensionRunRequirements(string, this.aoc.getInstalledAddOns())).getExtensionRequirements().get(0)).isRunnable()) continue;
                ArrayList<AddOnClassLoader> arrayList = new ArrayList<AddOnClassLoader>(extensionRunRequirements.getDependencies().size());
                for (AddOn addOn2 : extensionRunRequirements.getDependencies()) {
                    arrayList.add(this.addOnLoaders.get(addOn2.getId()));
                }
                AddOnClassLoader addOnClassLoader = new AddOnClassLoader(entry.getValue(), arrayList, addOn.getExtensionAddOnClassnames(string));
                Extension object2 = AddOnLoader.loadAddOnExtension(addOn, extensionRunRequirements.getClassname(), addOnClassLoader);
                AddOnInstaller.installAddOnExtension(addOn, object2);
                this.runnableAddOns.get(addOn).add(extensionRunRequirements.getClassname());
                bl = true;
            }
        }
        if (bl) {
            AddOnLoader.saveAddOnsRunState(this.runnableAddOns);
        }
    }

    private static boolean isDynamicallyInstallable(AddOn addOn) {
        return addOn.hasZapAddOnEntry();
    }

    public synchronized boolean removeAddOn(AddOn addOn, boolean bl, AddOnUninstallationProgressCallback addOnUninstallationProgressCallback) {
        AddOnUninstallationProgressCallback addOnUninstallationProgressCallback2 = addOnUninstallationProgressCallback == null ? NULL_CALLBACK : addOnUninstallationProgressCallback;
        addOnUninstallationProgressCallback2.uninstallingAddOn(addOn, bl);
        boolean bl2 = this.removeAddOnImpl(addOn, bl, addOnUninstallationProgressCallback2);
        addOnUninstallationProgressCallback2.addOnUninstalled(bl2);
        return bl2;
    }

    private boolean removeAddOnImpl(AddOn addOn, boolean bl, AddOnUninstallationProgressCallback addOnUninstallationProgressCallback) {
        if (!AddOnLoader.isDynamicallyInstallable(addOn)) {
            return false;
        }
        if (AddOn.InstallationStatus.SOFT_UNINSTALLATION_FAILED == addOn.getInstallationStatus()) {
            if (this.runnableAddOns.remove(addOn) != null) {
                AddOnLoader.saveAddOnsRunState(this.runnableAddOns);
            }
            AddOnInstaller.uninstallAddOnFiles(addOn, NULL_CALLBACK);
            this.removeAddOnClassLoader(addOn);
            this.deleteAddOnFile(addOn, bl);
            addOn.setInstallationStatus(AddOn.InstallationStatus.UNINSTALLATION_FAILED);
            Control.getSingleton().getExtensionLoader().addOnUninstalled(addOn, false);
            return false;
        }
        if (!this.aoc.includesAddOn(addOn.getId())) {
            logger.warn((Object)("Trying to uninstall an add-on that is not installed: " + addOn.getId()));
            return false;
        }
        if (AddOn.InstallationStatus.NOT_INSTALLED == addOn.getInstallationStatus()) {
            if (this.runnableAddOns.remove(addOn) != null) {
                AddOnLoader.saveAddOnsRunState(this.runnableAddOns);
            }
            this.deleteAddOnFile(addOn, bl);
            return this.aoc.removeAddOn(addOn);
        }
        this.unloadDependentExtensions(addOn);
        this.softUninstallDependentAddOns(addOn);
        boolean bl2 = AddOnInstaller.uninstall(addOn, addOnUninstallationProgressCallback);
        if (bl2 && !this.aoc.removeAddOn(addOn)) {
            bl2 = false;
        }
        if (bl2) {
            this.removeAddOnClassLoader(addOn);
        }
        this.deleteAddOnFile(addOn, bl);
        if (this.runnableAddOns.remove(addOn) != null) {
            AddOnLoader.saveAddOnsRunState(this.runnableAddOns);
        }
        addOn.setInstallationStatus(bl2 ? AddOn.InstallationStatus.AVAILABLE : AddOn.InstallationStatus.UNINSTALLATION_FAILED);
        Control.getSingleton().getExtensionLoader().addOnUninstalled(addOn, bl2);
        return bl2;
    }

    private void deleteAddOnFile(AddOn addOn, boolean bl) {
        if (addOn.getFile() != null && addOn.getFile().exists() && !addOn.getFile().delete() && !bl) {
            logger.debug((Object)("Cant delete " + addOn.getFile().getAbsolutePath()));
            this.blockList.add(addOn.getId());
            this.saveBlockList();
        }
    }

    private void removeAddOnClassLoader(AddOn addOn) {
        if (this.addOnLoaders.containsKey(addOn.getId())) {
            try (AddOnClassLoader addOnClassLoader = this.addOnLoaders.remove(addOn.getId());){
                if (!addOn.getIdsAddOnDependencies().isEmpty()) {
                    addOnClassLoader.clearDependencies();
                }
                ResourceBundle.clearCache(addOnClassLoader);
            }
            catch (Exception exception) {
                logger.error((Object)("Failure while closing class loader of " + addOn.getId() + " add-on:"), (Throwable)exception);
            }
        }
    }

    private void unloadDependentExtensions(AddOn addOn) {
        boolean bl = true;
        for (Map.Entry<String, AddOnClassLoader> entry : new HashMap<String, AddOnClassLoader>(this.addOnLoaders).entrySet()) {
            AddOn addOn2 = this.aoc.getAddOn(entry.getKey());
            for (Extension extension : addOn2.getLoadedExtensionsWithDeps()) {
                if (!addOn2.dependsOn(extension, addOn)) continue;
                String string = extension.getClass().getCanonicalName();
                AddOnInstaller.uninstallAddOnExtension(addOn2, extension, NULL_CALLBACK);
                try (AddOnClassLoader addOnClassLoader = (AddOnClassLoader)extension.getClass().getClassLoader();){
                    extension = null;
                    entry.getValue().removeChildClassLoader(addOnClassLoader);
                    addOnClassLoader.clearDependencies();
                    ResourceBundle.clearCache(addOnClassLoader);
                }
                catch (Exception exception) {
                    logger.error((Object)("Failure while closing class loader of extension '" + string + "':"), (Throwable)exception);
                }
                this.runnableAddOns.get(addOn2).remove(string);
                bl = true;
            }
        }
        if (bl) {
            AddOnLoader.saveAddOnsRunState(this.runnableAddOns);
        }
    }

    private void softUninstallDependentAddOns(AddOn addOn) {
        for (Map.Entry<String, AddOnClassLoader> entry : new HashMap<String, AddOnClassLoader>(this.addOnLoaders).entrySet()) {
            AddOn addOn2 = this.aoc.getAddOn(entry.getKey());
            if (!addOn2.dependsOn(addOn)) continue;
            this.softUninstallDependentAddOns(addOn2);
            this.softUninstall(addOn2);
        }
    }

    private void softUninstall(AddOn addOn) {
        AddOn.InstallationStatus installationStatus;
        if (AddOn.InstallationStatus.INSTALLED != addOn.getInstallationStatus()) {
            return;
        }
        if (AddOnLoader.isDynamicallyInstallable(addOn) && AddOnInstaller.softUninstall(addOn, NULL_CALLBACK)) {
            this.removeAddOnClassLoader(addOn);
            installationStatus = AddOn.InstallationStatus.NOT_INSTALLED;
        } else {
            installationStatus = AddOn.InstallationStatus.SOFT_UNINSTALLATION_FAILED;
        }
        addOn.setInstallationStatus(installationStatus);
        Control.getSingleton().getExtensionLoader().addOnSoftUninstalled(addOn, installationStatus == AddOn.InstallationStatus.NOT_INSTALLED);
    }

    private void loadBlockList() {
        this.blockList = AddOnLoader.loadList(ADDONS_BLOCK_LIST);
    }

    private void saveBlockList() {
        AddOnLoader.saveList(ADDONS_BLOCK_LIST, this.blockList);
    }

    private <T> List<ClassNameWrapper> getClassNames(String string, Class<T> clazz) {
        ArrayList<ClassNameWrapper> arrayList = new ArrayList<ClassNameWrapper>();
        arrayList.addAll(this.getLocalClassNames(string));
        for (String object : this.addOnLoaders.keySet()) {
            arrayList.addAll(this.getJarClassNames(this.aoc.getAddOn(object), string));
        }
        for (File file : this.jars) {
            arrayList.addAll(this.getJarClassNames(this.getClass().getClassLoader(), file, string));
        }
        return arrayList;
    }

    public List<Extension> getExtensions() {
        ArrayList<Extension> arrayList = new ArrayList<Extension>();
        for (AddOn addOn : this.getAddOnCollection().getAddOns()) {
            arrayList.addAll(this.getExtensions(addOn));
        }
        return arrayList;
    }

    public List<Extension> getExtensions(AddOn addOn) {
        AddOnClassLoader addOnClassLoader = this.addOnLoaders.get(addOn.getId());
        if (addOnClassLoader == null) {
            return Collections.emptyList();
        }
        ArrayList<Extension> arrayList = new ArrayList<Extension>();
        arrayList.addAll(this.loadAddOnExtensions(addOn, addOn.getExtensions(), addOnClassLoader));
        if (addOn.hasExtensionsWithDeps()) {
            AddOn.AddOnRunRequirements addOnRunRequirements = addOn.calculateRunRequirements(this.aoc.getInstalledAddOns());
            for (AddOn.ExtensionRunRequirements extensionRunRequirements : addOnRunRequirements.getExtensionRequirements()) {
                if (extensionRunRequirements.isRunnable()) {
                    ArrayList<AddOnClassLoader> arrayList2 = new ArrayList<AddOnClassLoader>(extensionRunRequirements.getDependencies().size());
                    for (AddOn addOn2 : extensionRunRequirements.getDependencies()) {
                        arrayList2.add(this.addOnLoaders.get(addOn2.getId()));
                    }
                    AddOnClassLoader addOnClassLoader2 = new AddOnClassLoader(addOnClassLoader, arrayList2, addOn.getExtensionAddOnClassnames(extensionRunRequirements.getClassname()));
                    Extension object2 = AddOnLoader.loadAddOnExtension(addOn, extensionRunRequirements.getClassname(), addOnClassLoader2);
                    if (object2 == null) continue;
                    arrayList.add(object2);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Can't run extension '" + extensionRunRequirements.getClassname() + "' of add-on '" + addOn.getName() + "' because of missing requirements: " + AddOnRunIssuesUtils.getRunningIssues(extensionRunRequirements)));
            }
        }
        return arrayList;
    }

    private List<Extension> loadAddOnExtensions(AddOn addOn, List<String> list, AddOnClassLoader addOnClassLoader) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Extension> arrayList = new ArrayList<Extension>(list.size());
        for (String string : list) {
            Extension extension = AddOnLoader.loadAddOnExtension(addOn, string, addOnClassLoader);
            if (extension == null) continue;
            arrayList.add(extension);
        }
        return arrayList;
    }

    private static Extension loadAddOnExtension(AddOn addOn, String string, AddOnClassLoader addOnClassLoader) {
        Extension extension = AddOnLoaderUtils.loadAndInstantiateClass(addOnClassLoader, string, Extension.class, "extension");
        if (extension != null) {
            addOn.addLoadedExtension(extension);
        }
        return extension;
    }

    public List<AbstractPlugin> getActiveScanRules() {
        ArrayList<AbstractPlugin> arrayList = new ArrayList<AbstractPlugin>();
        for (AddOn addOn : this.getAddOnCollection().getAddOns()) {
            AddOnClassLoader addOnClassLoader = this.addOnLoaders.get(addOn.getId());
            if (addOnClassLoader == null) continue;
            arrayList.addAll(AddOnLoaderUtils.getActiveScanRules(addOn, addOnClassLoader));
        }
        arrayList.trimToSize();
        return Collections.unmodifiableList(arrayList);
    }

    public List<PluginPassiveScanner> getPassiveScanRules() {
        ArrayList<PluginPassiveScanner> arrayList = new ArrayList<PluginPassiveScanner>();
        for (AddOn addOn : this.getAddOnCollection().getAddOns()) {
            AddOnClassLoader addOnClassLoader = this.addOnLoaders.get(addOn.getId());
            if (addOnClassLoader == null) continue;
            arrayList.addAll(AddOnLoaderUtils.getPassiveScanRules(addOn, addOnClassLoader));
        }
        arrayList.trimToSize();
        return Collections.unmodifiableList(arrayList);
    }

    public <T> List<T> getImplementors(String string, Class<T> clazz) {
        return this.getImplementors(null, string, clazz);
    }

    public <T> List<T> getImplementors(AddOn addOn, String string, Class<T> clazz) {
        Class<?> clazz2 = null;
        ArrayList arrayList = new ArrayList();
        List<ClassNameWrapper> list = addOn != null ? this.getJarClassNames(addOn, string) : this.getClassNames(string, clazz);
        for (ClassNameWrapper classNameWrapper : list) {
            try {
                clazz2 = classNameWrapper.getCl().loadClass(classNameWrapper.getClassName());
                if (Modifier.isAbstract(clazz2.getModifiers()) || Modifier.isInterface(clazz2.getModifiers()) || !clazz.isAssignableFrom(clazz2)) continue;
                Constructor<?> constructor = clazz2.getConstructor(new Class[0]);
                arrayList.add(constructor.newInstance(new Object[0]));
            }
            catch (Throwable throwable) {
                logger.debug((Object)throwable.getMessage(), throwable);
            }
        }
        return arrayList;
    }

    private List<ClassNameWrapper> getLocalClassNames(String string) {
        if (string == null || string.equals("")) {
            return Collections.emptyList();
        }
        String string2 = string.replace('.', '/');
        URL uRL = AddOnLoader.class.getClassLoader().getResource(string2);
        if (uRL == null) {
            return Collections.emptyList();
        }
        String string3 = null;
        if (uRL.getProtocol().equals("jar")) {
            string3 = uRL.toString().substring("jar:".length());
            int n = string3.indexOf("!");
            string3 = string3.substring(0, n);
            try {
                return this.getJarClassNames(this.getClass().getClassLoader(), new File(new URI(string3)), string);
            }
            catch (URISyntaxException uRISyntaxException) {
                logger.error((Object)uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
            }
        } else {
            try {
                return this.parseClassDir(this.getClass().getClassLoader(), new File(new URI(uRL.toString())), string.replace('.', File.separatorChar), new ClassRecurseDirFileFilter(true));
            }
            catch (URISyntaxException uRISyntaxException) {
                logger.error((Object)uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
            }
        }
        return Collections.emptyList();
    }

    private List<ClassNameWrapper> parseClassDir(ClassLoader classLoader, File file, String string, FileFilter fileFilter) {
        ArrayList<ClassNameWrapper> arrayList = new ArrayList<ClassNameWrapper>();
        File[] fileArray = file.listFiles(fileFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                arrayList.addAll(this.parseClassDir(classLoader, file2, string, fileFilter));
                continue;
            }
            String string2 = file2.toString();
            int n = string2.indexOf(string);
            if (n <= 0) continue;
            String string3 = string2.substring(n).replaceAll("\\.class$", "").replace(File.separatorChar, '.');
            arrayList.add(new ClassNameWrapper(classLoader, string3));
        }
        return arrayList;
    }

    private List<ClassNameWrapper> getJarClassNames(ClassLoader classLoader, File file, String string) {
        ArrayList<ClassNameWrapper> arrayList = new ArrayList<ClassNameWrapper>();
        ZipEntry zipEntry = null;
        String string2 = "";
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || !zipEntry.getName().endsWith(".class") || (string2 = zipEntry.toString().replaceAll("\\.class$", "").replaceAll("/", ".")).indexOf(string) < 0) continue;
                arrayList.add(new ClassNameWrapper(classLoader, string2));
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Failed to open file: " + file.getAbsolutePath()), (Throwable)exception);
        }
        return arrayList;
    }

    private List<ClassNameWrapper> getJarClassNames(AddOn addOn, String string) {
        ArrayList<ClassNameWrapper> arrayList = new ArrayList<ClassNameWrapper>();
        ZipEntry zipEntry = null;
        String string2 = "";
        try (JarFile jarFile = new JarFile(addOn.getFile());){
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || !zipEntry.getName().endsWith(".class") || (string2 = zipEntry.toString().replaceAll("\\.class$", "").replaceAll("/", ".")).indexOf(string) < 0) continue;
                arrayList.add(new ClassNameWrapper(this.addOnLoaders.get(addOn.getId()), string2));
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Failed to open file: " + addOn.getFile().getAbsolutePath()), (Throwable)exception);
        }
        return arrayList;
    }

    private static List<String> loadList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = Model.getSingleton().getOptionsParam().getConfig().getString(string, null);
        if (string2 != null && string2.length() > 0) {
            for (String string3 : string2.split(",")) {
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    private static void saveList(String string, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string2);
        }
        Model.getSingleton().getOptionsParam().getConfig().setProperty(string, (Object)stringBuilder.toString());
        try {
            Model.getSingleton().getOptionsParam().getConfig().save();
        }
        catch (ConfigurationException configurationException) {
            logger.error((Object)("Failed to save list [" + string + "]: " + stringBuilder.toString()), (Throwable)configurationException);
        }
    }

    private static Map<AddOn, List<String>> loadAddOnsRunState(AddOnCollection addOnCollection) {
        List list = ((HierarchicalConfiguration)Model.getSingleton().getOptionsParam().getConfig()).configurationsAt(ADDONS_RUNNABLE_KEY);
        HashMap<AddOn, List<String>> hashMap = new HashMap<AddOn, List<String>>();
        for (HierarchicalConfiguration hierarchicalConfiguration : list) {
            int n;
            AddOn addOn = addOnCollection.getAddOn(hierarchicalConfiguration.getString(ADDON_RUNNABLE_ID_KEY, ""));
            if (addOn == null || (n = hierarchicalConfiguration.getInt(ADDON_RUNNABLE_VERSION_KEY, -1)) == -1 || addOn.getFileVersion() != n) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            List<String> list2 = addOn.getExtensionsWithDeps();
            for (String string : hierarchicalConfiguration.getStringArray(ADDON_RUNNABLE_ALL_EXTENSIONS_KEY)) {
                if (!list2.contains(string)) continue;
                arrayList.add(string);
            }
            hashMap.put(addOn, arrayList);
        }
        return hashMap;
    }

    private static void saveAddOnsRunState(Map<AddOn, List<String>> map) {
        HierarchicalConfiguration hierarchicalConfiguration = (HierarchicalConfiguration)Model.getSingleton().getOptionsParam().getConfig();
        hierarchicalConfiguration.clearTree(ADDONS_RUNNABLE_BASE_KEY);
        int n = 0;
        for (Map.Entry<AddOn, List<String>> entry : map.entrySet()) {
            String string = "runnableAddOns.addon(" + n + ").";
            AddOn addOn = entry.getKey();
            hierarchicalConfiguration.setProperty(string + ADDON_RUNNABLE_ID_KEY, (Object)addOn.getId());
            hierarchicalConfiguration.setProperty(string + ADDON_RUNNABLE_VERSION_KEY, (Object)addOn.getFileVersion());
            String string2 = string + ADDON_RUNNABLE_ALL_EXTENSIONS_KEY;
            for (String string3 : entry.getValue()) {
                hierarchicalConfiguration.addProperty(string2, (Object)string3);
            }
            ++n;
        }
        try {
            Model.getSingleton().getOptionsParam().getConfig().save();
        }
        catch (ConfigurationException configurationException) {
            logger.error((Object)"Failed to save state of runnable add-ons:", (Throwable)configurationException);
        }
    }

    private static class NullUninstallationProgressCallBack
    implements AddOnUninstallationProgressCallback {
        private NullUninstallationProgressCallBack() {
        }

        @Override
        public void uninstallingAddOn(AddOn addOn, boolean bl) {
        }

        @Override
        public void activeScanRulesWillBeRemoved(int n) {
        }

        @Override
        public void activeScanRuleRemoved(String string) {
        }

        @Override
        public void passiveScanRulesWillBeRemoved(int n) {
        }

        @Override
        public void passiveScanRuleRemoved(String string) {
        }

        @Override
        public void filesWillBeRemoved(int n) {
        }

        @Override
        public void fileRemoved() {
        }

        @Override
        public void extensionsWillBeRemoved(int n) {
        }

        @Override
        public void extensionRemoved(String string) {
        }

        @Override
        public void addOnUninstalled(boolean bl) {
        }
    }

    private class ClassNameWrapper {
        private ClassLoader cl;
        private String className;

        public ClassNameWrapper(ClassLoader classLoader, String string) {
            this.cl = classLoader;
            this.className = string;
        }

        public ClassLoader getCl() {
            return this.cl;
        }

        public String getClassName() {
            return this.className;
        }
    }

    private static final class ClassRecurseDirFileFilter
    implements FileFilter {
        private boolean recurse;

        public ClassRecurseDirFileFilter(boolean bl) {
            this.recurse = bl;
        }

        @Override
        public boolean accept(File file) {
            if (this.recurse && file.isDirectory() && !file.getName().startsWith(".")) {
                return true;
            }
            return file.isFile() && file.getName().endsWith(".class");
        }
    }

    private static final class JarFilenameFilter
    implements FilenameFilter {
        private JarFilenameFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.endsWith(".jar");
        }
    }
}

