/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.brk.BreakPanel;
import org.zaproxy.zap.extension.brk.BreakpointMessageInterface;
import org.zaproxy.zap.extension.httppanel.Message;

@Deprecated
public class BreakpointMessageHandler {
    private static final Logger logger = Logger.getLogger(BreakpointMessageHandler.class);
    protected static final Object semaphore = new Object();
    protected final BreakPanel breakPanel;
    protected List<BreakpointMessageInterface> enabledBreakpoints;
    private List<String> enabledKeyBreakpoints = new ArrayList<String>();

    public List<String> getEnabledKeyBreakpoints() {
        return this.enabledKeyBreakpoints;
    }

    public void setEnabledKeyBreakpoints(List<String> list) {
        this.enabledKeyBreakpoints = list;
    }

    public BreakpointMessageHandler(BreakPanel breakPanel) {
        this.breakPanel = breakPanel;
    }

    public void setEnabledBreakpoints(List<BreakpointMessageInterface> list) {
        this.enabledBreakpoints = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessageReceivedFromClient(Message message, boolean bl) {
        if (!this.isBreakpoint(message, true, bl)) {
            return true;
        }
        this.breakPanel.breakpointHit();
        Object object = semaphore;
        synchronized (object) {
            if (this.breakPanel.isHoldMessage()) {
                this.setBreakDisplay(message, true);
                this.waitUntilContinue(true);
            }
        }
        this.breakPanel.clearAndDisableRequest();
        return !this.breakPanel.isToBeDropped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessageReceivedFromServer(Message message, boolean bl) {
        if (!this.isBreakpoint(message, false, bl)) {
            return true;
        }
        this.breakPanel.breakpointHit();
        Object object = semaphore;
        synchronized (object) {
            if (this.breakPanel.isHoldMessage()) {
                this.setBreakDisplay(message, false);
                this.waitUntilContinue(false);
            }
        }
        this.breakPanel.clearAndDisableResponse();
        return !this.breakPanel.isToBeDropped();
    }

    private void setBreakDisplay(Message message, boolean bl) {
        this.breakPanel.setMessage(message, bl);
        this.breakPanel.breakpointDisplayed();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    View.getSingleton().getMainFrame().toFront();
                }
            });
        }
        catch (Exception exception) {
            logger.warn((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private void waitUntilContinue(boolean bl) {
        while (this.breakPanel.isHoldMessage()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                logger.warn((Object)interruptedException.getMessage(), (Throwable)interruptedException);
            }
        }
        this.breakPanel.saveMessage(bl);
    }

    public boolean isBreakpoint(Message message, boolean bl, boolean bl2) {
        if (message.isForceIntercept()) {
            return true;
        }
        if (bl2 && !message.isInScope()) {
            return false;
        }
        if (this.isBreakOnAllRequests(message, bl)) {
            return true;
        }
        if (this.isBreakOnAllResponses(message, bl)) {
            return true;
        }
        if (this.isBreakOnStepping(message, bl)) {
            return true;
        }
        return this.isBreakOnEnabledBreakpoint(message, bl, bl2);
    }

    protected boolean isBreakOnAllRequests(Message message, boolean bl) {
        return bl && this.breakPanel.isBreakRequest();
    }

    protected boolean isBreakOnAllResponses(Message message, boolean bl) {
        return !bl && this.breakPanel.isBreakResponse();
    }

    protected boolean isBreakOnStepping(Message message, boolean bl) {
        return this.breakPanel.isStepping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isBreakOnEnabledBreakpoint(Message message, boolean bl, boolean bl2) {
        if (this.enabledBreakpoints.isEmpty()) {
            return false;
        }
        List<BreakpointMessageInterface> list = this.enabledBreakpoints;
        synchronized (list) {
            for (BreakpointMessageInterface breakpointMessageInterface : this.enabledBreakpoints) {
                if (!breakpointMessageInterface.match(message, bl, bl2)) continue;
                return true;
            }
        }
        return false;
    }
}

