/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.component.split.response;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.response.ResponseHeaderStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.text.HttpPanelTextArea;
import org.zaproxy.zap.extension.httppanel.view.text.HttpPanelTextView;
import org.zaproxy.zap.extension.httppanel.view.util.HttpTextViewUtils;
import org.zaproxy.zap.extension.search.SearchMatch;

public class HttpResponseHeaderPanelTextView
extends HttpPanelTextView {
    public HttpResponseHeaderPanelTextView(ResponseHeaderStringHttpPanelViewModel responseHeaderStringHttpPanelViewModel) {
        super(responseHeaderStringHttpPanelViewModel);
    }

    @Override
    protected HttpPanelTextArea createHttpPanelTextArea() {
        return new HttpResponseHeaderPanelTextArea();
    }

    private static class HttpResponseHeaderPanelTextArea
    extends HttpPanelTextArea {
        private static final long serialVersionUID = -787753390999658000L;

        private HttpResponseHeaderPanelTextArea() {
        }

        @Override
        public void search(Pattern pattern, List<SearchMatch> list) {
            Matcher matcher = pattern.matcher(this.getText());
            while (matcher.find()) {
                int[] nArray = HttpTextViewUtils.getViewToHeaderPosition(this, matcher.start(), matcher.end());
                if (nArray.length == 0) {
                    return;
                }
                list.add(new SearchMatch(SearchMatch.Location.RESPONSE_HEAD, nArray[0], nArray[1]));
            }
        }

        @Override
        public void highlight(SearchMatch searchMatch) {
            if (!SearchMatch.Location.RESPONSE_HEAD.equals((Object)searchMatch.getLocation())) {
                return;
            }
            int[] nArray = HttpTextViewUtils.getHeaderToViewPosition(this, searchMatch.getMessage().getResponseHeader().toString(), searchMatch.getStart(), searchMatch.getEnd());
            if (nArray.length == 0) {
                return;
            }
            this.highlight(nArray[0], nArray[1]);
        }
    }
}

