/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.api.ZapApiIgnore;
import org.zaproxy.zap.extension.pscan.scanner.RegexAutoTagScanner;

public class PassiveScanParam
extends AbstractParam {
    private static final Logger logger = Logger.getLogger(PassiveScanParam.class);
    static final String PASSIVE_SCANS_BASE_KEY = "pscans";
    private static final String ALL_AUTO_TAG_SCANNERS_KEY = "pscans.autoTagScanners.scanner";
    private static final String AUTO_TAG_SCANNER_NAME_KEY = "name";
    private static final String AUTO_TAG_SCANNER_TYPE_KEY = "type";
    private static final String AUTO_TAG_SCANNER_CONFIG_KEY = "config";
    private static final String AUTO_TAG_SCANNER_REQ_URL_REGEX_KEY = "reqUrlRegex";
    private static final String AUTO_TAG_SCANNER_REQ_HEAD_REGEX_KEY = "reqHeadRegex";
    private static final String AUTO_TAG_SCANNER_RES_HEAD_REGEX_KEY = "resHeadRegex";
    private static final String AUTO_TAG_SCANNER_RES_BODY_REGEX_KEY = "resBodyRegex";
    private static final String AUTO_TAG_SCANNER_ENABLED_KEY = "enabled";
    private static final String CONFIRM_REMOVE_AUTO_TAG_SCANNER_KEY = "pscans.confirmRemoveAutoTagScanner";
    private static final String SCAN_ONLY_IN_SCOPE_KEY = "pscans.scanOnlyInScope";
    private List<RegexAutoTagScanner> autoTagScanners = new ArrayList<RegexAutoTagScanner>(0);
    private boolean confirmRemoveAutoTagScanner = true;
    private boolean scanOnlyInScope;

    @Override
    protected void parse() {
        try {
            List list = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_AUTO_TAG_SCANNERS_KEY);
            this.autoTagScanners = new ArrayList<RegexAutoTagScanner>(list.size());
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (HierarchicalConfiguration hierarchicalConfiguration : list) {
                String string = hierarchicalConfiguration.getString(AUTO_TAG_SCANNER_NAME_KEY, "");
                if ("".equals(string) || arrayList.contains(string)) continue;
                arrayList.add(string);
                RegexAutoTagScanner regexAutoTagScanner = new RegexAutoTagScanner(hierarchicalConfiguration.getString(AUTO_TAG_SCANNER_NAME_KEY), RegexAutoTagScanner.TYPE.valueOf(hierarchicalConfiguration.getString(AUTO_TAG_SCANNER_TYPE_KEY)), hierarchicalConfiguration.getString(AUTO_TAG_SCANNER_CONFIG_KEY), hierarchicalConfiguration.getString(AUTO_TAG_SCANNER_REQ_URL_REGEX_KEY), hierarchicalConfiguration.getString(AUTO_TAG_SCANNER_REQ_HEAD_REGEX_KEY), hierarchicalConfiguration.getString(AUTO_TAG_SCANNER_RES_HEAD_REGEX_KEY), hierarchicalConfiguration.getString(AUTO_TAG_SCANNER_RES_BODY_REGEX_KEY), hierarchicalConfiguration.getBoolean(AUTO_TAG_SCANNER_ENABLED_KEY, true));
                this.autoTagScanners.add(regexAutoTagScanner);
            }
        }
        catch (ConversionException conversionException) {
            logger.error((Object)("Error while loading the auto tag scanners: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        try {
            this.confirmRemoveAutoTagScanner = this.getConfig().getBoolean(CONFIRM_REMOVE_AUTO_TAG_SCANNER_KEY, true);
        }
        catch (ConversionException conversionException) {
            logger.error((Object)("Error while loading the confirm remove option: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        try {
            this.scanOnlyInScope = this.getConfig().getBoolean(SCAN_ONLY_IN_SCOPE_KEY, false);
        }
        catch (ConversionException conversionException) {
            logger.error((Object)("Error while loading \"scanOnlyInScope\" option: " + conversionException.getMessage()), (Throwable)conversionException);
        }
    }

    public void setAutoTagScanners(List<RegexAutoTagScanner> list) {
        this.autoTagScanners = list;
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_AUTO_TAG_SCANNERS_KEY);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = "pscans.autoTagScanners.scanner(" + i + ").";
            RegexAutoTagScanner regexAutoTagScanner = list.get(i);
            this.getConfig().setProperty(string + AUTO_TAG_SCANNER_NAME_KEY, (Object)regexAutoTagScanner.getName());
            this.getConfig().setProperty(string + AUTO_TAG_SCANNER_TYPE_KEY, (Object)regexAutoTagScanner.getType().toString());
            this.getConfig().setProperty(string + AUTO_TAG_SCANNER_CONFIG_KEY, (Object)regexAutoTagScanner.getConf());
            this.getConfig().setProperty(string + AUTO_TAG_SCANNER_REQ_URL_REGEX_KEY, (Object)regexAutoTagScanner.getRequestUrlRegex());
            this.getConfig().setProperty(string + AUTO_TAG_SCANNER_REQ_HEAD_REGEX_KEY, (Object)regexAutoTagScanner.getRequestHeaderRegex());
            this.getConfig().setProperty(string + AUTO_TAG_SCANNER_RES_HEAD_REGEX_KEY, (Object)regexAutoTagScanner.getResponseHeaderRegex());
            this.getConfig().setProperty(string + AUTO_TAG_SCANNER_RES_BODY_REGEX_KEY, (Object)regexAutoTagScanner.getResponseBodyRegex());
            this.getConfig().setProperty(string + AUTO_TAG_SCANNER_ENABLED_KEY, (Object)regexAutoTagScanner.isEnabled());
        }
    }

    public List<RegexAutoTagScanner> getAutoTagScanners() {
        return this.autoTagScanners;
    }

    @ZapApiIgnore
    public boolean isConfirmRemoveAutoTagScanner() {
        return this.confirmRemoveAutoTagScanner;
    }

    @ZapApiIgnore
    public void setConfirmRemoveAutoTagScanner(boolean bl) {
        this.confirmRemoveAutoTagScanner = bl;
        this.getConfig().setProperty(CONFIRM_REMOVE_AUTO_TAG_SCANNER_KEY, (Object)this.confirmRemoveAutoTagScanner);
    }

    public void setScanOnlyInScope(boolean bl) {
        this.scanOnlyInScope = bl;
        this.getConfig().setProperty(SCAN_ONLY_IN_SCOPE_KEY, (Object)bl);
    }

    public boolean isScanOnlyInScope() {
        return this.scanOnlyInScope;
    }
}

