/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LegacyNumericUtils;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.packed.GrowableWriter;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PagedGrowableWriter;
import org.elasticsearch.index.fielddata.ordinals.MultiOrdinals;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.SinglePackedOrdinals;

public final class OrdinalsBuilder
implements Closeable {
    public static final String FORCE_MULTI_ORDINALS = "force_multi_ordinals";
    public static final float DEFAULT_ACCEPTABLE_OVERHEAD_RATIO = 0.5f;
    private final int maxDoc;
    private long currentOrd = -1L;
    private int numDocsWithValue = 0;
    private int numMultiValuedDocs = 0;
    private int totalNumOrds = 0;
    private OrdinalsStore ordinals;
    private final LongsRef spare;

    public OrdinalsBuilder(int maxDoc, float acceptableOverheadRatio) throws IOException {
        this.maxDoc = maxDoc;
        int startBitsPerValue = 8;
        this.ordinals = new OrdinalsStore(maxDoc, startBitsPerValue, acceptableOverheadRatio);
        this.spare = new LongsRef();
    }

    public OrdinalsBuilder(int maxDoc) throws IOException {
        this(maxDoc, 0.5f);
    }

    public LongsRef docOrds(int docID) {
        this.spare.length = 0;
        this.spare.offset = 0;
        this.ordinals.appendOrdinals(docID, this.spare);
        return this.spare;
    }

    public PackedInts.Reader getFirstOrdinals() {
        return this.ordinals.firstOrdinals;
    }

    public long nextOrdinal() {
        return ++this.currentOrd;
    }

    public long currentOrdinal() {
        return this.currentOrd;
    }

    public OrdinalsBuilder addDoc(int doc) {
        ++this.totalNumOrds;
        int numValues = this.ordinals.addOrdinal(doc, this.currentOrd);
        if (numValues == 1) {
            ++this.numDocsWithValue;
        } else if (numValues == 2) {
            ++this.numMultiValuedDocs;
        }
        return this;
    }

    public boolean isMultiValued() {
        return this.numMultiValuedDocs > 0;
    }

    public int getNumDocsWithValue() {
        return this.numDocsWithValue;
    }

    public int getNumSingleValuedDocs() {
        return this.numDocsWithValue - this.numMultiValuedDocs;
    }

    public int getNumMultiValuesDocs() {
        return this.numMultiValuedDocs;
    }

    public int getTotalNumOrds() {
        return this.totalNumOrds;
    }

    public long getValueCount() {
        return this.currentOrd + 1L;
    }

    public BitSet buildDocsWithValuesSet() {
        if (this.numDocsWithValue == this.maxDoc) {
            return null;
        }
        FixedBitSet bitSet = new FixedBitSet(this.maxDoc);
        for (int docID = 0; docID < this.maxDoc; ++docID) {
            if (this.ordinals.firstOrdinals.get(docID) == 0L) continue;
            bitSet.set(docID);
        }
        return bitSet;
    }

    public Ordinals build() {
        float acceptableOverheadRatio = 0.25f;
        if (this.numMultiValuedDocs > 0 || MultiOrdinals.significantlySmallerThanSinglePackedOrdinals(this.maxDoc, this.numDocsWithValue, this.getValueCount(), 0.25f)) {
            return new MultiOrdinals(this, 0.25f);
        }
        return new SinglePackedOrdinals(this, 0.25f);
    }

    public static TermsEnum wrapGeoPointTerms(TermsEnum termsEnum) {
        return new FilteredTermsEnum(termsEnum, false){

            protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
                return GeoPointField.getPrefixCodedShift((BytesRef)term) == 36 ? FilteredTermsEnum.AcceptStatus.YES : FilteredTermsEnum.AcceptStatus.END;
            }
        };
    }

    public int maxDoc() {
        return this.maxDoc;
    }

    public static TermsEnum wrapNumeric64Bit(TermsEnum termsEnum) {
        return new FilteredTermsEnum(termsEnum, false){

            protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
                return LegacyNumericUtils.getPrefixCodedLongShift((BytesRef)term) == 0 ? FilteredTermsEnum.AcceptStatus.YES : FilteredTermsEnum.AcceptStatus.END;
            }
        };
    }

    public static TermsEnum wrapNumeric32Bit(TermsEnum termsEnum) {
        return new FilteredTermsEnum(termsEnum, false){

            protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
                return LegacyNumericUtils.getPrefixCodedIntShift((BytesRef)term) == 0 ? FilteredTermsEnum.AcceptStatus.YES : FilteredTermsEnum.AcceptStatus.END;
            }
        };
    }

    public BytesRefIterator buildFromTerms(final TermsEnum termsEnum) throws IOException {
        return new BytesRefIterator(){
            private PostingsEnum docsEnum = null;

            public BytesRef next() throws IOException {
                BytesRef ref = termsEnum.next();
                if (ref != null) {
                    int docId;
                    this.docsEnum = termsEnum.postings(this.docsEnum, 0);
                    OrdinalsBuilder.this.nextOrdinal();
                    while ((docId = this.docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                        OrdinalsBuilder.this.addDoc(docId);
                    }
                }
                return ref;
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.ordinals = null;
    }

    private static class OrdinalsStore {
        private static final int PAGE_SIZE = 4096;
        private PagedGrowableWriter positions;
        private final GrowableWriter firstOrdinals;
        private PagedGrowableWriter firstNextLevelSlices;
        private final PagedGrowableWriter[] ordinals;
        private final PagedGrowableWriter[] nextLevelSlices;
        private final int[] sizes;
        private final int startBitsPerValue;
        private final float acceptableOverheadRatio;

        private static int numSlots(int level) {
            return 1 << level;
        }

        private static int slotsMask(int level) {
            return OrdinalsStore.numSlots(level) - 1;
        }

        private static long position(int level, long offset) {
            assert (level >= 1);
            return (long)(1 << level - 1) | offset << level;
        }

        private static int level(long position) {
            return 1 + Long.numberOfTrailingZeros(position);
        }

        private static long offset(long position, int level) {
            return position >>> level;
        }

        private static long sliceID(int level, long offset) {
            return offset >>> level;
        }

        private static long startOffset(int level, long slice) {
            return slice << level;
        }

        private static int numOrdinals(int level, long offset) {
            return (1 << level) + (int)(offset & (long)OrdinalsStore.slotsMask(level));
        }

        OrdinalsStore(int maxDoc, int startBitsPerValue, float acceptableOverheadRatio) {
            this.startBitsPerValue = startBitsPerValue;
            this.acceptableOverheadRatio = acceptableOverheadRatio;
            this.positions = new PagedGrowableWriter((long)maxDoc, 4096, startBitsPerValue, acceptableOverheadRatio);
            this.firstOrdinals = new GrowableWriter(startBitsPerValue, maxDoc, acceptableOverheadRatio);
            this.ordinals = new PagedGrowableWriter[24];
            this.nextLevelSlices = new PagedGrowableWriter[24];
            this.sizes = new int[24];
            Arrays.fill(this.sizes, 1);
        }

        private long newSlice(int level) {
            int n = level;
            int n2 = this.sizes[n];
            this.sizes[n] = n2 + 1;
            long newSlice = n2;
            if (this.ordinals[level] == null) {
                this.ordinals[level] = new PagedGrowableWriter(8L * (long)OrdinalsStore.numSlots(level), 4096, this.startBitsPerValue, this.acceptableOverheadRatio);
            } else {
                this.ordinals[level] = (PagedGrowableWriter)this.ordinals[level].grow((long)(this.sizes[level] * OrdinalsStore.numSlots(level)));
                if (this.nextLevelSlices[level] != null) {
                    this.nextLevelSlices[level] = (PagedGrowableWriter)this.nextLevelSlices[level].grow((long)this.sizes[level]);
                }
            }
            return newSlice;
        }

        public int addOrdinal(int docID, long ordinal) {
            long position = this.positions.get(docID);
            if (position == 0L) {
                return this.firstLevel(docID, ordinal);
            }
            return this.nonFirstLevel(docID, ordinal, position);
        }

        private int firstLevel(int docID, long ordinal) {
            if (this.firstOrdinals.get(docID) == 0L) {
                this.firstOrdinals.set(docID, ordinal + 1L);
                return 1;
            }
            long newSlice = this.newSlice(1);
            if (this.firstNextLevelSlices == null) {
                this.firstNextLevelSlices = new PagedGrowableWriter((long)this.firstOrdinals.size(), 4096, 3, this.acceptableOverheadRatio);
            }
            this.firstNextLevelSlices.set((long)docID, newSlice);
            long offset = OrdinalsStore.startOffset(1, newSlice);
            this.ordinals[1].set(offset, ordinal + 1L);
            this.positions.set((long)docID, OrdinalsStore.position(1, offset));
            return 2;
        }

        private int nonFirstLevel(int docID, long ordinal, long position) {
            int level = OrdinalsStore.level(position);
            long offset = OrdinalsStore.offset(position, level);
            assert (offset != 0L);
            if ((offset + 1L & (long)OrdinalsStore.slotsMask(level)) == 0L) {
                long newSlice = this.newSlice(level + 1);
                if (this.nextLevelSlices[level] == null) {
                    this.nextLevelSlices[level] = new PagedGrowableWriter((long)this.sizes[level], 4096, 1, this.acceptableOverheadRatio);
                }
                this.nextLevelSlices[level].set(OrdinalsStore.sliceID(level, offset), newSlice);
                offset = OrdinalsStore.startOffset(++level, newSlice);
                assert ((offset & (long)OrdinalsStore.slotsMask(level)) == 0L);
            } else {
                ++offset;
            }
            this.ordinals[level].set(offset, ordinal + 1L);
            long newPosition = OrdinalsStore.position(level, offset);
            this.positions.set((long)docID, newPosition);
            return OrdinalsStore.numOrdinals(level, offset);
        }

        public void appendOrdinals(int docID, LongsRef ords) {
            long firstOrd = this.firstOrdinals.get(docID);
            if (firstOrd == 0L) {
                return;
            }
            ords.longs = ArrayUtil.grow((long[])ords.longs, (int)(ords.offset + ords.length + 1));
            ords.longs[ords.offset + ords.length++] = firstOrd - 1L;
            if (this.firstNextLevelSlices == null) {
                return;
            }
            long sliceID = this.firstNextLevelSlices.get(docID);
            if (sliceID == 0L) {
                return;
            }
            int level = 1;
            while (true) {
                int numSlots = OrdinalsStore.numSlots(level);
                ords.longs = ArrayUtil.grow((long[])ords.longs, (int)(ords.offset + ords.length + numSlots));
                long offset = OrdinalsStore.startOffset(level, sliceID);
                for (int j = 0; j < numSlots; ++j) {
                    long ord = this.ordinals[level].get(offset + (long)j);
                    if (ord == 0L) {
                        return;
                    }
                    ords.longs[ords.offset + ords.length++] = ord - 1L;
                }
                if (this.nextLevelSlices[level] == null) {
                    return;
                }
                if ((sliceID = this.nextLevelSlices[level].get(sliceID)) == 0L) {
                    return;
                }
                ++level;
            }
        }
    }
}

