/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;

public class QueryParseContext {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(QueryParseContext.class));
    private static final ParseField CACHE = new ParseField("_cache", new String[0]).withAllDeprecated("Elasticsearch makes its own caching decisions");
    private static final ParseField CACHE_KEY = new ParseField("_cache_key", new String[0]).withAllDeprecated("Filters are always used as cache keys");
    private final XContentParser parser;
    private final String defaultScriptLanguage;

    public QueryParseContext(XContentParser parser) {
        this("painless", parser);
    }

    public QueryParseContext(String defaultScriptLanguage, XContentParser parser) {
        this.parser = Objects.requireNonNull(parser, "parser cannot be null");
        this.defaultScriptLanguage = defaultScriptLanguage;
    }

    public XContentParser parser() {
        return this.parser;
    }

    public boolean isDeprecatedSetting(String setting) {
        return CACHE.match(setting) || CACHE_KEY.match(setting);
    }

    public QueryBuilder parseTopLevelQueryBuilder() {
        try {
            QueryBuilder queryBuilder = null;
            XContentParser.Token token = this.parser.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String fieldName = this.parser.currentName();
                    if ("query".equals(fieldName)) {
                        queryBuilder = this.parseInnerQueryBuilder().orElse(null);
                    } else {
                        throw new ParsingException(this.parser.getTokenLocation(), "request does not support [" + this.parser.currentName() + "]", new Object[0]);
                    }
                }
                token = this.parser.nextToken();
            }
            return queryBuilder;
        }
        catch (ParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParsingException(this.parser == null ? null : this.parser.getTokenLocation(), "Failed to parse", e, new Object[0]);
        }
    }

    public Optional<QueryBuilder> parseInnerQueryBuilder() throws IOException {
        Optional result;
        if (this.parser.currentToken() != XContentParser.Token.START_OBJECT && this.parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(this.parser.getTokenLocation(), "[_na] query malformed, must start with start_object", new Object[0]);
        }
        if (this.parser.nextToken() == XContentParser.Token.END_OBJECT) {
            String msg = "query malformed, empty clause found at [" + this.parser.getTokenLocation() + "]";
            DEPRECATION_LOGGER.deprecated(msg, new Object[0]);
            return Optional.empty();
        }
        if (this.parser.currentToken() != XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(this.parser.getTokenLocation(), "[_na] query malformed, no field after start_object", new Object[0]);
        }
        String queryName = this.parser.currentName();
        if (this.parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(this.parser.getTokenLocation(), "[" + queryName + "] query malformed, no start_object after query name", new Object[0]);
        }
        try {
            Optional resultCast;
            result = resultCast = this.parser.namedObject(Optional.class, queryName, this);
        }
        catch (NamedXContentRegistry.UnknownNamedObjectException e) {
            throw new ParsingException(new XContentLocation(e.getLineNumber(), e.getColumnNumber()), "no [query] registered for [" + e.getName() + "]", new Object[0]);
        }
        if (this.parser.currentToken() != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(this.parser.getTokenLocation(), "[" + queryName + "] malformed query, expected [END_OBJECT] but found [" + (Object)((Object)this.parser.currentToken()) + "]", new Object[0]);
        }
        if (this.parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(this.parser.getTokenLocation(), "[" + queryName + "] malformed query, expected [END_OBJECT] but found [" + (Object)((Object)this.parser.currentToken()) + "]", new Object[0]);
        }
        return result;
    }

    public String getDefaultScriptLanguage() {
        return this.defaultScriptLanguage;
    }
}

