/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ConcurrentMapLong;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.FutureTransportResponseHandler;
import org.elasticsearch.transport.NodeDisconnectedException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.PlainTransportFuture;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportFuture;
import org.elasticsearch.transport.TransportInfo;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportResponseOptions;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.TransportStats;

public class TransportService
extends AbstractLifecycleComponent {
    public static final String DIRECT_RESPONSE_PROFILE = ".direct";
    public static final String HANDSHAKE_ACTION_NAME = "internal:transport/handshake";
    private final CountDownLatch blockIncomingRequestsLatch = new CountDownLatch(1);
    protected final Transport transport;
    protected final ThreadPool threadPool;
    protected final ClusterName clusterName;
    protected final TaskManager taskManager;
    private final TransportInterceptor.AsyncSender asyncSender;
    private final Function<BoundTransportAddress, DiscoveryNode> localNodeFactory;
    volatile Map<String, RequestHandlerRegistry> requestHandlers = Collections.emptyMap();
    final Object requestHandlerMutex = new Object();
    final ConcurrentMapLong<RequestHolder> clientHandlers = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
    final CopyOnWriteArrayList<TransportConnectionListener> connectionListeners = new CopyOnWriteArrayList();
    private final TransportInterceptor interceptor;
    final Map<Long, TimeoutInfoHolder> timeoutInfoHandlers = Collections.synchronizedMap(new LinkedHashMap<Long, TimeoutInfoHolder>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    });
    private final Adapter adapter;
    public static final TransportInterceptor NOOP_TRANSPORT_INTERCEPTOR = new TransportInterceptor(){};
    public static final Setting<List<String>> TRACE_LOG_INCLUDE_SETTING = Setting.listSetting("transport.tracer.include", Collections.emptyList(), Function.identity(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<List<String>> TRACE_LOG_EXCLUDE_SETTING = Setting.listSetting("transport.tracer.exclude", Arrays.asList("internal:discovery/zen/fd*", "cluster:monitor/nodes/liveness"), Function.identity(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final Logger tracerLog;
    volatile String[] tracerLogInclude;
    volatile String[] tracerLogExclude;
    volatile DiscoveryNode localNode = null;
    private final Transport.Connection localNodeConnection = new Transport.Connection(){

        @Override
        public DiscoveryNode getNode() {
            return TransportService.this.localNode;
        }

        @Override
        public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
            TransportService.this.sendLocalRequest(requestId, action, request, options);
        }

        @Override
        public void close() throws IOException {
        }
    };

    public TransportService(Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor transportInterceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings) {
        super(settings);
        this.transport = transport;
        this.threadPool = threadPool;
        this.localNodeFactory = localNodeFactory;
        this.clusterName = ClusterName.CLUSTER_NAME_SETTING.get(settings);
        this.setTracerLogInclude(TRACE_LOG_INCLUDE_SETTING.get(settings));
        this.setTracerLogExclude(TRACE_LOG_EXCLUDE_SETTING.get(settings));
        this.tracerLog = Loggers.getLogger(this.logger, ".tracer");
        this.adapter = this.createAdapter();
        this.taskManager = this.createTaskManager();
        this.interceptor = transportInterceptor;
        this.asyncSender = this.interceptor.interceptSender(this::sendRequestInternal);
        if (clusterSettings != null) {
            clusterSettings.addSettingsUpdateConsumer(TRACE_LOG_INCLUDE_SETTING, this::setTracerLogInclude);
            clusterSettings.addSettingsUpdateConsumer(TRACE_LOG_EXCLUDE_SETTING, this::setTracerLogExclude);
        }
    }

    public DiscoveryNode getLocalNode() {
        return this.localNode;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    protected Adapter createAdapter() {
        return new Adapter();
    }

    protected TaskManager createTaskManager() {
        return new TaskManager(this.settings);
    }

    void setTracerLogInclude(List<String> tracerLogInclude) {
        this.tracerLogInclude = tracerLogInclude.toArray(Strings.EMPTY_ARRAY);
    }

    void setTracerLogExclude(List<String> tracerLogExclude) {
        this.tracerLogExclude = tracerLogExclude.toArray(Strings.EMPTY_ARRAY);
    }

    @Override
    protected void doStart() {
        this.adapter.rxMetric.clear();
        this.adapter.txMetric.clear();
        this.transport.transportServiceAdapter(this.adapter);
        this.transport.start();
        if (this.transport.boundAddress() != null && this.logger.isInfoEnabled()) {
            this.logger.info("{}", (Object)this.transport.boundAddress());
            for (Map.Entry<String, BoundTransportAddress> entry : this.transport.profileBoundAddresses().entrySet()) {
                this.logger.info("profile [{}]: {}", (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        this.localNode = this.localNodeFactory.apply(this.transport.boundAddress());
        this.registerRequestHandler(HANDSHAKE_ACTION_NAME, () -> HandshakeRequest.INSTANCE, "same", false, false, (request, channel) -> channel.sendResponse(new HandshakeResponse(this.localNode, this.clusterName, this.localNode.getVersion())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        try {
            this.transport.stop();
        }
        catch (Throwable throwable) {
            for (Map.Entry entry : this.clientHandlers.entrySet()) {
                RequestHolder holderToNotify = (RequestHolder)this.clientHandlers.remove(entry.getKey());
                if (holderToNotify == null) continue;
                this.threadPool.generic().execute(new AbstractRunnable(holderToNotify){
                    final /* synthetic */ RequestHolder val$holderToNotify;
                    {
                        this.val$holderToNotify = requestHolder;
                    }

                    @Override
                    public void onRejection(Exception e) {
                        TransportService.this.logger.debug(() -> new ParameterizedMessage("failed to notify response handler on rejection, action: {}", (Object)this.val$holderToNotify.action()), (Throwable)e);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        TransportService.this.logger.warn(() -> new ParameterizedMessage("failed to notify response handler on exception, action: {}", (Object)this.val$holderToNotify.action()), (Throwable)e);
                    }

                    @Override
                    public void doRun() {
                        TransportException ex = new TransportException("transport stopped, action: " + this.val$holderToNotify.action());
                        this.val$holderToNotify.handler().handleException(ex);
                    }
                });
            }
            throw throwable;
        }
        for (Map.Entry entry : this.clientHandlers.entrySet()) {
            RequestHolder holderToNotify = (RequestHolder)this.clientHandlers.remove(entry.getKey());
            if (holderToNotify == null) continue;
            this.threadPool.generic().execute(new /* invalid duplicate definition of identical inner class */);
        }
    }

    @Override
    protected void doClose() {
        this.transport.close();
    }

    public final void acceptIncomingRequests() {
        this.blockIncomingRequestsLatch.countDown();
    }

    public final boolean addressSupported(Class<? extends TransportAddress> address) {
        return this.transport.addressSupported(address);
    }

    public TransportInfo info() {
        BoundTransportAddress boundTransportAddress = this.boundAddress();
        if (boundTransportAddress == null) {
            return null;
        }
        return new TransportInfo(boundTransportAddress, this.transport.profileBoundAddresses());
    }

    public TransportStats stats() {
        return new TransportStats(this.transport.serverOpen(), this.adapter.rxMetric.count(), this.adapter.rxMetric.sum(), this.adapter.txMetric.count(), this.adapter.txMetric.sum());
    }

    public BoundTransportAddress boundAddress() {
        return this.transport.boundAddress();
    }

    public List<String> getLocalAddresses() {
        return this.transport.getLocalAddresses();
    }

    public boolean nodeConnected(DiscoveryNode node) {
        return this.isLocalNode(node) || this.transport.nodeConnected(node);
    }

    public void connectToNode(DiscoveryNode node) throws ConnectTransportException {
        this.connectToNode(node, null);
    }

    public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile) {
        if (this.isLocalNode(node)) {
            return;
        }
        this.transport.connectToNode(node, connectionProfile, (newConnection, actualProfile) -> {
            DiscoveryNode remote = this.handshake((Transport.Connection)newConnection, actualProfile.getHandshakeTimeout().millis(), cn -> true);
            if (!node.equals(remote)) {
                throw new ConnectTransportException(node, "handshake failed. unexpected remote node " + remote);
            }
        });
    }

    public Transport.Connection openConnection(DiscoveryNode node, ConnectionProfile profile) throws IOException {
        if (this.isLocalNode(node)) {
            return this.localNodeConnection;
        }
        return this.transport.openConnection(node, profile);
    }

    public DiscoveryNode handshake(Transport.Connection connection, long handshakeTimeout) throws ConnectTransportException {
        return this.handshake(connection, handshakeTimeout, this.clusterName::equals);
    }

    public DiscoveryNode handshake(Transport.Connection connection, long handshakeTimeout, Predicate<ClusterName> clusterNamePredicate) throws ConnectTransportException {
        HandshakeResponse response;
        DiscoveryNode node = connection.getNode();
        try {
            PlainTransportFuture<HandshakeResponse> futureHandler = new PlainTransportFuture<HandshakeResponse>(new FutureTransportResponseHandler<HandshakeResponse>(){

                @Override
                public HandshakeResponse newInstance() {
                    return new HandshakeResponse();
                }
            });
            this.sendRequest(connection, HANDSHAKE_ACTION_NAME, (TransportRequest)HandshakeRequest.INSTANCE, TransportRequestOptions.builder().withTimeout(handshakeTimeout).build(), futureHandler);
            response = (HandshakeResponse)futureHandler.txGet();
        }
        catch (Exception e) {
            throw new IllegalStateException("handshake failed with " + node, e);
        }
        if (!clusterNamePredicate.test(response.clusterName)) {
            throw new IllegalStateException("handshake failed, mismatched cluster name [" + response.clusterName + "] - " + node);
        }
        if (!response.version.isCompatible(this.localNode.getVersion())) {
            throw new IllegalStateException("handshake failed, incompatible version [" + response.version + "] - " + node);
        }
        return response.discoveryNode;
    }

    public void disconnectFromNode(DiscoveryNode node) {
        if (this.isLocalNode(node)) {
            return;
        }
        this.transport.disconnectFromNode(node);
    }

    public void addConnectionListener(TransportConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(TransportConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public <T extends TransportResponse> TransportFuture<T> submitRequest(DiscoveryNode node, String action, TransportRequest request, TransportResponseHandler<T> handler) throws TransportException {
        return this.submitRequest(node, action, request, TransportRequestOptions.EMPTY, handler);
    }

    public <T extends TransportResponse> TransportFuture<T> submitRequest(DiscoveryNode node, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) throws TransportException {
        PlainTransportFuture<T> futureHandler = new PlainTransportFuture<T>(handler);
        try {
            Transport.Connection connection = this.getConnection(node);
            this.sendRequest(connection, action, request, options, futureHandler);
        }
        catch (NodeNotConnectedException ex) {
            futureHandler.handleException(ex);
        }
        return futureHandler;
    }

    public <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportResponseHandler<T> handler) {
        try {
            Transport.Connection connection = this.getConnection(node);
            this.sendRequest(connection, action, request, TransportRequestOptions.EMPTY, handler);
        }
        catch (NodeNotConnectedException ex) {
            handler.handleException(ex);
        }
    }

    public final <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        try {
            Transport.Connection connection = this.getConnection(node);
            this.sendRequest(connection, action, request, options, handler);
        }
        catch (NodeNotConnectedException ex) {
            handler.handleException(ex);
        }
    }

    public final <T extends TransportResponse> void sendRequest(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        this.asyncSender.sendRequest(connection, action, request, options, handler);
    }

    public Transport.Connection getConnection(DiscoveryNode node) {
        if (this.isLocalNode(node)) {
            return this.localNodeConnection;
        }
        return this.transport.getConnection(node);
    }

    public <T extends TransportResponse> void sendChildRequest(Transport.Connection connection, String action, TransportRequest request, Task parentTask, TransportResponseHandler<T> handler) {
        this.sendChildRequest(connection, action, request, parentTask, TransportRequestOptions.EMPTY, handler);
    }

    public <T extends TransportResponse> void sendChildRequest(Transport.Connection connection, String action, TransportRequest request, Task parentTask, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        request.setParentTask(this.localNode.getId(), parentTask.getId());
        try {
            this.sendRequest(connection, action, request, options, handler);
        }
        catch (TaskCancelledException ex) {
            handler.handleException(new TransportException(ex));
        }
        catch (NodeNotConnectedException ex) {
            handler.handleException(ex);
        }
    }

    private <T extends TransportResponse> void sendRequestInternal(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        if (connection == null) {
            throw new IllegalStateException("can't send request to a null connection");
        }
        DiscoveryNode node = connection.getNode();
        long requestId = this.transport.newRequestId();
        try {
            TimeoutHandler timeoutHandler = options.timeout() == null ? null : new TimeoutHandler(requestId);
            Supplier<ThreadContext.StoredContext> storedContextSupplier = this.threadPool.getThreadContext().newRestorableContext(true);
            ContextRestoreResponseHandler<T> responseHandler = new ContextRestoreResponseHandler<T>(storedContextSupplier, handler);
            this.clientHandlers.put(requestId, new RequestHolder<T>(responseHandler, connection, action, timeoutHandler));
            if (this.lifecycle.stoppedOrClosed()) {
                throw new TransportException("TransportService is closed stopped can't send request");
            }
            if (timeoutHandler != null) {
                assert (options.timeout() != null);
                timeoutHandler.future = this.threadPool.schedule(options.timeout(), "generic", timeoutHandler);
            }
            connection.sendRequest(requestId, action, request, options);
        }
        catch (Exception e) {
            final RequestHolder holderToNotify = this.clientHandlers.remove(requestId);
            if (holderToNotify != null) {
                holderToNotify.cancelTimeout();
                final SendRequestTransportException sendRequestException = new SendRequestTransportException(node, action, e);
                this.threadPool.executor("generic").execute(new AbstractRunnable(){

                    @Override
                    public void onRejection(Exception e) {
                        TransportService.this.logger.debug(() -> new ParameterizedMessage("failed to notify response handler on rejection, action: {}", (Object)holderToNotify.action()), (Throwable)e);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        TransportService.this.logger.warn(() -> new ParameterizedMessage("failed to notify response handler on exception, action: {}", (Object)holderToNotify.action()), (Throwable)e);
                    }

                    @Override
                    protected void doRun() throws Exception {
                        holderToNotify.handler().handleException(sendRequestException);
                    }
                });
            }
            this.logger.debug("Exception while sending request, handler likely already notified due to timeout", (Throwable)e);
        }
    }

    private void sendLocalRequest(long requestId, final String action, final TransportRequest request, TransportRequestOptions options) {
        final DirectResponseChannel channel = new DirectResponseChannel(this.logger, this.localNode, action, requestId, this.adapter, this.threadPool);
        try {
            this.adapter.onRequestSent(this.localNode, requestId, action, request, options);
            this.adapter.onRequestReceived(requestId, action);
            final RequestHandlerRegistry reg = this.adapter.getRequestHandler(action);
            if (reg == null) {
                throw new ActionNotFoundTransportException("Action [" + action + "] not found");
            }
            String executor = reg.getExecutor();
            if ("same".equals(executor)) {
                reg.processMessageReceived(request, channel);
            } else {
                this.threadPool.executor(executor).execute(new AbstractRunnable(){

                    @Override
                    protected void doRun() throws Exception {
                        reg.processMessageReceived(request, channel);
                    }

                    @Override
                    public boolean isForceExecution() {
                        return reg.isForceExecution();
                    }

                    @Override
                    public void onFailure(Exception e) {
                        try {
                            channel.sendResponse(e);
                        }
                        catch (Exception inner) {
                            inner.addSuppressed(e);
                            TransportService.this.logger.warn(() -> new ParameterizedMessage("failed to notify channel of error message for action [{}]", (Object)action), (Throwable)inner);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            try {
                channel.sendResponse(e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                this.logger.warn(() -> new ParameterizedMessage("failed to notify channel of error message for action [{}]", (Object)action), (Throwable)inner);
            }
        }
    }

    private boolean shouldTraceAction(String action) {
        if (this.tracerLogInclude.length > 0 && !Regex.simpleMatch(this.tracerLogInclude, action)) {
            return false;
        }
        if (this.tracerLogExclude.length > 0) {
            return !Regex.simpleMatch(this.tracerLogExclude, action);
        }
        return true;
    }

    public TransportAddress[] addressesFromString(String address, int perAddressLimit) throws UnknownHostException {
        return this.transport.addressesFromString(address, perAddressLimit);
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, Supplier<Request> requestFactory, String executor, TransportRequestHandler<Request> handler) {
        handler = this.interceptor.interceptHandler(action, executor, false, handler);
        RequestHandlerRegistry<Request> reg = new RequestHandlerRegistry<Request>(action, requestFactory, this.taskManager, handler, executor, false, true);
        this.registerRequestHandler(reg);
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, Supplier<Request> request, String executor, boolean forceExecution, boolean canTripCircuitBreaker, TransportRequestHandler<Request> handler) {
        handler = this.interceptor.interceptHandler(action, executor, forceExecution, handler);
        RequestHandlerRegistry<Request> reg = new RequestHandlerRegistry<Request>(action, request, this.taskManager, handler, executor, forceExecution, canTripCircuitBreaker);
        this.registerRequestHandler(reg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Request extends TransportRequest> void registerRequestHandler(RequestHandlerRegistry<Request> reg) {
        Object object = this.requestHandlerMutex;
        synchronized (object) {
            if (this.requestHandlers.containsKey(reg.getAction())) {
                throw new IllegalArgumentException("transport handlers for action " + reg.getAction() + " is already registered");
            }
            this.requestHandlers = MapBuilder.newMapBuilder(this.requestHandlers).put(reg.getAction(), reg).immutableMap();
        }
    }

    protected RequestHandlerRegistry getRequestHandler(String action) {
        return this.requestHandlers.get(action);
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    private boolean isLocalNode(DiscoveryNode discoveryNode) {
        return Objects.requireNonNull(discoveryNode, "discovery node must not be null").equals(this.localNode);
    }

    static class DirectResponseChannel
    implements TransportChannel {
        final Logger logger;
        final DiscoveryNode localNode;
        private final String action;
        private final long requestId;
        final TransportServiceAdapter adapter;
        final ThreadPool threadPool;

        DirectResponseChannel(Logger logger, DiscoveryNode localNode, String action, long requestId, TransportServiceAdapter adapter, ThreadPool threadPool) {
            this.logger = logger;
            this.localNode = localNode;
            this.action = action;
            this.requestId = requestId;
            this.adapter = adapter;
            this.threadPool = threadPool;
        }

        @Override
        public String action() {
            return this.action;
        }

        @Override
        public String getProfileName() {
            return TransportService.DIRECT_RESPONSE_PROFILE;
        }

        @Override
        public void sendResponse(TransportResponse response) throws IOException {
            this.sendResponse(response, TransportResponseOptions.EMPTY);
        }

        @Override
        public void sendResponse(TransportResponse response, TransportResponseOptions options) throws IOException {
            this.adapter.onResponseSent(this.requestId, this.action, response, options);
            TransportResponseHandler handler = this.adapter.onResponseReceived(this.requestId);
            if (handler != null) {
                String executor = handler.executor();
                if ("same".equals(executor)) {
                    this.processResponse(handler, response);
                } else {
                    this.threadPool.executor(executor).execute(() -> this.processResponse(handler, response));
                }
            }
        }

        protected void processResponse(TransportResponseHandler handler, TransportResponse response) {
            try {
                handler.handleResponse(response);
            }
            catch (Exception e) {
                this.processException(handler, this.wrapInRemote(new ResponseHandlerFailureTransportException(e)));
            }
        }

        @Override
        public void sendResponse(Exception exception) throws IOException {
            this.adapter.onResponseSent(this.requestId, this.action, exception);
            final TransportResponseHandler handler = this.adapter.onResponseReceived(this.requestId);
            if (handler != null) {
                final RemoteTransportException rtx = this.wrapInRemote(exception);
                String executor = handler.executor();
                if ("same".equals(executor)) {
                    this.processException(handler, rtx);
                } else {
                    this.threadPool.executor(handler.executor()).execute(new Runnable(){

                        @Override
                        public void run() {
                            this.processException(handler, rtx);
                        }
                    });
                }
            }
        }

        protected RemoteTransportException wrapInRemote(Exception e) {
            if (e instanceof RemoteTransportException) {
                return (RemoteTransportException)e;
            }
            return new RemoteTransportException(this.localNode.getName(), this.localNode.getAddress(), this.action, e);
        }

        protected void processException(TransportResponseHandler handler, RemoteTransportException rtx) {
            try {
                handler.handleException(rtx);
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("failed to handle exception for action [{}], handler [{}]", (Object)this.action, (Object)handler), (Throwable)e);
            }
        }

        @Override
        public long getRequestId() {
            return this.requestId;
        }

        @Override
        public String getChannelType() {
            return "direct";
        }

        @Override
        public Version getVersion() {
            return this.localNode.getVersion();
        }
    }

    public static final class ContextRestoreResponseHandler<T extends TransportResponse>
    implements TransportResponseHandler<T> {
        private final TransportResponseHandler<T> delegate;
        private final Supplier<ThreadContext.StoredContext> contextSupplier;

        public ContextRestoreResponseHandler(Supplier<ThreadContext.StoredContext> contextSupplier, TransportResponseHandler<T> delegate) {
            this.delegate = delegate;
            this.contextSupplier = contextSupplier;
        }

        @Override
        public T newInstance() {
            return this.delegate.newInstance();
        }

        @Override
        public void handleResponse(T response) {
            try (ThreadContext.StoredContext ignore = this.contextSupplier.get();){
                this.delegate.handleResponse(response);
            }
        }

        @Override
        public void handleException(TransportException exp) {
            try (ThreadContext.StoredContext ignore = this.contextSupplier.get();){
                this.delegate.handleException(exp);
            }
        }

        @Override
        public String executor() {
            return this.delegate.executor();
        }

        public String toString() {
            return this.getClass().getName() + "/" + this.delegate.toString();
        }
    }

    static class RequestHolder<T extends TransportResponse> {
        private final TransportResponseHandler<T> handler;
        private final Transport.Connection connection;
        private final String action;
        private final TimeoutHandler timeoutHandler;

        RequestHolder(TransportResponseHandler<T> handler, Transport.Connection connection, String action, TimeoutHandler timeoutHandler) {
            this.handler = handler;
            this.connection = connection;
            this.action = action;
            this.timeoutHandler = timeoutHandler;
        }

        public TransportResponseHandler<T> handler() {
            return this.handler;
        }

        public Transport.Connection connection() {
            return this.connection;
        }

        public String action() {
            return this.action;
        }

        public void cancelTimeout() {
            if (this.timeoutHandler != null) {
                this.timeoutHandler.cancel();
            }
        }
    }

    static class TimeoutInfoHolder {
        private final DiscoveryNode node;
        private final String action;
        private final long sentTime;
        private final long timeoutTime;

        TimeoutInfoHolder(DiscoveryNode node, String action, long sentTime, long timeoutTime) {
            this.node = node;
            this.action = action;
            this.sentTime = sentTime;
            this.timeoutTime = timeoutTime;
        }

        public DiscoveryNode node() {
            return this.node;
        }

        public String action() {
            return this.action;
        }

        public long sentTime() {
            return this.sentTime;
        }

        public long timeoutTime() {
            return this.timeoutTime;
        }
    }

    class TimeoutHandler
    implements Runnable {
        private final long requestId;
        private final long sentTime = System.currentTimeMillis();
        volatile ScheduledFuture future;

        TimeoutHandler(long requestId) {
            this.requestId = requestId;
        }

        @Override
        public void run() {
            RequestHolder holder = TransportService.this.clientHandlers.get(this.requestId);
            if (holder != null) {
                long timeoutTime = System.currentTimeMillis();
                TransportService.this.timeoutInfoHandlers.put(this.requestId, new TimeoutInfoHolder(holder.connection().getNode(), holder.action(), this.sentTime, timeoutTime));
                RequestHolder removedHolder = TransportService.this.clientHandlers.remove(this.requestId);
                if (removedHolder != null) {
                    assert (removedHolder == holder) : "two different holder instances for request [" + this.requestId + "]";
                    removedHolder.handler().handleException(new ReceiveTimeoutTransportException(holder.connection().getNode(), holder.action(), "request_id [" + this.requestId + "] timed out after [" + (timeoutTime - this.sentTime) + "ms]"));
                } else {
                    TransportService.this.timeoutInfoHandlers.remove(this.requestId);
                }
            }
        }

        public void cancel() {
            assert (TransportService.this.clientHandlers.get(this.requestId) == null) : "cancel must be called after the requestId [" + this.requestId + "] has been removed from clientHandlers";
            FutureUtils.cancel(this.future);
        }
    }

    protected class Adapter
    implements TransportServiceAdapter {
        final MeanMetric rxMetric = new MeanMetric();
        final MeanMetric txMetric = new MeanMetric();

        protected Adapter() {
        }

        @Override
        public void addBytesReceived(long size) {
            this.rxMetric.inc(size);
        }

        @Override
        public void addBytesSent(long size) {
            this.txMetric.inc(size);
        }

        @Override
        public void onRequestSent(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) {
            if (this.traceEnabled() && TransportService.this.shouldTraceAction(action)) {
                this.traceRequestSent(node, requestId, action, options);
            }
        }

        protected boolean traceEnabled() {
            return TransportService.this.tracerLog.isTraceEnabled();
        }

        @Override
        public void onResponseSent(long requestId, String action, TransportResponse response, TransportResponseOptions options) {
            if (this.traceEnabled() && TransportService.this.shouldTraceAction(action)) {
                this.traceResponseSent(requestId, action);
            }
        }

        @Override
        public void onResponseSent(long requestId, String action, Exception e) {
            if (this.traceEnabled() && TransportService.this.shouldTraceAction(action)) {
                this.traceResponseSent(requestId, action, e);
            }
        }

        protected void traceResponseSent(long requestId, String action, Exception e) {
            TransportService.this.tracerLog.trace(() -> new ParameterizedMessage("[{}][{}] sent error response", (Object)requestId, (Object)action), (Throwable)e);
        }

        @Override
        public void onRequestReceived(long requestId, String action) {
            try {
                TransportService.this.blockIncomingRequestsLatch.await();
            }
            catch (InterruptedException e) {
                TransportService.this.logger.trace("interrupted while waiting for incoming requests block to be removed");
            }
            if (this.traceEnabled() && TransportService.this.shouldTraceAction(action)) {
                this.traceReceivedRequest(requestId, action);
            }
        }

        @Override
        public RequestHandlerRegistry getRequestHandler(String action) {
            return TransportService.this.requestHandlers.get(action);
        }

        @Override
        public TransportResponseHandler onResponseReceived(long requestId) {
            RequestHolder holder = TransportService.this.clientHandlers.remove(requestId);
            if (holder == null) {
                this.checkForTimeout(requestId);
                return null;
            }
            holder.cancelTimeout();
            if (this.traceEnabled() && TransportService.this.shouldTraceAction(holder.action())) {
                this.traceReceivedResponse(requestId, holder.connection().getNode(), holder.action());
            }
            return holder.handler();
        }

        protected void checkForTimeout(long requestId) {
            DiscoveryNode sourceNode;
            String action;
            assert (TransportService.this.clientHandlers.get(requestId) == null);
            TimeoutInfoHolder timeoutInfoHolder = TransportService.this.timeoutInfoHandlers.remove(requestId);
            if (timeoutInfoHolder != null) {
                long time = System.currentTimeMillis();
                TransportService.this.logger.warn("Received response for a request that has timed out, sent [{}ms] ago, timed out [{}ms] ago, action [{}], node [{}], id [{}]", (Object)(time - timeoutInfoHolder.sentTime()), (Object)(time - timeoutInfoHolder.timeoutTime()), (Object)timeoutInfoHolder.action(), (Object)timeoutInfoHolder.node(), (Object)requestId);
                action = timeoutInfoHolder.action();
                sourceNode = timeoutInfoHolder.node();
            } else {
                TransportService.this.logger.warn("Transport response handler not found of id [{}]", (Object)requestId);
                action = null;
                sourceNode = null;
            }
            if (!this.traceEnabled()) {
                return;
            }
            if (action == null) {
                assert (sourceNode == null);
                this.traceUnresolvedResponse(requestId);
            } else if (TransportService.this.shouldTraceAction(action)) {
                this.traceReceivedResponse(requestId, sourceNode, action);
            }
        }

        @Override
        public void onNodeConnected(DiscoveryNode node) {
            Stream listenersToNotify = TransportService.this.connectionListeners.stream();
            TransportService.this.threadPool.generic().execute(() -> listenersToNotify.forEach(listener -> listener.onNodeConnected(node)));
        }

        @Override
        public void onConnectionOpened(Transport.Connection connection) {
            Stream listenersToNotify = TransportService.this.connectionListeners.stream();
            TransportService.this.threadPool.generic().execute(() -> listenersToNotify.forEach(listener -> listener.onConnectionOpened(connection)));
        }

        @Override
        public void onNodeDisconnected(DiscoveryNode node) {
            try {
                TransportService.this.threadPool.generic().execute(() -> {
                    for (TransportConnectionListener connectionListener : TransportService.this.connectionListeners) {
                        connectionListener.onNodeDisconnected(node);
                    }
                });
            }
            catch (EsRejectedExecutionException ex) {
                TransportService.this.logger.debug("Rejected execution on NodeDisconnected", (Throwable)ex);
            }
        }

        @Override
        public void onConnectionClosed(Transport.Connection connection) {
            try {
                for (Map.Entry entry : TransportService.this.clientHandlers.entrySet()) {
                    RequestHolder holderToNotify;
                    RequestHolder holder = (RequestHolder)entry.getValue();
                    if (!holder.connection().getCacheKey().equals(connection.getCacheKey()) || (holderToNotify = (RequestHolder)TransportService.this.clientHandlers.remove(entry.getKey())) == null) continue;
                    TransportService.this.threadPool.generic().execute(() -> holderToNotify.handler().handleException(new NodeDisconnectedException(connection.getNode(), holderToNotify.action())));
                }
            }
            catch (EsRejectedExecutionException ex) {
                TransportService.this.logger.debug("Rejected execution on onConnectionClosed", (Throwable)ex);
            }
        }

        protected void traceReceivedRequest(long requestId, String action) {
            TransportService.this.tracerLog.trace("[{}][{}] received request", (Object)requestId, (Object)action);
        }

        protected void traceResponseSent(long requestId, String action) {
            TransportService.this.tracerLog.trace("[{}][{}] sent response", (Object)requestId, (Object)action);
        }

        protected void traceReceivedResponse(long requestId, DiscoveryNode sourceNode, String action) {
            TransportService.this.tracerLog.trace("[{}][{}] received response from [{}]", (Object)requestId, (Object)action, (Object)sourceNode);
        }

        protected void traceUnresolvedResponse(long requestId) {
            TransportService.this.tracerLog.trace("[{}] received response but can't resolve it to a request", (Object)requestId);
        }

        protected void traceRequestSent(DiscoveryNode node, long requestId, String action, TransportRequestOptions options) {
            TransportService.this.tracerLog.trace("[{}][{}] sent to [{}] (timeout: [{}])", (Object)requestId, (Object)action, (Object)node, (Object)options.timeout());
        }
    }

    public static class HandshakeResponse
    extends TransportResponse {
        private DiscoveryNode discoveryNode;
        private ClusterName clusterName;
        private Version version;

        HandshakeResponse() {
        }

        public HandshakeResponse(DiscoveryNode discoveryNode, ClusterName clusterName, Version version) {
            this.discoveryNode = discoveryNode;
            this.version = version;
            this.clusterName = clusterName;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.discoveryNode = in.readOptionalWriteable(DiscoveryNode::new);
            this.clusterName = new ClusterName(in);
            this.version = Version.readVersion(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalWriteable(this.discoveryNode);
            this.clusterName.writeTo(out);
            Version.writeVersion(this.version, out);
        }
    }

    static class HandshakeRequest
    extends TransportRequest {
        public static final HandshakeRequest INSTANCE = new HandshakeRequest();

        private HandshakeRequest() {
        }
    }
}

