/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public class ChangesetCellRenderer
extends JLabel
implements ListCellRenderer<Changeset> {
    private final ImageIcon icon = ImageProvider.get("data", "changeset");

    public ChangesetCellRenderer() {
        this.setOpaque(true);
    }

    protected String buildToolTipText(Changeset changeset) {
        String string;
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("<html><strong>").append(I18n.tr("Changeset id:", new Object[0])).append("</strong>").append(changeset.getId()).append("<br>");
        Date date = changeset.getCreatedAt();
        if (date != null) {
            stringBuilder.append("<strong>").append(I18n.tr("Created at:", new Object[0])).append("</strong>").append(DateUtils.formatDateTime(date, 3, 3)).append("<br>");
        }
        if ((string = changeset.get("comment")) != null) {
            stringBuilder.append("<strong>").append(I18n.tr("Changeset comment:", new Object[0])).append("</strong>").append(Utils.escapeReservedCharactersHTML(string)).append("<br>");
        }
        return stringBuilder.toString();
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Changeset> jList, Changeset changeset, int n, boolean bl, boolean bl2) {
        if (bl) {
            this.setForeground(UIManager.getColor("List.selectionForeground"));
            this.setBackground(UIManager.getColor("List.selectionBackground"));
        } else {
            this.setForeground(UIManager.getColor("List.foreground"));
            this.setBackground(UIManager.getColor("List.background"));
        }
        if (changeset != null) {
            this.setIcon(this.icon);
            StringBuilder stringBuilder = new StringBuilder();
            String string = changeset.get("comment");
            if (string != null) {
                stringBuilder.append(changeset.getId()).append(" - ").append(string);
            } else if (changeset.get("name") != null) {
                stringBuilder.append(changeset.getId()).append(" - ").append(changeset.get("name"));
            } else {
                stringBuilder.append(I18n.tr("Changeset {0}", changeset.getId()));
            }
            this.setText(stringBuilder.toString());
            this.setToolTipText(this.buildToolTipText(changeset));
        } else {
            this.setText(I18n.tr("No open changeset", new Object[0]));
        }
        return this;
    }
}

