/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement.placement;

import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.draw.MapViewPath;
import org.openstreetmap.josm.gui.draw.MapViewPositionAndRotation;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.PositionForAreaStrategy;

public class OnLineStrategy
implements PositionForAreaStrategy {
    public static final OnLineStrategy INSTANCE = new OnLineStrategy(0.0);
    private final double yOffset;

    public OnLineStrategy(double d) {
        this.yOffset = d;
    }

    @Override
    public MapViewPositionAndRotation findLabelPlacement(MapViewPath mapViewPath, Rectangle2D rectangle2D) {
        return OnLineStrategy.findOptimalWayPosition(rectangle2D, mapViewPath).map(halfSegment -> {
            MapViewState.MapViewPoint mapViewPoint = ((HalfSegment)halfSegment).start.interpolate(((HalfSegment)halfSegment).end, 0.5);
            return new MapViewPositionAndRotation(mapViewPoint, OnLineStrategy.upsideTheta(halfSegment));
        }).orElse(null);
    }

    private static double upsideTheta(HalfSegment halfSegment) {
        double d = OnLineStrategy.theta(halfSegment.start, halfSegment.end);
        if (d < -1.5707963267948966) {
            return d + Math.PI;
        }
        if (d > 1.5707963267948966) {
            return d - Math.PI;
        }
        return d;
    }

    @Override
    public boolean supportsGlyphVector() {
        return true;
    }

    @Override
    public List<GlyphVector> generateGlyphVectors(MapViewPath mapViewPath, Rectangle2D rectangle2D, List<GlyphVector> list, boolean bl) {
        double d = OnLineStrategy.findOptimalWayPosition(rectangle2D, mapViewPath).map(halfSegment -> ((HalfSegment)halfSegment).offset).orElse(mapViewPath.getLength() / 2.0);
        UpsideComputingVisitor upsideComputingVisitor = new UpsideComputingVisitor(d - rectangle2D.getWidth() / 2.0, d + rectangle2D.getWidth() / 2.0);
        mapViewPath.visitLine(upsideComputingVisitor);
        boolean bl2 = upsideComputingVisitor.shouldRotateText();
        List<OffsetGlyph> list2 = OnLineStrategy.computeOffsetGlyphs(list, d + (double)(bl2 ? 1 : -1) * rectangle2D.getWidth() / 2.0, bl2);
        Collections.sort(list2, Comparator.comparing(OffsetGlyph::getOffset));
        mapViewPath.visitLine(new GlyphRotatingVisitor(list2, bl));
        return list;
    }

    private static List<OffsetGlyph> computeOffsetGlyphs(List<GlyphVector> list, double d, boolean bl) {
        double d2 = d;
        ArrayList<OffsetGlyph> arrayList = new ArrayList<OffsetGlyph>();
        for (GlyphVector glyphVector : list) {
            double d3 = d2;
            IntStream.range(0, glyphVector.getNumGlyphs()).mapToObj(n -> new OffsetGlyph(d3, bl, glyphVector, n)).forEach(arrayList::add);
            d2 += (double)(bl ? -1 : 1) + glyphVector.getLogicalBounds().getBounds2D().getWidth();
        }
        return arrayList;
    }

    private static Optional<HalfSegment> findOptimalWayPosition(Rectangle2D rectangle2D, MapViewPath mapViewPath) {
        ArrayList arrayList = new ArrayList();
        double d = 2.0 * (rectangle2D.getWidth() + 4.0);
        double d3 = mapViewPath.visitLine((d2, mapViewPoint, mapViewPoint2, bl) -> {
            double d3 = mapViewPoint.distanceToInView(mapViewPoint2);
            if (d3 > d) {
                MapViewState.MapViewPoint mapViewPoint3 = mapViewPoint.interpolate(mapViewPoint2, 0.5);
                double d4 = OnLineStrategy.computeQuality(mapViewPoint, mapViewPoint3);
                arrayList.add(new HalfSegment(mapViewPoint, mapViewPoint3, d4 + 0.1, d2 + 0.25 * d3));
                d4 = OnLineStrategy.computeQuality(mapViewPoint3, mapViewPoint2);
                arrayList.add(new HalfSegment(mapViewPoint3, mapViewPoint2, d4, d2 + 0.75 * d3));
            }
        });
        return arrayList.stream().max(Comparator.comparingDouble(halfSegment -> ((HalfSegment)halfSegment).quality - 1.0E-5 * Math.abs(((HalfSegment)halfSegment).offset - d3 / 2.0)));
    }

    private static double computeQuality(MapViewState.MapViewPoint mapViewPoint, MapViewState.MapViewPoint mapViewPoint2) {
        double d = 0.0;
        if (mapViewPoint.isInView()) {
            d += 1.0;
        }
        if (mapViewPoint2.isInView()) {
            d += 1.0;
        }
        return d;
    }

    private static double theta(MapViewState.MapViewPoint mapViewPoint, MapViewState.MapViewPoint mapViewPoint2) {
        return Math.atan2(mapViewPoint2.getInViewY() - mapViewPoint.getInViewY(), mapViewPoint2.getInViewX() - mapViewPoint.getInViewX());
    }

    private static class OffsetGlyph {
        private final double offset;
        private final double preRotate;
        private final GlyphVector glyph;
        private final int glyphIndex;

        OffsetGlyph(double d, boolean bl, GlyphVector glyphVector, int n) {
            this.preRotate = bl ? Math.PI : 0.0;
            this.glyph = glyphVector;
            this.glyphIndex = n;
            Rectangle2D rectangle2D = this.getBounds();
            this.offset = d + (double)(bl ? -1 : 1) * (rectangle2D.getX() + rectangle2D.getWidth() / 2.0);
        }

        Rectangle2D getBounds() {
            return this.glyph.getGlyphLogicalBounds(this.glyphIndex).getBounds2D();
        }

        double getOffset() {
            return this.offset;
        }

        public String toString() {
            return "OffsetGlyph [offset=" + this.offset + ", preRotate=" + this.preRotate + ", glyphIndex=" + this.glyphIndex + ']';
        }
    }

    private class GlyphRotatingVisitor
    implements MapViewPath.PathSegmentConsumer {
        private final Iterator<OffsetGlyph> gvs;
        private final boolean isDoubleTranslationBug;
        private OffsetGlyph next;

        GlyphRotatingVisitor(List<OffsetGlyph> list, boolean bl) {
            this.isDoubleTranslationBug = bl;
            this.gvs = list.iterator();
            this.takeNext();
            while (this.next != null && this.next.offset < 0.0) {
                this.takeNext();
            }
        }

        private void takeNext() {
            this.next = this.gvs.hasNext() ? this.gvs.next() : null;
        }

        @Override
        public void addLineBetween(double d, MapViewState.MapViewPoint mapViewPoint, MapViewState.MapViewPoint mapViewPoint2, boolean bl) {
            double d2 = mapViewPoint.distanceToInView(mapViewPoint2);
            double d3 = d + d2;
            double d4 = OnLineStrategy.theta(mapViewPoint, mapViewPoint2);
            while (this.next != null && this.next.offset < d3) {
                Rectangle2D rectangle2D = this.next.getBounds();
                double d5 = 0.0;
                MapViewState.MapViewPoint mapViewPoint3 = mapViewPoint.interpolate(mapViewPoint2, (this.next.offset - d) / d2);
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(-rectangle2D.getCenterX(), -d5);
                affineTransform.translate(mapViewPoint3.getInViewX(), mapViewPoint3.getInViewY());
                affineTransform.rotate(d4 + this.next.preRotate, rectangle2D.getWidth() / 2.0, d5);
                affineTransform.translate(0.0, (double)this.next.glyph.getFont().getSize2D() * 0.25);
                affineTransform.translate(0.0, OnLineStrategy.this.yOffset);
                if (this.isDoubleTranslationBug) {
                    AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(-0.5 * affineTransform.getTranslateX(), -0.5 * affineTransform.getTranslateY());
                    affineTransform2.concatenate(affineTransform);
                    affineTransform = affineTransform2;
                }
                this.next.glyph.setGlyphTransform(this.next.glyphIndex, affineTransform);
                this.takeNext();
            }
        }
    }

    private static class UpsideComputingVisitor
    implements MapViewPath.PathSegmentConsumer {
        private final double startOffset;
        private final double endOffset;
        private double upsideUpLines;
        private double upsideDownLines;

        UpsideComputingVisitor(double d, double d2) {
            this.startOffset = d;
            this.endOffset = d2;
        }

        @Override
        public void addLineBetween(double d, MapViewState.MapViewPoint mapViewPoint, MapViewState.MapViewPoint mapViewPoint2, boolean bl) {
            if (d > this.endOffset) {
                return;
            }
            double d2 = mapViewPoint.distanceToInView(mapViewPoint2);
            if (d + d2 < this.startOffset) {
                return;
            }
            double d3 = Math.max(d, this.startOffset);
            double d4 = Math.min(d + d2, this.endOffset);
            double d5 = d4 - d3;
            if (mapViewPoint.getInViewX() < mapViewPoint2.getInViewX()) {
                this.upsideUpLines += d5;
            } else {
                this.upsideDownLines += d5;
            }
        }

        boolean shouldRotateText() {
            return this.upsideUpLines < this.upsideDownLines;
        }
    }

    private static class HalfSegment {
        private final MapViewState.MapViewPoint start;
        private final MapViewState.MapViewPoint end;
        private final double quality;
        private final double offset;

        HalfSegment(MapViewState.MapViewPoint mapViewPoint, MapViewState.MapViewPoint mapViewPoint2, double d, double d2) {
            this.start = mapViewPoint;
            this.end = mapViewPoint2;
            this.quality = d;
            this.offset = d2;
        }

        public String toString() {
            return "HalfSegment [start=" + this.start + ", end=" + this.end + ", quality=" + this.quality + ']';
        }
    }
}

