/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Objects;

public final class Pair<A, B> {
    public A a;
    public B b;

    public Pair(A a, B b) {
        this.a = a;
        this.b = b;
    }

    public int hashCode() {
        return Objects.hash(this.a, this.b);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Pair pair = (Pair)object;
        return Objects.equals(this.a, pair.a) && Objects.equals(this.b, pair.b);
    }

    public static <T> Pair<T, T> sort(Pair<T, T> pair) {
        if (pair.b.hashCode() < pair.a.hashCode()) {
            Object a = pair.a;
            pair.a = pair.b;
            pair.b = a;
        }
        return pair;
    }

    public String toString() {
        return "<" + this.a + ',' + this.b + '>';
    }

    public static <U, V> Pair<U, V> create(U u, V v) {
        return new Pair<U, V>(u, v);
    }
}

