#ifndef _ELM_INTERFACE_ATSPI_TEXT_EO_H_
#define _ELM_INTERFACE_ATSPI_TEXT_EO_H_

#ifndef _ELM_INTERFACE_ATSPI_TEXT_EO_CLASS_TYPE
#define _ELM_INTERFACE_ATSPI_TEXT_EO_CLASS_TYPE

typedef Eo Elm_Interface_Atspi_Text;

#endif

#ifndef _ELM_INTERFACE_ATSPI_TEXT_EO_TYPES
#define _ELM_INTERFACE_ATSPI_TEXT_EO_TYPES

typedef enum
{
  ELM_ATSPI_TEXT_GRANULARITY_CHAR = 0,
  ELM_ATSPI_TEXT_GRANULARITY_WORD,
  ELM_ATSPI_TEXT_GRANULARITY_SENTENCE,
  ELM_ATSPI_TEXT_GRANULARITY_LINE,
  ELM_ATSPI_TEXT_GRANULARITY_PARAGRAPH
} Elm_Atspi_Text_Granularity;

typedef enum
{
  ELM_ATSPI_TEXT_CLIP_NONE = 0,
  ELM_ATSPI_TEXT_CLIP_MIN,
  ELM_ATSPI_TEXT_CLIP_MAX,
  ELM_ATSPI_TEXT_CLIP_BOTH
} Elm_Atspi_Text_Clip_Type;

typedef struct _Elm_Atspi_Text_Attribute
{
  const char *name;
  const char *value;
} Elm_Atspi_Text_Attribute;

typedef struct _Elm_Atspi_Text_Range
{
  int start_offset;
  int end_offset;
  char *content;
} Elm_Atspi_Text_Range;

typedef struct _Elm_Atspi_Text_Change_Info
{
  const char *content;
  Eina_Bool inserted;
  size_t pos;
  size_t len;
} Elm_Atspi_Text_Change_Info;


#endif
#define ELM_INTERFACE_ATSPI_TEXT_INTERFACE elm_interface_atspi_text_interface_get()

EWAPI const Eo_Class *elm_interface_atspi_text_interface_get(void);

#ifdef ELM_INTERFACE_ATSPI_TEXT_PROTECTED
/**
 * @brief Gets single character present in accessible widget's text at given
 * offset.
 *
 * @param[in] offset Position in text.
 *
 * @return Character at offset. 0 when out-of bounds offset has been given.
 *  Codepoints between DC80 and DCFF indicates that string includes invalid
 * UTF8 chars.
 *
 * @ingroup Elm_Interface_Atspi_Text
 */
EOAPI Eina_Unicode elm_interface_atspi_text_character_get(const Eo *obj, int offset);
#endif

#ifdef ELM_INTERFACE_ATSPI_TEXT_PROTECTED
/**
 * @brief Gets string, start and end offset in text according to given initial
 * offset and granulatity.
 *
 * @param[in] granularity
 * @param[in] start_offset Offset indicating start of string according to given
 * granularity.  -1 in case of error.
 * @param[in] end_offset Offset indicating end of string according to given
 * granularity. -1 in case of error.
 *
 * @return Newly allocated UTF-8 encoded string.  Must be free by a user.
 *
 * @ingroup Elm_Interface_Atspi_Text
 */
EOAPI char *elm_interface_atspi_text_string_get(const Eo *obj, Elm_Atspi_Text_Granularity granularity, int * start_offset, int * end_offset);
#endif

#ifdef ELM_INTERFACE_ATSPI_TEXT_PROTECTED
/**
 * @brief Gets text of accessible widget.
 *
 * @param[in] start_offset Position in text.
 * @param[in] end_offset End offset of text.
 *
 * @return UTF-8 encoded text.
 *
 * @ingroup Elm_Interface_Atspi_Text
 */
EOAPI char *elm_interface_atspi_text_get(const Eo *obj, int start_offset, int end_offset);
#endif

#ifdef ELM_INTERFACE_ATSPI_TEXT_PROTECTED
/** Gets offset position of caret (cursor)
 *
 * @ingroup Elm_Interface_Atspi_Text
 */
EOAPI int elm_interface_atspi_text_caret_offset_get(const Eo *obj);
#endif

#ifdef ELM_INTERFACE_ATSPI_TEXT_PROTECTED
EOAPI Eina_Bool elm_interface_atspi_text_caret_offset_set(Eo *obj, int offset);
#endif

#ifdef ELM_INTERFACE_ATSPI_TEXT_PROTECTED
/**
 * @brief Indicate if a text attribute with a given name is set
 *
 * @param[in] name text attribute name
 * @param[in] start_offset Position in text from which given attribute is set.
 * @param[in] end_offset Position in text to which given attribute is set.
 * @param[out] value Value of text attribute. Should be free()
 *
 * @ingroup Elm_Interface_Atspi_Text
 */
EOAPI Eina_Bool elm_interface_atspi_text_attribute_get(const Eo *obj, const char * name, int * start_offset, int * end_offset, char **value);
#endif

#ifdef ELM_INTERFACE_ATSPI_TEXT_PROTECTED
/**
 * @brief Gets list of all text attributes.
 *
 * @param[in] start_offset
 * @param[in] end_offset
 *
 * @ingroup Elm_Interface_Atspi_Text
 */
EOAPI Eina_List *elm_interface_atspi_text_attributes_get(const Eo *obj, int * start_offset, int * end_offset);
#endif

#ifdef ELM_INTERFACE_ATSPI_TEXT_PROTECTED
EOAPI Eina_List *elm_interface_atspi_text_default_attributes_get(const Eo *obj);
#endif

#ifdef ELM_INTERFACE_ATSPI_TEXT_PROTECTED
EOAPI Eina_Bool elm_interface_atspi_text_character_extents_get(const Eo *obj, int offset, Eina_Bool screen_coords, Eina_Rectangle *rect);
#endif

#ifdef ELM_INTERFACE_ATSPI_TEXT_PROTECTED
EOAPI int elm_interface_atspi_text_character_count_get(const Eo *obj);
#endif

#ifdef ELM_INTERFACE_ATSPI_TEXT_PROTECTED
EOAPI int elm_interface_atspi_text_offset_at_point_get(const Eo *obj, Eina_Bool screen_coords, int x, int y);
#endif

#ifdef ELM_INTERFACE_ATSPI_TEXT_PROTECTED
EOAPI Eina_List *elm_interface_atspi_text_bounded_ranges_get(const Eo *obj, Eina_Bool screen_coords, Eina_Rectangle rect, Elm_Atspi_Text_Clip_Type xclip, Elm_Atspi_Text_Clip_Type yclip);
#endif

#ifdef ELM_INTERFACE_ATSPI_TEXT_PROTECTED
EOAPI Eina_Bool elm_interface_atspi_text_range_extents_get(const Eo *obj, Eina_Bool screen_coords, int start_offset, int end_offset, Eina_Rectangle *rect);
#endif

#ifdef ELM_INTERFACE_ATSPI_TEXT_PROTECTED
EOAPI int elm_interface_atspi_text_selections_count_get(const Eo *obj);
#endif

#ifdef ELM_INTERFACE_ATSPI_TEXT_PROTECTED
EOAPI void elm_interface_atspi_text_selection_get(const Eo *obj, int selection_number, int *start_offset, int *end_offset);
#endif

#ifdef ELM_INTERFACE_ATSPI_TEXT_PROTECTED
EOAPI Eina_Bool elm_interface_atspi_text_selection_set(Eo *obj, int selection_number, int start_offset, int end_offset);
#endif

#ifdef ELM_INTERFACE_ATSPI_TEXT_PROTECTED
EOAPI Eina_Bool elm_interface_atspi_text_selection_add(Eo *obj, int start_offset, int end_offset);
#endif

#ifdef ELM_INTERFACE_ATSPI_TEXT_PROTECTED
EOAPI Eina_Bool elm_interface_atspi_text_selection_remove(Eo *obj, int selection_number);
#endif

EOAPI extern const Eo_Event_Description _ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_BOUNDS_CHANGED;
EOAPI extern const Eo_Event_Description _ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_ATTRIBUTES_CHANGED;
EOAPI extern const Eo_Event_Description _ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_CARET_MOVED;
EOAPI extern const Eo_Event_Description _ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_INSERTED;
EOAPI extern const Eo_Event_Description _ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_REMOVED;
EOAPI extern const Eo_Event_Description _ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_SELECTION_CHANGED;

/**
 * No description
 */
#define ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_BOUNDS_CHANGED (&(_ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_BOUNDS_CHANGED))

/**
 * No description
 */
#define ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_ATTRIBUTES_CHANGED (&(_ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_ATTRIBUTES_CHANGED))

/**
 * No description
 */
#define ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_CARET_MOVED (&(_ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_CARET_MOVED))

/**
 * No description
 */
#define ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_INSERTED (&(_ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_INSERTED))

/**
 * No description
 */
#define ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_REMOVED (&(_ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_REMOVED))

/**
 * No description
 */
#define ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_SELECTION_CHANGED (&(_ELM_INTERFACE_ATSPI_TEXT_EVENT_ACCESS_TEXT_SELECTION_CHANGED))

#endif
