/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AbstractLeafElement;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.Topic;
import java.beans.PropertyVetoException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class Unit
extends AbstractLeafElement
implements Extendable {
    protected String name = "";
    protected String docName = "";
    protected Unit extending = null;
    protected Set extendedBy = new HashSet(2);
    protected boolean _abstract = false;
    protected boolean _final = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public String toString() {
        return "UNIT " + this.getScopedName(null);
    }

    public String getName() {
        return this.name;
    }

    public String getDocName() {
        return this.docName;
    }

    public String getScopedName(Container scope) {
        Topic scopeTopic;
        Model scopeModel;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.interlis.ili2c.metamodel.Model");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Model enclosingModel = (Model)this.getContainer(clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("ch.interlis.ili2c.metamodel.Topic");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Topic enclosingTopic = (Topic)this.getContainer(clazz2);
        if (enclosingModel == null && enclosingTopic == null) {
            return this.getName();
        }
        if (scope != null) {
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("ch.interlis.ili2c.metamodel.Model");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            scopeModel = (Model)scope.getContainerOrSame(clazz3);
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("ch.interlis.ili2c.metamodel.Topic");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            scopeTopic = (Topic)scope.getContainerOrSame(clazz4);
        } else {
            scopeModel = null;
            scopeTopic = null;
        }
        if (enclosingModel == scopeModel && enclosingTopic == null) {
            return this.getName();
        }
        if (enclosingTopic == scopeTopic && enclosingTopic != null) {
            return this.getName();
        }
        if (enclosingTopic == null) {
            return String.valueOf(enclosingModel.getName()) + "." + this.getName();
        }
        return String.valueOf(enclosingTopic.getScopedName(scope)) + "." + this.getName();
    }

    public void setName(String name) throws PropertyVetoException {
        String oldValue = this.name;
        String newValue = name;
        boolean noDocName = "".equals(this.docName);
        Unit.checkNameSanity(name, false);
        this.fireVetoableChange("name", oldValue, newValue);
        if (noDocName) {
            this.fireVetoableChange("docName", "", newValue);
        }
        this.name = newValue;
        if (noDocName) {
            this.docName = newValue;
        }
        this.firePropertyChange("name", oldValue, newValue);
        if (noDocName) {
            this.firePropertyChange("docName", "", newValue);
        }
    }

    public void setDocName(String docName) throws PropertyVetoException {
        String oldValue = this.docName;
        String newValue = docName;
        if (docName == null) {
            throw new IllegalArgumentException();
        }
        this.fireVetoableChange("docName", oldValue, newValue);
        this.docName = newValue;
        this.firePropertyChange("docName", oldValue, newValue);
    }

    public Element getExtending() {
        return this.extending;
    }

    public Element getRealExtending() {
        Element ext = this.getExtending();
        return ext != null ? ext.getReal() : null;
    }

    public Set getExtensions() {
        HashSet result = new HashSet();
        this.getExtensions_recursiveHelper(result);
        return result;
    }

    private final void getExtensions_recursiveHelper(Set s) {
        s.add(this);
        Iterator iter = this.extendedBy.iterator();
        while (iter.hasNext()) {
            ((Unit)iter.next()).getExtensions_recursiveHelper(s);
        }
    }

    public boolean isExtending(Element extendee) {
        Unit parent = this;
        while (parent != null) {
            if (parent == extendee) {
                return true;
            }
            parent = parent.extending;
        }
        return false;
    }

    public boolean isExtendingIndirectly(Unit u) {
        Unit parent = this;
        while (parent != null) {
            if (parent == u) {
                return true;
            }
            parent = parent.extending;
        }
        return false;
    }

    public boolean isDependentOn(Element e) {
        if (e instanceof Unit) {
            boolean i = this.isExtendingIndirectly((Unit)e);
            return i;
        }
        return false;
    }

    protected Unit findCommonBase(Unit u) {
        Unit p = u;
        while (p != null) {
            if (p.isExtendingIndirectly(this)) {
                return p;
            }
            if (this.isExtendingIndirectly(p)) {
                return this;
            }
            p = p.extending;
        }
        return null;
    }

    public void setExtending(Element ext1) throws PropertyVetoException {
        Unit oldValue = this.extending;
        Unit ext = (Unit)ext1;
        Unit newValue = ext;
        if (oldValue == newValue) {
            return;
        }
        this.checkExtending(ext);
        this.fireVetoableChange("extending", oldValue, newValue);
        if (this.extending != null) {
            this.extending.extendedBy.remove(this);
        }
        this.extending = ext;
        if (ext != null) {
            ext.extendedBy.add(this);
        }
        this.firePropertyChange("extending", oldValue, newValue);
    }

    protected void checkExtending(Unit ext) {
        if (ext != null && ext._final) {
            throw new IllegalArgumentException(Unit.formatMessage("err_cantExtendFinal", ext.toString()));
        }
        if (ext != null && !ext.isAbstract()) {
            throw new IllegalArgumentException(Unit.formatMessage("err_extendingConcreteUnit", ext.getScopedName(null)));
        }
        if (ext != null && ext.isExtendingIndirectly(this)) {
            throw new IllegalArgumentException("The unit \"" + this.getName() + "\" can not extend \"" + ext.getName() + "\", because \"" + this.getName() + "\" is already extending \"" + ext.getName() + "\"; cyclic extension graphs are not allowed.");
        }
    }

    public boolean isAbstract() {
        return this._abstract;
    }

    public void setAbstract(boolean abs) throws PropertyVetoException {
        if (abs == this._abstract) {
            return;
        }
        this.fireVetoableChange("abstract", !abs, abs);
        this._abstract = abs;
        this.firePropertyChange("abstract", !abs, abs);
    }

    public boolean isFinal() {
        return this._final;
    }

    public void setFinal(boolean fin) throws PropertyVetoException {
        boolean oldValue = this._final;
        boolean newValue = fin;
        if (oldValue == newValue) {
            return;
        }
        if (newValue && this.isAbstract()) {
            throw new IllegalArgumentException(rsrc.getString("err_abstractFinal"));
        }
        if (newValue && !this.extendedBy.isEmpty()) {
            throw new IllegalArgumentException(Unit.formatMessage("err_cantMakeExtendedFinal", this.toString(), this.extendedBy.iterator().next().toString()));
        }
        this.fireVetoableChange("final", oldValue, newValue);
        this._final = newValue;
        this.firePropertyChange("final", oldValue, newValue);
    }
}

