/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.collectors.InstanceCollector;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0004\u001a\u00020\u0005\u001a,\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\f0\n\"\b\b\u0000\u0010\f*\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a&\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u00110\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00120\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0001*\u00020\u0005\u001a\u0015\u0010\u001a\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u001b0\u0007*\u00020\u0003\u001a\u0015\u0010\u001c\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u001b0\u0007*\u00020\u0003\u00a8\u0006\u001d"}, d2={"collectAccessors", "", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "collectDefinedNames", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "collectFunctionReferencesInside", "", "collectInstances", "T", "klass", "Ljava/lang/Class;", "collectNamedFunctions", "collectNamedFunctionsAndMetadata", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "collectNamedFunctionsOrMetadata", "collectReferencedNames", "collectReferencedTemporaryNames", "collectUsedNames", "collectBreakContinueTargets", "Lorg/jetbrains/kotlin/js/backend/ast/JsContinue;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "collectFreeVariables", "Lorg/jetbrains/annotations/NotNull;", "collectLocalVariables", "kotlin-compiler"})
public final class CollectUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<JsName> collectFunctionReferencesInside(@NotNull JsNode scope) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Iterable iterable = $receiver$iv = (Iterable)CollectUtilsKt.collectReferencedNames(scope);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            JsName it = (JsName)element$iv$iv;
            if (!(MetadataProperties.getStaticRef(it) instanceof JsFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final Set<JsName> collectReferencedTemporaryNames(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Set references = new LinkedHashSet();
        new RecursiveJsVisitor(references){
            final /* synthetic */ Set $references;

            protected void visitElement(@NotNull JsNode node) {
                Intrinsics.checkParameterIsNotNull(node, "node");
                if (node instanceof HasName) {
                    JsName jsName = ((HasName)((Object)node)).getName();
                    if (jsName != null) {
                        JsName jsName2;
                        JsName it = jsName2 = jsName;
                        Collection collection = this.$references;
                        collection.add(it);
                    }
                }
                super.visitElement(node);
            }
            {
                this.$references = $captured_local_variable$0;
            }
        }.accept(scope);
        return references;
    }

    private static final Set<JsName> collectReferencedNames(JsNode scope) {
        Set references = new LinkedHashSet();
        new RecursiveJsVisitor(references){
            final /* synthetic */ Set $references;

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression initializer2 = x.getInitExpression();
                if (initializer2 != null) {
                    this.accept((JsNode)initializer2);
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkParameterIsNotNull(nameRef, "nameRef");
                super.visitNameRef(nameRef);
                JsName name2 = nameRef.getName();
                if (name2 != null) {
                    Collection collection = this.$references;
                    collection.add(name2);
                }
            }
            {
                this.$references = $captured_local_variable$0;
            }
        }.accept(scope);
        return references;
    }

    @NotNull
    public static final Set<JsName> collectUsedNames(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Set references = new LinkedHashSet();
        new RecursiveJsVisitor(references){
            final /* synthetic */ Set $references;

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression initializer2 = x.getInitExpression();
                if (initializer2 != null) {
                    this.accept((JsNode)initializer2);
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkParameterIsNotNull(nameRef, "nameRef");
                super.visitNameRef(nameRef);
                JsName name2 = nameRef.getName();
                if (name2 != null && nameRef.getQualifier() == null) {
                    this.$references.add(name2);
                }
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Collection collection = this.$references;
                Iterable iterable = CollectUtilsKt.collectFreeVariables(x);
                CollectionsKt.addAll(collection, iterable);
            }
            {
                this.$references = $captured_local_variable$0;
            }
        }.accept(scope);
        return references;
    }

    @NotNull
    public static final Set<JsName> collectDefinedNames(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Set names2 = new LinkedHashSet();
        new RecursiveJsVisitor(names2){
            final /* synthetic */ Set $names;

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression initializer2 = x.getInitExpression();
                if (initializer2 != null) {
                    this.accept((JsNode)initializer2);
                }
                Collection collection = this.$names;
                JsName jsName = x.getName();
                collection.add(jsName);
            }

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                JsName name2;
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression expression = x.getExpression();
                if (expression instanceof JsFunction && (name2 = ((JsFunction)expression).getName()) != null) {
                    Collection collection = this.$names;
                    collection.add(name2);
                }
                super.visitExpressionStatement(x);
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }
            {
                this.$names = $captured_local_variable$0;
            }
        }.accept(scope);
        return names2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<JsName> collectFreeVariables(@NotNull JsFunction $receiver) {
        Collection<JsName> collection;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        JsBlock jsBlock = $receiver.getBody();
        Intrinsics.checkExpressionValueIsNotNull(jsBlock, "body");
        Set<JsName> set = CollectUtilsKt.collectUsedNames(jsBlock);
        JsBlock jsBlock2 = $receiver.getBody();
        Intrinsics.checkExpressionValueIsNotNull(jsBlock2, "body");
        Iterable $receiver$iv = $receiver.getParameters();
        Set<JsName> set2 = SetsKt.minus(set, (Iterable)CollectUtilsKt.collectDefinedNames(jsBlock2));
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv;
            JsName jsName = it.getName();
            collection.add(jsName);
        }
        collection = (List)destination$iv$iv;
        return SetsKt.minus(set2, (Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<JsName> collectLocalVariables(@NotNull JsFunction $receiver) {
        Collection<JsName> collection;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        JsBlock jsBlock = $receiver.getBody();
        Intrinsics.checkExpressionValueIsNotNull(jsBlock, "body");
        Iterable $receiver$iv = $receiver.getParameters();
        Set<JsName> set = CollectUtilsKt.collectDefinedNames(jsBlock);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv;
            JsName jsName = it.getName();
            collection.add(jsName);
        }
        collection = (List)destination$iv$iv;
        return SetsKt.plus(set, (Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<JsName, JsFunction> collectNamedFunctions(@NotNull JsNode scope) {
        void var3_3;
        void $receiver$iv$iv;
        Map<JsName, Pair<JsFunction, JsExpression>> $receiver$iv;
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Map<JsName, Pair<JsFunction, JsExpression>> map2 = $receiver$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(scope);
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map4 = map3;
            JsFunction jsFunction = (JsFunction)((Pair)it.getValue()).getFirst();
            map4.put(k2, jsFunction);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<JsName, JsExpression> collectNamedFunctionsOrMetadata(@NotNull JsNode scope) {
        void var3_3;
        void $receiver$iv$iv;
        Map<JsName, Pair<JsFunction, JsExpression>> $receiver$iv;
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Map<JsName, Pair<JsFunction, JsExpression>> map2 = $receiver$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(scope);
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map4 = map3;
            JsExpression jsExpression = (JsExpression)((Pair)it.getValue()).getSecond();
            map4.put(k2, jsExpression);
        }
        return var3_3;
    }

    @NotNull
    public static final Map<JsName, Pair<JsFunction, JsExpression>> collectNamedFunctionsAndMetadata(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Map namedFunctions = new LinkedHashMap();
        scope.accept(new RecursiveJsVisitor(namedFunctions){
            final /* synthetic */ Map $namedFunctions;

            /*
             * WARNING - void declaration
             */
            public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Pair<JsExpression, JsExpression> assignment = JsAstUtils.decomposeAssignment(x);
                if (assignment != null) {
                    void left;
                    Pair<JsExpression, JsExpression> pair = assignment;
                    JsExpression jsExpression = pair.component1();
                    JsExpression jsExpression2 = pair.component2();
                    pair = null;
                    if (left instanceof JsNameRef) {
                        void right;
                        JsName name2 = ((JsNameRef)left).getName();
                        void v0 = right;
                        Intrinsics.checkExpressionValueIsNotNull(v0, "right");
                        JsFunction function2 = this.extractFunction((JsExpression)v0);
                        if (function2 != null && name2 != null) {
                            Map map2 = this.$namedFunctions;
                            Pair<JsFunction, void> pair2 = new Pair<JsFunction, void>(function2, right);
                            map2.put(name2, pair2);
                        }
                    }
                }
                super.visitBinaryExpression(x);
            }

            public void visit(@NotNull JsVars.JsVar x) {
                JsFunction function2;
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression initializer2 = x.getInitExpression();
                JsName name2 = x.getName();
                if (initializer2 != null && name2 != null && (function2 = this.extractFunction(initializer2)) != null) {
                    Map map2 = this.$namedFunctions;
                    Pair<JsFunction, JsExpression> pair = new Pair<JsFunction, JsExpression>(function2, initializer2);
                    map2.put(name2, pair);
                }
                super.visit(x);
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsName name2 = x.getName();
                if (name2 != null) {
                    Map map2 = this.$namedFunctions;
                    Pair<JsFunction, JsFunction> pair = new Pair<JsFunction, JsFunction>(x, x);
                    map2.put(name2, pair);
                }
                super.visitFunction(x);
            }

            private final JsFunction extractFunction(JsExpression expression) {
                JsFunction jsFunction;
                JsExpression jsExpression = expression;
                if (jsExpression instanceof JsFunction) {
                    jsFunction = (JsFunction)expression;
                } else {
                    InlineMetadata inlineMetadata = InlineMetadata.Companion.decompose(expression);
                    jsFunction = inlineMetadata != null ? inlineMetadata.getFunction() : null;
                }
                return jsFunction;
            }
            {
                this.$namedFunctions = $captured_local_variable$0;
            }
        });
        return namedFunctions;
    }

    @NotNull
    public static final Map<String, JsFunction> collectAccessors(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        HashMap accessors = new HashMap();
        scope.accept(new RecursiveJsVisitor(accessors){
            final /* synthetic */ HashMap $accessors;

            public void visitInvocation(@NotNull JsInvocation invocation) {
                Intrinsics.checkParameterIsNotNull(invocation, "invocation");
                InlineMetadata inlineMetadata = InlineMetadata.Companion.decompose(invocation);
                if (inlineMetadata != null) {
                    InlineMetadata inlineMetadata2;
                    InlineMetadata it = inlineMetadata2 = inlineMetadata;
                    Map map2 = this.$accessors;
                    String string = it.getTag().getValue();
                    Intrinsics.checkExpressionValueIsNotNull(string, "it.tag.value");
                    String string2 = string;
                    JsFunction jsFunction = it.getFunction();
                    map2.put(string2, jsFunction);
                }
                super.visitInvocation(invocation);
            }
            {
                this.$accessors = $captured_local_variable$0;
            }
        });
        return accessors;
    }

    @NotNull
    public static final <T extends JsNode> List<T> collectInstances(@NotNull Class<T> klass2, @NotNull JsNode scope) {
        InstanceCollector<JsNode> instanceCollector;
        Intrinsics.checkParameterIsNotNull(klass2, "klass");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        InstanceCollector<JsNode> $receiver = instanceCollector = new InstanceCollector<JsNode>(klass2, false);
        $receiver.accept(scope);
        return $receiver.getCollected();
    }

    @NotNull
    public static final Map<JsContinue, JsStatement> collectBreakContinueTargets(@NotNull JsNode $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Map targets = new LinkedHashMap();
        $receiver.accept(new RecursiveJsVisitor(targets){
            @Nullable
            private JsStatement defaultBreakTarget;
            @NotNull
            private Map<JsName, JsStatement> breakTargets;
            @Nullable
            private JsStatement defaultContinueTarget;
            @NotNull
            private Map<JsName, JsStatement> continueTargets;
            final /* synthetic */ Map $targets;

            @Nullable
            public final JsStatement getDefaultBreakTarget() {
                return this.defaultBreakTarget;
            }

            public final void setDefaultBreakTarget(@Nullable JsStatement jsStatement) {
                this.defaultBreakTarget = jsStatement;
            }

            @NotNull
            public final Map<JsName, JsStatement> getBreakTargets() {
                return this.breakTargets;
            }

            public final void setBreakTargets(@NotNull Map<JsName, JsStatement> map2) {
                Intrinsics.checkParameterIsNotNull(map2, "<set-?>");
                this.breakTargets = map2;
            }

            @Nullable
            public final JsStatement getDefaultContinueTarget() {
                return this.defaultContinueTarget;
            }

            public final void setDefaultContinueTarget(@Nullable JsStatement jsStatement) {
                this.defaultContinueTarget = jsStatement;
            }

            @NotNull
            public final Map<JsName, JsStatement> getContinueTargets() {
                return this.continueTargets;
            }

            public final void setContinueTargets(@NotNull Map<JsName, JsStatement> map2) {
                Intrinsics.checkParameterIsNotNull(map2, "<set-?>");
                this.continueTargets = map2;
            }

            public void visitLabel(@NotNull JsLabel x) {
                JsStatement inner;
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsStatement jsStatement = inner = x.getStatement();
                if (jsStatement instanceof JsDoWhile) {
                    JsStatement jsStatement2 = ((JsDoWhile)inner).getBody();
                    Intrinsics.checkExpressionValueIsNotNull(jsStatement2, "inner.body");
                    this.handleLoop(inner, jsStatement2, x.getName());
                } else if (jsStatement instanceof JsWhile) {
                    JsStatement jsStatement3 = ((JsWhile)inner).getBody();
                    Intrinsics.checkExpressionValueIsNotNull(jsStatement3, "inner.body");
                    this.handleLoop(inner, jsStatement3, x.getName());
                } else if (jsStatement instanceof JsFor) {
                    JsStatement jsStatement4 = ((JsFor)inner).getBody();
                    Intrinsics.checkExpressionValueIsNotNull(jsStatement4, "inner.body");
                    this.handleLoop(inner, jsStatement4, x.getName());
                } else if (jsStatement instanceof JsSwitch) {
                    this.handleSwitch((JsSwitch)inner, x.getName());
                } else {
                    JsName jsName = x.getName();
                    JsStatement jsStatement5 = x.getStatement();
                    Intrinsics.checkExpressionValueIsNotNull(jsStatement5, "x.statement");
                    this.withBreakAndContinue(jsName, jsStatement5, null, new Function0<Unit>(this, inner){
                        final /* synthetic */ collectBreakContinueTargets.1 this$0;
                        final /* synthetic */ JsStatement $inner;

                        public final void invoke() {
                            this.this$0.accept((JsNode)this.$inner);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$inner = jsStatement;
                            super(0);
                        }
                    });
                }
            }

            public void visitWhile(@NotNull JsWhile x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsStatement jsStatement = x;
                JsStatement jsStatement2 = x.getBody();
                Intrinsics.checkExpressionValueIsNotNull(jsStatement2, "x.body");
                this.handleLoop(jsStatement, jsStatement2, null);
            }

            public void visitDoWhile(@NotNull JsDoWhile x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsStatement jsStatement = x;
                JsStatement jsStatement2 = x.getBody();
                Intrinsics.checkExpressionValueIsNotNull(jsStatement2, "x.body");
                this.handleLoop(jsStatement, jsStatement2, null);
            }

            public void visitFor(@NotNull JsFor x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsStatement jsStatement = x;
                JsStatement jsStatement2 = x.getBody();
                Intrinsics.checkExpressionValueIsNotNull(jsStatement2, "x.body");
                this.handleLoop(jsStatement, jsStatement2, null);
            }

            public void visit(@NotNull JsSwitch x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.handleSwitch(x, null);
            }

            private final void handleSwitch(JsSwitch statement, JsName label) {
                collectBreakContinueTargets.1.withBreakAndContinue$default(this, label, statement, null, new Function0<Unit>(this, statement){
                    final /* synthetic */ collectBreakContinueTargets.1 this$0;
                    final /* synthetic */ JsSwitch $statement;

                    public final void invoke() {
                        Iterable $receiver$iv = this.$statement.getCases();
                        for (T element$iv : $receiver$iv) {
                            JsSwitchMember it = (JsSwitchMember)element$iv;
                            this.this$0.accept((JsNode)it);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$statement = jsSwitch;
                        super(0);
                    }
                }, 4, null);
            }

            private final void handleLoop(JsStatement loop, JsStatement body, JsName label) {
                this.withBreakAndContinue(label, loop, loop, new Function0<Unit>(this, body){
                    final /* synthetic */ collectBreakContinueTargets.1 this$0;
                    final /* synthetic */ JsStatement $body;

                    public final void invoke() {
                        this.$body.accept(this.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$body = jsStatement;
                        super(0);
                    }
                });
            }

            public void visitBreak(@NotNull JsBreak x) {
                JsStatement jsStatement;
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsNameRef jsNameRef = x.getLabel();
                JsName targetLabel = jsNameRef != null ? jsNameRef.getName() : null;
                Map map2 = this.$targets;
                if (targetLabel == null) {
                    jsStatement = this.defaultBreakTarget;
                    if (jsStatement == null) {
                        Intrinsics.throwNpe();
                    }
                } else {
                    JsStatement jsStatement2 = this.breakTargets.get(targetLabel);
                    if (jsStatement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    jsStatement = jsStatement2;
                }
                JsStatement jsStatement3 = jsStatement;
                map2.put(x, jsStatement3);
            }

            public void visitContinue(@NotNull JsContinue x) {
                JsStatement jsStatement;
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsNameRef jsNameRef = x.getLabel();
                JsName targetLabel = jsNameRef != null ? jsNameRef.getName() : null;
                Map map2 = this.$targets;
                if (targetLabel == null) {
                    jsStatement = this.defaultContinueTarget;
                    if (jsStatement == null) {
                        Intrinsics.throwNpe();
                    }
                } else {
                    JsStatement jsStatement2 = this.continueTargets.get(targetLabel);
                    if (jsStatement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    jsStatement = jsStatement2;
                }
                JsStatement jsStatement3 = jsStatement;
                map2.put(x, jsStatement3);
            }

            /*
             * WARNING - void declaration
             */
            private final void withBreakAndContinue(JsName label, JsStatement breakTargetStatement, JsStatement continueTargetStatement, Function0<Unit> action) {
                JsStatement jsStatement;
                JsStatement oldDefaultBreakTarget = this.defaultBreakTarget;
                JsStatement oldDefaultContinueTarget = this.defaultContinueTarget;
                Map<JsName, JsStatement> map2 = label != null ? new Pair<JsStatement, JsStatement>(this.breakTargets.get(label), this.continueTargets.get(label)) : new Pair<Object, Object>(null, null);
                JsStatement jsStatement2 = (JsStatement)((Pair)((Object)map2)).component1();
                JsStatement jsStatement3 = ((Pair)((Object)map2)).component2();
                map2 = null;
                this.defaultBreakTarget = breakTargetStatement;
                if (label != null) {
                    map2 = this.breakTargets;
                    jsStatement = breakTargetStatement;
                    map2.put(label, jsStatement);
                    map2 = this.continueTargets;
                    jsStatement = continueTargetStatement;
                    map2.put(label, jsStatement);
                }
                if (continueTargetStatement != null) {
                    this.defaultContinueTarget = continueTargetStatement;
                }
                action.invoke();
                this.defaultBreakTarget = oldDefaultBreakTarget;
                this.defaultContinueTarget = oldDefaultContinueTarget;
                if (label != null) {
                    void oldContinueTarget;
                    void oldBreakTarget;
                    map2 = this.breakTargets;
                    jsStatement = oldBreakTarget;
                    map2.put(label, jsStatement);
                    map2 = this.continueTargets;
                    jsStatement = oldContinueTarget;
                    map2.put(label, jsStatement);
                }
            }

            static /* bridge */ /* synthetic */ void withBreakAndContinue$default(collectBreakContinueTargets.1 var0, JsName jsName, JsStatement jsStatement, JsStatement jsStatement2, Function0 function0, int n, Object object) {
                if ((n & 4) != 0) {
                    jsStatement2 = null;
                }
                var0.withBreakAndContinue(jsName, jsStatement, jsStatement2, function0);
            }
            {
                Map map2;
                this.$targets = $captured_local_variable$0;
                collectBreakContinueTargets.1 var2_2 = this;
                var2_2.breakTargets = map2 = (Map)new LinkedHashMap<K, V>();
                var2_2 = this;
                var2_2.continueTargets = map2 = (Map)new LinkedHashMap<K, V>();
            }
        });
        return targets;
    }
}

