/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal;

import org.apache.commons.lang.StringUtils;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.tasks.Delete;

public abstract class IdePlugin
implements Plugin<Project> {
    private Task lifecycleTask;
    private Task cleanTask;
    protected Project project;

    public void apply(Project target) {
        this.project = target;
        String lifecycleTaskName = this.getLifecycleTaskName();
        this.lifecycleTask = target.task(lifecycleTaskName);
        this.lifecycleTask.setGroup("IDE");
        this.cleanTask = target.task(this.cleanName(lifecycleTaskName));
        this.cleanTask.setGroup("IDE");
        this.onApply(target);
    }

    public Task getLifecycleTask() {
        return this.lifecycleTask;
    }

    public Task getCleanTask() {
        return this.cleanTask;
    }

    public Task getCleanTask(Task worker) {
        return this.project.getTasks().getByName(this.cleanName(worker.getName()));
    }

    protected String cleanName(String taskName) {
        return String.format("clean%s", StringUtils.capitalize((String)taskName));
    }

    public void addWorker(Task worker) {
        this.addWorker(worker, true);
    }

    public void addWorker(Task worker, boolean includeInClean) {
        this.lifecycleTask.dependsOn(new Object[]{worker});
        Delete cleanWorker = (Delete)this.project.getTasks().create(this.cleanName(worker.getName()), Delete.class);
        cleanWorker.delete(new Object[]{worker.getOutputs().getFiles()});
        if (includeInClean) {
            this.cleanTask.dependsOn(new Object[]{cleanWorker});
        }
    }

    protected void onApply(Project target) {
    }

    protected abstract String getLifecycleTaskName();

    protected void postProcess(String key, final Action<? super Gradle> action) {
        String extraPropertyName;
        Project rootProject = this.project.getRootProject();
        ExtraPropertiesExtension rootExtraProperties = (ExtraPropertiesExtension)rootProject.getExtensions().getByType(ExtraPropertiesExtension.class);
        if (!rootExtraProperties.has(extraPropertyName = "org.gradle." + key + ".postprocess.applied")) {
            this.project.getGradle().addBuildListener((BuildListener)new BuildAdapter(){

                public void projectsEvaluated(Gradle gradle) {
                    action.execute((Object)gradle);
                }
            });
            rootExtraProperties.set(extraPropertyName, (Object)true);
        }
    }
}

