/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.jaas.callback;

import java.io.IOException;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.plus.jaas.callback.AbstractCallbackHandler;
import org.mortbay.jetty.plus.jaas.callback.ObjectCallback;
import org.mortbay.jetty.plus.jaas.callback.RequestParameterCallback;
import org.mortbay.jetty.security.Password;

public class DefaultCallbackHandler
extends AbstractCallbackHandler {
    private Request request;

    public void setRequest(Request request) {
        this.request = request;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                ((NameCallback)callbacks[i]).setName(this.getUserName());
                continue;
            }
            if (callbacks[i] instanceof ObjectCallback) {
                ((ObjectCallback)callbacks[i]).setObject(this.getCredential());
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                if (this.getCredential() instanceof Password) {
                    ((PasswordCallback)callbacks[i]).setPassword(((Password)this.getCredential()).toString().toCharArray());
                    continue;
                }
                if (this.getCredential() instanceof String) {
                    ((PasswordCallback)callbacks[i]).setPassword(((String)this.getCredential()).toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "User supplied credentials cannot be converted to char[] for PasswordCallback: try using an ObjectCallback instead");
            }
            if (callbacks[i] instanceof RequestParameterCallback) {
                RequestParameterCallback callback = (RequestParameterCallback)callbacks[i];
                callback.setParameterValues(Arrays.asList(this.request.getParameterValues(callback.getParameterName())));
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }
}

