/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.Utils;

public class ImageWarp {
    public static BufferedImage warp(BufferedImage bufferedImage, Dimension dimension, PointTransform pointTransform, Interpolation interpolation) {
        BufferedImage bufferedImage2 = new BufferedImage(dimension.width, dimension.height, 2);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight());
        for (int i = 0; i < bufferedImage2.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage2.getWidth(); ++j) {
                int n;
                Point2D point2D = pointTransform.transform(new Point2D.Double(j, i));
                if (!double_.contains(point2D)) continue;
                switch (interpolation) {
                    case NEAREST_NEIGHBOR: {
                        n = ImageWarp.getColor((int)Math.round(point2D.getX()), (int)Math.round(point2D.getY()), bufferedImage);
                        break;
                    }
                    case BILINEAR: {
                        int n2 = (int)Math.floor(point2D.getX());
                        double d = point2D.getX() - (double)n2;
                        int n3 = (int)Math.floor(point2D.getY());
                        double d2 = point2D.getY() - (double)n3;
                        int n4 = ImageWarp.getColor(n2, n3, bufferedImage);
                        int n5 = ImageWarp.getColor(n2, n3 + 1, bufferedImage);
                        int n6 = ImageWarp.getColor(n2 + 1, n3, bufferedImage);
                        int n7 = ImageWarp.getColor(n2 + 1, n3 + 1, bufferedImage);
                        n = 0;
                        for (int k = 0; k <= 3; ++k) {
                            int n8 = 8 * k;
                            int n9 = (int)Math.round(((double)(n4 >> n8 & 0xFF) * (1.0 - d) + (double)(n6 >> n8 & 0xFF) * d) * (1.0 - d2) + ((double)(n5 >> n8 & 0xFF) * (1.0 - d) + (double)(n7 >> n8 & 0xFF) * d) * d2);
                            n |= n9 << n8;
                        }
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                bufferedImage2.setRGB(j, i, n);
            }
        }
        return bufferedImage2;
    }

    private static int getColor(int n, int n2, BufferedImage bufferedImage) {
        return bufferedImage.getRGB(Utils.clamp(n, 0, bufferedImage.getWidth() - 1), Utils.clamp(n2, 0, bufferedImage.getHeight() - 1));
    }

    public static enum Interpolation {
        NEAREST_NEIGHBOR,
        BILINEAR;

    }

    public static class GridTransform
    implements PointTransform {
        private final double stride;
        private final PointTransform trfm;
        private final Map<Integer, Map<Integer, Point2D>> cache;
        private final boolean consistencyTest;
        private final Set<Integer> deletedRows;

        public GridTransform(PointTransform pointTransform, double d) {
            this.trfm = pointTransform;
            this.stride = d;
            this.cache = new HashMap<Integer, Map<Integer, Point2D>>();
            this.consistencyTest = Main.isDebugEnabled();
            this.deletedRows = this.consistencyTest ? new HashSet<Integer>() : null;
        }

        @Override
        public Point2D transform(Point2D point2D) {
            int n = (int)Math.floor(point2D.getX() / this.stride);
            int n2 = (int)Math.floor(point2D.getY() / this.stride);
            double d = point2D.getX() / this.stride - (double)n;
            double d2 = point2D.getY() / this.stride - (double)n2;
            Point2D point2D2 = this.getValue(n, n2);
            Point2D point2D3 = this.getValue(n, n2 + 1);
            Point2D point2D4 = this.getValue(n + 1, n2);
            Point2D point2D5 = this.getValue(n + 1, n2 + 1);
            double d3 = (point2D2.getX() * (1.0 - d) + point2D4.getX() * d) * (1.0 - d2) + (point2D3.getX() * (1.0 - d) + point2D5.getX() * d) * d2;
            double d4 = (point2D2.getY() * (1.0 - d) + point2D4.getY() * d) * (1.0 - d2) + (point2D3.getY() * (1.0 - d) + point2D5.getY() * d) * d2;
            return new Point2D.Double(d3, d4);
        }

        private Point2D getValue(int n, int n2) {
            Map<Integer, Point2D> map = this.getRow(n2);
            Point2D point2D = map.get(n);
            if (point2D == null) {
                point2D = this.trfm.transform(new Point2D.Double((double)n * this.stride, (double)n2 * this.stride));
                map.put(n, point2D);
            }
            return point2D;
        }

        private Map<Integer, Point2D> getRow(int n) {
            this.cleanUp(n - 3);
            Map<Integer, Point2D> map = this.cache.get(n);
            if (map == null) {
                map = new HashMap<Integer, Point2D>();
                this.cache.put(n, map);
                if (this.consistencyTest) {
                    if (this.deletedRows.contains(n)) {
                        throw new AssertionError();
                    }
                    if (this.cache.size() > 3) {
                        throw new AssertionError();
                    }
                }
            }
            return map;
        }

        private void cleanUp(int n) {
            Map<Integer, Point2D> map = this.cache.remove(n);
            if (this.consistencyTest && map != null) {
                if (this.deletedRows.contains(n)) {
                    throw new AssertionError();
                }
                this.deletedRows.add(n);
            }
        }
    }

    public static interface PointTransform {
        public Point2D transform(Point2D var1);
    }
}

