/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.AbstractScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.rest.RestRequest;

public final class SettingsFilter
extends AbstractComponent {
    public static String SETTINGS_FILTER_PARAM = "settings_filter";
    private final Set<String> patterns;
    private final String patternString;

    public SettingsFilter(Settings settings, Collection<String> patterns) {
        super(settings);
        for (String pattern : patterns) {
            if (SettingsFilter.isValidPattern(pattern)) continue;
            throw new IllegalArgumentException("invalid pattern: " + pattern);
        }
        this.patterns = Collections.unmodifiableSet(new HashSet<String>(patterns));
        this.patternString = Strings.collectionToDelimitedString(patterns, ",");
    }

    public Set<String> getPatterns() {
        return this.patterns;
    }

    public static boolean isValidPattern(String pattern) {
        return AbstractScopedSettings.isValidKey(pattern) || Regex.isSimpleMatchPattern(pattern);
    }

    public void addFilterSettingParams(RestRequest request) {
        if (!this.patterns.isEmpty()) {
            request.params().put(SETTINGS_FILTER_PARAM, this.patternString);
        }
    }

    public static Settings filterSettings(ToXContent.Params params, Settings settings) {
        String patterns = params.param(SETTINGS_FILTER_PARAM);
        Settings filteredSettings = patterns != null && !patterns.isEmpty() ? SettingsFilter.filterSettings(Strings.commaDelimitedListToSet(patterns), settings) : settings;
        return filteredSettings;
    }

    public Settings filter(Settings settings) {
        return SettingsFilter.filterSettings(this.patterns, settings);
    }

    private static Settings filterSettings(Iterable<String> patterns, Settings settings) {
        Settings.Builder builder = Settings.builder().put(settings);
        ArrayList<String> simpleMatchPatternList = new ArrayList<String>();
        for (String pattern : patterns) {
            if (Regex.isSimpleMatchPattern(pattern)) {
                simpleMatchPatternList.add(pattern);
                continue;
            }
            builder.remove(pattern);
        }
        if (!simpleMatchPatternList.isEmpty()) {
            String[] simpleMatchPatterns = simpleMatchPatternList.toArray(new String[simpleMatchPatternList.size()]);
            Iterator<Map.Entry<String, String>> iterator = builder.internalMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> current = iterator.next();
                if (!Regex.simpleMatch(simpleMatchPatterns, current.getKey())) continue;
                iterator.remove();
            }
        }
        return builder.build();
    }
}

