/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectArtifactBuilder;
import org.gradle.composite.internal.CompositeProjectArtifactBuilder;
import org.gradle.composite.internal.IncludedBuildArtifactBuilder;
import org.gradle.initialization.BuildIdentity;
import org.gradle.initialization.IncludedBuildExecuter;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.service.ServiceRegistry;

public class CompositeBuildIdeProjectResolver {
    private final LocalComponentRegistry registry;
    private final ProjectArtifactBuilder artifactBuilder;

    public static CompositeBuildIdeProjectResolver from(ServiceRegistry services) {
        return new CompositeBuildIdeProjectResolver((LocalComponentRegistry)services.get(LocalComponentRegistry.class), (IncludedBuildExecuter)services.get(IncludedBuildExecuter.class), (BuildIdentity)services.get(BuildIdentity.class));
    }

    public CompositeBuildIdeProjectResolver(LocalComponentRegistry registry, IncludedBuildExecuter executer, BuildIdentity buildIdentity) {
        this.registry = registry;
        this.artifactBuilder = new CompositeProjectArtifactBuilder(new IncludedBuildArtifactBuilder(executer), buildIdentity);
    }

    public LocalComponentArtifactMetadata findArtifact(ProjectComponentIdentifier project, String type) {
        for (LocalComponentArtifactMetadata artifactMetaData : this.registry.getAdditionalArtifacts(project)) {
            if (!artifactMetaData.getName().getType().equals(type)) continue;
            return artifactMetaData;
        }
        return null;
    }

    public File buildArtifactFile(ProjectComponentIdentifier project, String type) {
        LocalComponentArtifactMetadata artifactMetaData = this.findArtifact(project, type);
        if (artifactMetaData == null) {
            return null;
        }
        this.artifactBuilder.build((ComponentArtifactMetadata)artifactMetaData);
        return artifactMetaData.getFile();
    }
}

