/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.EditCommaSeparatedListHelper;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtParameterList
extends KtElementImplStub<KotlinPlaceHolderStub<KtParameterList>> {
    public KtParameterList(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtParameterList", "<init>"));
        }
        super(node);
    }

    public KtParameterList(@NotNull KotlinPlaceHolderStub<KtParameterList> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/KtParameterList", "<init>"));
        }
        super(stub, KtStubElementTypes.VALUE_PARAMETER_LIST);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtParameterList", "accept"));
        }
        return visitor2.visitParameterList(this, data2);
    }

    @Override
    public PsiElement getParent() {
        KotlinPlaceHolderStub stub = (KotlinPlaceHolderStub)this.getStub();
        return stub != null ? stub.getParentStub().getPsi() : super.getParent();
    }

    @NotNull
    public List<KtParameter> getParameters() {
        List<KtParameter> list2 = this.getStubOrPsiChildrenAsList(KtStubElementTypes.VALUE_PARAMETER);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtParameterList", "getParameters"));
        }
        return list2;
    }

    @NotNull
    public KtParameter addParameter(@NotNull KtParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/psi/KtParameterList", "addParameter"));
        }
        KtParameter ktParameter = EditCommaSeparatedListHelper.INSTANCE.addItem(this, this.getParameters(), parameter);
        if (ktParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtParameterList", "addParameter"));
        }
        return ktParameter;
    }

    @NotNull
    public KtParameter addParameterBefore(@NotNull KtParameter parameter, @Nullable KtParameter anchor2) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/psi/KtParameterList", "addParameterBefore"));
        }
        KtParameter ktParameter = EditCommaSeparatedListHelper.INSTANCE.addItemBefore(this, this.getParameters(), parameter, anchor2);
        if (ktParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtParameterList", "addParameterBefore"));
        }
        return ktParameter;
    }

    public void removeParameter(@NotNull KtParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/psi/KtParameterList", "removeParameter"));
        }
        EditCommaSeparatedListHelper.INSTANCE.removeItem(parameter);
    }

    public void removeParameter(int index2) {
        this.removeParameter(this.getParameters().get(index2));
    }

    public KtFunction getOwnerFunction() {
        PsiElement parent2 = this.getParentByStub();
        if (!(parent2 instanceof KtFunction)) {
            return null;
        }
        return (KtFunction)parent2;
    }
}

