#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc-citeproc
version: 0.10.4.1
id: pandoc-citeproc-0.10.4.1-Jslad4EgWHGAXkefMGy9wV
key: pandoc-citeproc-0.10.4.1-Jslad4EgWHGAXkefMGy9wV
license: BSD3
maintainer: jgm@berkeley.edu
homepage: https://github.com/jgm/pandoc-citeproc
synopsis: Supports using pandoc with citeproc
description:
    The pandoc-citeproc library exports functions for
    using the citeproc system with pandoc.  It relies on
    citeproc-hs, a library for rendering
    bibliographic reference citations into a variety
    of styles using a macro language called Citation
    Style Language (CSL). More details on CSL can be
    found here: <http://citationstyles.org/>.
    .
    Currently this package includes a heavily revised
    copy of the citeproc-hs code. When citeproc-hs is
    updated to be compatible, this package will simply
    depend on citeproc-hs.
    .
    This package also contains an executable: pandoc-citeproc,
    which works as a pandoc filter, and
    also has a mode for converting bibliographic databases
    a YAML format suitable for inclusion in pandoc YAML
    metadata.
category: Text
author: John MacFarlane, Andrea Rossato
exposed: True
exposed-modules:
    Text.CSL.Pandoc Text.CSL Text.CSL.Reference Text.CSL.Style
    Text.CSL.Eval Text.CSL.Eval.Common Text.CSL.Eval.Date
    Text.CSL.Eval.Names Text.CSL.Eval.Output Text.CSL.Parser
    Text.CSL.Proc Text.CSL.Proc.Collapse Text.CSL.Proc.Disamb
    Text.CSL.Input.Bibutils Text.CSL.Input.Bibtex
    Text.CSL.Output.Pandoc Text.CSL.Output.Plain Text.CSL.Data
hidden-modules: Text.CSL.Util Prelude Paths_pandoc_citeproc
                Text.CSL.Compat.Pandoc
abi: f83df5cf3c91158e4feafd5c519af672
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/pandoc-citeproc-0.10.4.1
library-dirs: /usr/lib/ghc-8.0.1/site-local/pandoc-citeproc-0.10.4.1
data-dir: /usr/share/pandoc-citeproc
hs-libraries: HSpandoc-citeproc-0.10.4.1-Jslad4EgWHGAXkefMGy9wV
depends:
    aeson-1.1.2.0-6MVvUcgiXyL5LInpwFqRIH base-4.9.0.0
    bytestring-0.10.8.1 containers-0.5.7.1
    data-default-0.7.1.1-ZpKfkXGfJa8c8Q6OFbvrr directory-1.2.6.2
    filepath-1.4.1.0 hs-bibutils-5.5-Bujn9fwi74P5NCilKdJf4S
    mtl-2.2.1-6qsR1PHUy5lL47Hpoa4jCM
    old-locale-1.0.0.7-6glXNhHF891B41ZfuI8hU8
    pandoc-1.19.2.1-1F3h2dwz7EED2b7s8HncjW
    pandoc-types-1.17.0.5-8dxYXX3Q5qWEyBUUdZ0nWu
    parsec-3.1.11-LsiSww7OPVN4zZBDwUQHXr
    setenv-0.1.1.3-5zeeXxY3qb3AsPnIgczcsm
    split-0.2.3.2-1dCEe3bkR6E9uyZt6jsXK syb-0.6-C65vWCsht6A8uLstpQIXyj
    tagsoup-0.14.1-5UpYkVoOhOt4iyOyy0sWwj
    text-1.2.2.2-9rr3K4o0GAG9P33dGDnV9v
    text-icu-0.7.0.1-GtbFFRs9sVugfs7GP5C1y time-1.6.0.1
    unordered-containers-0.2.8.0-Njz6QHP7Gk5G9PhT6D28J
    vector-0.12.0.1-FyKxZ6HyOdr5RycjHR2p0f
    xml-conduit-1.4.0.4-CBbPBLXH55v2v1vIALQiH4
    yaml-0.8.23-7FKDxIZKIEy2mzkOBF5oCs
haddock-interfaces: /usr/share/doc/pandoc-citeproc/html/pandoc-citeproc.haddock
haddock-html: /usr/share/doc/pandoc-citeproc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
