/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;

public class Age {
    private final int _years;
    private final int _months;
    private final int _days;
    private final int _hours;
    private final int _minutes;
    private final int _seconds;

    @Nullable
    public static Age fromPanasonicString(@NotNull String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() != 19 || string.startsWith("9999:99:99")) {
            return null;
        }
        try {
            int n = Integer.parseInt(string.substring(0, 4));
            int n2 = Integer.parseInt(string.substring(5, 7));
            int n3 = Integer.parseInt(string.substring(8, 10));
            int n4 = Integer.parseInt(string.substring(11, 13));
            int n5 = Integer.parseInt(string.substring(14, 16));
            int n6 = Integer.parseInt(string.substring(17, 19));
            return new Age(n, n2, n3, n4, n5, n6);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Age(int n, int n2, int n3, int n4, int n5, int n6) {
        this._years = n;
        this._months = n2;
        this._days = n3;
        this._hours = n4;
        this._minutes = n5;
        this._seconds = n6;
    }

    public int getYears() {
        return this._years;
    }

    public int getMonths() {
        return this._months;
    }

    public int getDays() {
        return this._days;
    }

    public int getHours() {
        return this._hours;
    }

    public int getMinutes() {
        return this._minutes;
    }

    public int getSeconds() {
        return this._seconds;
    }

    public String toString() {
        return String.format("%04d:%02d:%02d %02d:%02d:%02d", this._years, this._months, this._days, this._hours, this._minutes, this._seconds);
    }

    public String toFriendlyString() {
        StringBuilder stringBuilder = new StringBuilder();
        Age.appendAgePart(stringBuilder, this._years, "year");
        Age.appendAgePart(stringBuilder, this._months, "month");
        Age.appendAgePart(stringBuilder, this._days, "day");
        Age.appendAgePart(stringBuilder, this._hours, "hour");
        Age.appendAgePart(stringBuilder, this._minutes, "minute");
        Age.appendAgePart(stringBuilder, this._seconds, "second");
        return stringBuilder.toString();
    }

    private static void appendAgePart(StringBuilder stringBuilder, int n, String string) {
        if (n == 0) {
            return;
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(n).append(' ').append(string);
        if (n != 1) {
            stringBuilder.append('s');
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Age age = (Age)object;
        if (this._days != age._days) {
            return false;
        }
        if (this._hours != age._hours) {
            return false;
        }
        if (this._minutes != age._minutes) {
            return false;
        }
        if (this._months != age._months) {
            return false;
        }
        if (this._seconds != age._seconds) {
            return false;
        }
        return this._years == age._years;
    }

    public int hashCode() {
        int n = this._years;
        n = 31 * n + this._months;
        n = 31 * n + this._days;
        n = 31 * n + this._hours;
        n = 31 * n + this._minutes;
        n = 31 * n + this._seconds;
        return n;
    }
}

