/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.RightAndLefthandTraffic;
import org.openstreetmap.josm.tools.Shortcut;

public final class CreateCircleAction
extends JosmAction {
    public CreateCircleAction() {
        super(I18n.tr("Create Circle", new Object[0]), "aligncircle", I18n.tr("Create a circle from three selected nodes.", new Object[0]), Shortcut.registerShortcut("tools:createcircle", I18n.tr("Tool: {0}", I18n.tr("Create Circle", new Object[0])), 79, 5005), true, "createcircle", true);
        this.putValue("help", HelpUtil.ht("/Action/CreateCircle"));
    }

    private static int[] distributeNodes(PolarNode[] polarNodeArray, int n) {
        int n2;
        int n3;
        int[] nArray = new int[polarNodeArray.length];
        double[] dArray = new double[polarNodeArray.length];
        double[] dArray2 = new double[polarNodeArray.length];
        for (n3 = 0; n3 < polarNodeArray.length; ++n3) {
            dArray[n3] = polarNodeArray[(n3 + 1) % polarNodeArray.length].a - polarNodeArray[n3].a;
            if (!(dArray[n3] < 0.0)) continue;
            int n4 = n3;
            dArray[n4] = dArray[n4] + Math.PI * 2;
        }
        n3 = 0;
        for (n2 = 0; n2 < polarNodeArray.length; ++n2) {
            double d = dArray[n2] / 2.0 / Math.PI * (double)n;
            nArray[n2] = (int)Math.floor(d);
            dArray2[n2] = d - (double)nArray[n2];
            n3 += nArray[n2];
        }
        while (n3 < n) {
            n2 = 0;
            for (int i = 1; i < polarNodeArray.length; ++i) {
                if (!(dArray2[i] > dArray2[n2])) continue;
                n2 = i;
            }
            int n5 = n2;
            nArray[n5] = nArray[n5] + 1;
            dArray2[n2] = 0.0;
            ++n3;
        }
        return nArray;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        double d;
        Object object2;
        double d2;
        if (!this.isEnabled()) {
            return;
        }
        int n = Main.pref.getInteger("createcircle.nodecount", 16);
        if (n < 1) {
            n = 1;
        } else if (n > 100) {
            n = 100;
        }
        Collection<OsmPrimitive> collection = this.getLayerManager().getEditDataSet().getSelected();
        List<Node> list = OsmPrimitive.getFilteredList(collection, Node.class);
        List<Way> list2 = OsmPrimitive.getFilteredList(collection, Way.class);
        Way way = null;
        if (list.isEmpty() && list2.size() == 1) {
            way = list2.get(0);
            for (Node object32 : way.getNodes()) {
                if (list.contains(object32)) continue;
                list.add(object32);
            }
        }
        if (list.size() < 2 || list.size() > 3) {
            new Notification(I18n.tr("Please select exactly two or three nodes or one way with exactly two or three nodes.", new Object[0])).setIcon(1).setDuration(Notification.TIME_LONG).show();
            return;
        }
        if (list.size() == 2) {
            Node node = list.get(0);
            d2 = node.getEastNorth().east();
            double d3 = node.getEastNorth().north();
            object2 = list.get(1);
            double d4 = object2.getEastNorth().east();
            d = object2.getEastNorth().north();
            double d5 = 0.5 * (d2 + d4);
            double d6 = 0.5 * (d3 + d);
            object = new EastNorth(d5, d6);
        } else {
            object = Geometry.getCenter(list);
            if (object == null) {
                CreateCircleAction.notifyNodesNotOnCircle();
                return;
            }
        }
        EastNorth eastNorth = list.get(0).getEastNorth();
        d2 = Math.sqrt(Math.pow(((EastNorth)object).east() - eastNorth.east(), 2.0) + Math.pow(((EastNorth)object).north() - eastNorth.north(), 2.0));
        PolarNode[] polarNodeArray = new PolarNode[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            polarNodeArray[i] = new PolarNode((EastNorth)object, list.get(i));
        }
        Arrays.sort(polarNodeArray, new PolarNodeComparator());
        int[] nArray = CreateCircleAction.distributeNodes(polarNodeArray, n >= list.size() ? n - list.size() : 0);
        object2 = new LinkedList();
        List<Node> list3 = new ArrayList<Node>();
        for (int i = 0; i < list.size(); ++i) {
            list3.add(polarNodeArray[i].node);
            d = polarNodeArray[(i + 1) % list.size()].a - polarNodeArray[i].a;
            if (d < 0.0) {
                d += Math.PI * 2;
            }
            for (int j = 0; j < nArray[i]; ++j) {
                double d7 = polarNodeArray[i].a + (double)(j + 1) * d / (double)(nArray[i] + 1);
                double d8 = ((EastNorth)object).east() + d2 * Math.cos(d7);
                double d9 = ((EastNorth)object).north() + d2 * Math.sin(d7);
                LatLon latLon = Main.getProjection().eastNorth2latlon(new EastNorth(d8, d9));
                if (latLon.isOutSideWorld()) {
                    CreateCircleAction.notifyNodesNotOnCircle();
                    return;
                }
                Node node = new Node(latLon);
                list3.add(node);
                object2.add(new AddCommand(node));
            }
        }
        list3.add((Node)list3.get(0));
        list3 = way != null && way.getNodesCount() >= 3 ? CreateCircleAction.orderNodesByWay(list3, way) : CreateCircleAction.orderNodesByTrafficHand(list3);
        if (way == null) {
            Way way2 = new Way();
            way2.setNodes(list3);
            object2.add(new AddCommand(way2));
        } else {
            Way way3 = new Way(way);
            way3.setNodes(list3);
            object2.add(new ChangeCommand(way, way3));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Create Circle", new Object[0]), (Collection<Command>)object2));
    }

    private static List<Node> orderNodesByTrafficHand(List<Node> list) {
        boolean bl = true;
        for (Node node : list) {
            if (RightAndLefthandTraffic.isRightHandTraffic(node.getCoor())) continue;
            bl = false;
            break;
        }
        if (bl == Geometry.isClockwise(list)) {
            Collections.reverse(list);
        }
        return list;
    }

    private static List<Node> orderNodesByWay(List<Node> list, Way way) {
        List<Node> list2 = way.getNodes();
        if (!way.isClosed()) {
            list2.add(list2.get(0));
        }
        if (Geometry.isClockwise(list2) != Geometry.isClockwise(list)) {
            Collections.reverse(list);
        }
        return list;
    }

    private static void notifyNodesNotOnCircle() {
        new Notification(I18n.tr("Those nodes are not in a circle. Aborting.", new Object[0])).setIcon(2).show();
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    private static class PolarNodeComparator
    implements Comparator<PolarNode>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private PolarNodeComparator() {
        }

        @Override
        public int compare(PolarNode polarNode, PolarNode polarNode2) {
            return Double.compare(polarNode.a, polarNode2.a);
        }
    }

    private static class PolarNode {
        private final double a;
        private final Node node;

        PolarNode(EastNorth eastNorth, Node node) {
            EastNorth eastNorth2 = node.getEastNorth();
            this.a = Math.atan2(eastNorth2.north() - eastNorth.north(), eastNorth2.east() - eastNorth.east());
            this.node = node;
        }
    }
}

