/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.gui.datatransfer.RelationMemberTransferable;
import org.openstreetmap.josm.gui.datatransfer.data.PrimitiveTransferData;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.tools.I18n;

public class MemberTransferHandler
extends TransferHandler {
    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        MemberTable memberTable = (MemberTable)jComponent;
        return new RelationMemberTransferable(memberTable.getMemberTableModel().getSelectedMembers());
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (transferSupport.isDrop()) {
            transferSupport.setShowDropLocation(true);
        }
        return transferSupport.isDataFlavorSupported(RelationMemberTransferable.RELATION_MEMBER_DATA) || transferSupport.isDataFlavorSupported(PrimitiveTransferData.DATA_FLAVOR);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        MemberTable memberTable = (MemberTable)transferSupport.getComponent();
        int n = MemberTransferHandler.computeInsertionRow(transferSupport, memberTable);
        return this.importDataAt(transferSupport, memberTable, n);
    }

    private static int computeInsertionRow(TransferHandler.TransferSupport transferSupport, MemberTable memberTable) {
        int n;
        TransferHandler.DropLocation dropLocation;
        int n2 = transferSupport.isDrop() ? ((dropLocation = transferSupport.getDropLocation()) instanceof JTable.DropLocation ? ((JTable.DropLocation)dropLocation).getRow() : 0) : ((n = memberTable.getSelectedRow()) < 0 ? memberTable.getRowCount() : n);
        return n2;
    }

    private boolean importDataAt(TransferHandler.TransferSupport transferSupport, MemberTable memberTable, int n) {
        try {
            if (transferSupport.isDataFlavorSupported(RelationMemberTransferable.RELATION_MEMBER_DATA)) {
                this.importRelationMemberData(transferSupport, memberTable, n);
                return true;
            }
            if (transferSupport.isDataFlavorSupported(PrimitiveTransferData.DATA_FLAVOR)) {
                this.importPrimitiveData(transferSupport, memberTable, n);
                return true;
            }
            return false;
        }
        catch (UnsupportedFlavorException | IOException exception) {
            Main.warn(exception);
            return false;
        }
    }

    protected void importRelationMemberData(TransferHandler.TransferSupport transferSupport, MemberTable memberTable, int n) throws UnsupportedFlavorException, IOException {
        RelationMemberTransferable.Data data = (RelationMemberTransferable.Data)transferSupport.getTransferable().getTransferData(RelationMemberTransferable.RELATION_MEMBER_DATA);
        this.importData(memberTable, n, data.getRelationMemberData(), new AbstractRelationMemberConverter<RelationMemberData>(){

            @Override
            protected RelationMember getMember(MemberTable memberTable, RelationMemberData relationMemberData, OsmPrimitive osmPrimitive) {
                return new RelationMember(relationMemberData.getRole(), osmPrimitive);
            }
        });
    }

    protected void importPrimitiveData(TransferHandler.TransferSupport transferSupport, MemberTable memberTable, int n) throws UnsupportedFlavorException, IOException {
        PrimitiveTransferData primitiveTransferData = (PrimitiveTransferData)transferSupport.getTransferable().getTransferData(PrimitiveTransferData.DATA_FLAVOR);
        this.importData(memberTable, n, primitiveTransferData.getDirectlyAdded(), new AbstractRelationMemberConverter<PrimitiveData>(){

            @Override
            protected RelationMember getMember(MemberTable memberTable, PrimitiveData primitiveData, OsmPrimitive osmPrimitive) {
                return memberTable.getMemberTableModel().getRelationMemberForPrimitive(osmPrimitive);
            }
        });
    }

    protected <T extends PrimitiveId> void importData(MemberTable memberTable, int n, Collection<T> collection, AbstractRelationMemberConverter<T> abstractRelationMemberConverter) {
        ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>(collection.size());
        for (PrimitiveId primitiveId : collection) {
            RelationMember relationMember = abstractRelationMemberConverter.importPrimitive(memberTable, primitiveId);
            if (relationMember == null) continue;
            arrayList.add(relationMember);
        }
        memberTable.getMemberTableModel().addMembersAtIndexKeepingOldSelection(arrayList, n);
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (n != 2) {
            return;
        }
        MemberTable memberTable = (MemberTable)jComponent;
        MemberTableModel memberTableModel = memberTable.getMemberTableModel();
        memberTableModel.remove(memberTable.getSelectedRows());
        memberTableModel.selectionChanged(null);
    }

    private static abstract class AbstractRelationMemberConverter<T extends PrimitiveId> {
        private AbstractRelationMemberConverter() {
        }

        protected RelationMember importPrimitive(MemberTable memberTable, T t) {
            OsmPrimitive osmPrimitive = memberTable.getLayer().data.getPrimitiveById((PrimitiveId)t);
            if (osmPrimitive == null) {
                Main.warn(I18n.tr("Cannot add {0} since it is not part of dataset", t));
                return null;
            }
            return this.getMember(memberTable, t, osmPrimitive);
        }

        protected abstract RelationMember getMember(MemberTable var1, T var2, OsmPrimitive var3);
    }
}

