/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.util.Optional;
import org.openstreetmap.josm.actions.upload.UploadNotesTask;
import org.openstreetmap.josm.gui.io.AbstractIOTask;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class UploadNoteLayerTask
extends AbstractIOTask {
    private final NoteLayer layer;
    private final ProgressMonitor monitor;

    public UploadNoteLayerTask(NoteLayer noteLayer, ProgressMonitor progressMonitor) {
        CheckParameterUtil.ensureParameterNotNull(noteLayer, "layer");
        this.layer = noteLayer;
        this.monitor = Optional.ofNullable(progressMonitor).orElse(NullProgressMonitor.INSTANCE);
    }

    @Override
    public void run() {
        this.monitor.indeterminateSubTask(I18n.tr("Uploading notes to server", new Object[0]));
        new UploadNotesTask().uploadNotes(this.layer.getNoteData(), this.monitor.createSubTaskMonitor(-1, false));
        if (this.isCanceled()) {
            return;
        }
        this.layer.onPostUploadToServer();
    }

    @Override
    public void cancel() {
        this.setCanceled(true);
    }
}

