(function() {
  var Disposable, Grim;

  Grim = require('grim');

  module.exports = Disposable = (function() {
    Disposable.prototype.disposed = false;

    Disposable.isDisposable = function(object) {
      return typeof (object != null ? object.dispose : void 0) === "function";
    };


    /*
    Section: Construction and Destruction
     */

    function Disposable(disposalAction) {
      this.disposalAction = disposalAction;
    }

    Disposable.prototype.dispose = function() {
      if (!this.disposed) {
        this.disposed = true;
        if (typeof this.disposalAction === "function") {
          this.disposalAction();
        }
        this.disposalAction = null;
      }
    };

    return Disposable;

  })();

  if (Grim.includeDeprecatedAPIs) {
    Disposable.prototype.off = function() {
      Grim.deprecate("Use ::dispose to cancel subscriptions instead of ::off");
      return this.dispose();
    };
  }

}).call(this);
