/*
 * Decompiled with CFR 0.152.
 */
package dguitar.codecs.guitarPro;

import dguitar.codecs.guitarPro.GPKey;
import dguitar.codecs.guitarPro.GPMarker;

public class GPMeasure {
    public boolean hasDoubleBar;
    public GPMarker marker;
    public boolean repeatStart;
    private int _denominator;
    private int _number;
    private int _numberOfAlternateEnding;
    private int _numberOfRepetitions;
    private int _numerator;
    private GPKey _tonality;

    public GPMeasure() {
        this._denominator = 0;
        this.hasDoubleBar = false;
        this.marker = null;
        this._numberOfAlternateEnding = 0;
        this._numberOfRepetitions = 0;
        this._numerator = 0;
        this.repeatStart = false;
        this._tonality = GPKey.C;
    }

    public GPMeasure(GPMeasure original) {
        this.hasDoubleBar = false;
        this.marker = null;
        this._numberOfAlternateEnding = 0;
        this._numberOfRepetitions = 0;
        this.repeatStart = false;
        if (original != null) {
            this._denominator = original._denominator;
            this._numerator = original._numerator;
            this._tonality = original._tonality;
        } else {
            this._denominator = 0;
            this._numerator = 0;
            this._tonality = GPKey.C;
        }
    }

    public boolean equals(Object o) {
        boolean resp = false;
        if (o != null && o.getClass().isInstance(this)) {
            GPMeasure other = (GPMeasure)o;
            resp = this.hasDoubleBar == other.hasDoubleBar;
            resp = resp && this.repeatStart == other.repeatStart;
            resp = resp && this._denominator == other._denominator;
            resp = resp && this._numerator == other._numerator;
            resp = resp && this._number == other._number;
            resp = resp && this._numberOfAlternateEnding == other._numberOfAlternateEnding;
            resp = resp && this._numberOfRepetitions == other._numberOfRepetitions;
        }
        return resp;
    }

    public int getDenominator() {
        return this._denominator;
    }

    public int getNumber() {
        return this._number;
    }

    public int getNumberOfAlternateEnding() {
        return this._numberOfAlternateEnding;
    }

    public int getNumberOfRepetitions() {
        return this._numberOfRepetitions;
    }

    public int getNumerator() {
        return this._numerator;
    }

    public GPKey getTonality() {
        return this._tonality;
    }

    public void setDenominator(int denominator) {
        this._denominator = denominator;
    }

    public void setNumber(int number) {
        this._number = number;
    }

    public void setNumberOfAlternateEnding(int numberOfAlternateEnding) {
        this._numberOfAlternateEnding = numberOfAlternateEnding;
    }

    public void setNumberOfRepetitions(int numberOfRepetitions) {
        this._numberOfRepetitions = numberOfRepetitions;
    }

    public void setNumerator(int numerator) {
        this._numerator = numerator;
    }

    public void setTonality(GPKey tonality) {
        this._tonality = tonality;
    }

    public String toString() {
        String res = "Time Signture:" + this._numerator + "/" + this._denominator;
        if (this.repeatStart) {
            res = String.valueOf(res) + ",Repeat start";
        }
        if (this._numberOfRepetitions > 0) {
            res = String.valueOf(res) + ",Repeat end (" + this._numberOfRepetitions + "X)";
        }
        if (this._numberOfAlternateEnding > 0) {
            res = String.valueOf(res) + ",Alternate ending: " + this._numberOfAlternateEnding;
        }
        if (this.marker != null) {
            res = String.valueOf(res) + ",Marker: " + this.marker;
        }
        res = String.valueOf(res) + ",Tonality: " + this._tonality;
        if (this.hasDoubleBar) {
            res = String.valueOf(res) + ",Double bar " + this.hasDoubleBar;
        }
        return res;
    }
}

