/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import org.stathissideris.ascii2image.core.FileUtils;
import org.stathissideris.ascii2image.graphics.OffScreenSVGRenderer;

public class ImageHandler {
    private static OffScreenSVGRenderer svgRenderer = new OffScreenSVGRenderer();
    private static ImageHandler instance = new ImageHandler();
    private static final MediaTracker tracker = new MediaTracker(new JLabel());

    public static ImageHandler instance() {
        return instance;
    }

    public BufferedImage loadBufferedImage(File file) throws IOException {
        return ImageIO.read(file);
    }

    public Image loadImage(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        Image image = null;
        image = uRL != null ? Toolkit.getDefaultToolkit().getImage(uRL) : Toolkit.getDefaultToolkit().getImage(string);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Failed to load image " + string);
            interruptedException.printStackTrace();
        }
        tracker.removeImage(image, 0);
        return image;
    }

    public BufferedImage renderSVG(String string, int n, int n2, boolean bl) throws IOException {
        File file = new File(string);
        URI uRI = file.toURI();
        return svgRenderer.renderToImage(uRI.toString(), n, n2, bl, null, null);
    }

    public BufferedImage renderSVG(String string, int n, int n2, boolean bl, String string2, Color color) throws IOException {
        File file = new File(string);
        URI uRI = file.toURI();
        return svgRenderer.renderToImage(uRI.toString(), n, n2, bl, string2, color);
    }

    public static void main(String[] stringArray) throws IOException {
        OffScreenSVGRenderer offScreenSVGRenderer = new OffScreenSVGRenderer();
        String string = FileUtils.readFile(new File("sphere.svg")).replaceAll("#187637", "#1133FF");
        System.out.println(string);
        BufferedImage bufferedImage = offScreenSVGRenderer.renderXMLToImage(string, 200, 200, false, null, null);
        try {
            File file = new File("testing.png");
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            System.err.println("Error: Cannot write to file");
        }
    }
}

