/*
 * Decompiled with CFR 0.152.
 */
package esmska.persistence;

import a_vcard.android.syncml.pim.vcard.ContactStruct;
import a_vcard.android.syncml.pim.vcard.VCardComposer;
import a_vcard.android.syncml.pim.vcard.VCardException;
import com.csvreader.CsvWriter;
import esmska.data.Contact;
import esmska.data.Gateway;
import esmska.data.GatewayConfig;
import esmska.data.History;
import esmska.data.Keyring;
import esmska.data.SMS;
import esmska.data.Signature;
import esmska.data.Tuple;
import esmska.utils.L10N;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;

public class ExportManager {
    private static final Logger logger = Logger.getLogger(ExportManager.class.getName());
    private static final ResourceBundle l10n = L10N.l10nBundle;

    private ExportManager() {
    }

    public static void exportContacts(Collection<Contact> contacts, OutputStream out) throws IOException {
        Validate.notNull(contacts);
        Validate.notNull(out);
        logger.finer("Exporting " + contacts.size() + " contacts to CSV");
        CsvWriter writer = new CsvWriter(out, ',', Charset.forName("UTF-8"));
        writer.writeComment(l10n.getString("ExportManager.contact_list"));
        for (Contact contact : contacts) {
            writer.writeRecord(new String[]{contact.getName(), contact.getNumber(), contact.getGateway()});
        }
        writer.flush();
    }

    public static void exportContactsToVCard(Collection<Contact> contacts, OutputStream out) throws IOException, VCardException {
        Validate.notNull(contacts);
        Validate.notNull(out);
        logger.finer("Exporting " + contacts.size() + " contacts to vCard");
        VCardComposer composer = new VCardComposer();
        for (Contact contact : contacts) {
            ContactStruct struct = new ContactStruct();
            struct.name = contact.getName();
            struct.addPhone(2, contact.getNumber(), null, true);
            String vcardString = composer.createVCard(struct, 2);
            IOUtils.write(vcardString, out, "UTF-8");
            IOUtils.write("\n", out, "UTF-8");
        }
        out.flush();
    }

    public static void exportQueue(Collection<SMS> queue, OutputStream out) throws IOException {
        Validate.notNull(queue);
        Validate.notNull(out);
        logger.finer("Exporting queue of " + queue.size() + " SMSs");
        CsvWriter writer = new CsvWriter(out, ',', Charset.forName("UTF-8"));
        writer.writeComment(l10n.getString("ExportManager.sms_queue"));
        for (SMS sms : queue) {
            writer.writeRecord(new String[]{sms.getName(), sms.getNumber(), sms.getGateway(), sms.getText(), sms.getId()});
        }
        writer.flush();
    }

    public static void exportHistory(Collection<History.Record> history, OutputStream out) throws IOException {
        Validate.notNull(history);
        Validate.notNull(out);
        logger.finer("Exporting history of " + history.size() + " records");
        CsvWriter writer = new CsvWriter(out, ',', Charset.forName("UTF-8"));
        DateFormat df = DateFormat.getDateTimeInstance(1, 1, Locale.ROOT);
        writer.writeComment(l10n.getString("ExportManager.history"));
        for (History.Record record : history) {
            writer.writeRecord(new String[]{df.format(record.getDate()), record.getName(), record.getNumber(), record.getGateway(), record.getText(), record.getSenderName(), record.getSenderNumber(), record.getSmsId()});
        }
        writer.flush();
    }

    public static void exportKeyring(Keyring keyring, OutputStream out) throws IOException, GeneralSecurityException {
        Validate.notNull(keyring);
        Validate.notNull(out);
        logger.finer("Exporting keyring");
        CsvWriter writer = new CsvWriter(out, ',', Charset.forName("UTF-8"));
        writer.writeComment(l10n.getString("ExportManager.login"));
        for (String gatewayName : keyring.getGatewayNames()) {
            Tuple<String, String> key = keyring.getKey(gatewayName);
            String login = key.get1();
            String password = Keyring.encrypt(key.get2());
            writer.writeRecord(new String[]{gatewayName, login, password});
        }
        writer.flush();
    }

    public static void exportGateway(String scriptContents, byte[] icon, OutputStream scriptOut, OutputStream iconOut) throws IOException {
        Validate.notEmpty(scriptContents);
        Validate.notNull(scriptOut);
        if (icon != null) {
            Validate.notNull(iconOut);
        }
        logger.finer("Exporting gateway");
        IOUtils.write(scriptContents, scriptOut, "UTF-8");
        scriptOut.flush();
        if (icon != null) {
            IOUtils.write(icon, iconOut);
            iconOut.flush();
        }
    }

    public static void exportGatewayProperties(Collection<Gateway> gateways, Collection<Signature> signatures, Signature defaultSignature, OutputStream out) throws IOException {
        Validate.notNull(gateways);
        Validate.notNull(signatures);
        Validate.notNull(out);
        TreeMap<String, GatewayConfig> gwConfigs = new TreeMap<String, GatewayConfig>();
        for (Gateway gateway : gateways) {
            gwConfigs.put(gateway.getName(), gateway.getConfig());
        }
        logger.finer("Exporting gateway properties");
        JSONObject obj = new JSONObject();
        JSONObject jsonGwConfigs = JSONObject.fromObject(gwConfigs);
        JSONArray jsonSignatures = JSONArray.fromObject(new TreeSet<Signature>(signatures));
        obj.put("configs", jsonGwConfigs);
        obj.put("signatures", jsonSignatures);
        obj.put("default signature", defaultSignature);
        String jsonString = obj.toString(2);
        IOUtils.write(jsonString, out, "UTF-8");
    }
}

