/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins.dialogs;

import accessories.plugins.dialogs.ManagePatternsPopupDialog;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;

public class ArrayListTransferHandler
extends TransferHandler {
    DataFlavor localArrayListFlavor;
    String localArrayListType = "application/x-java-jvm-local-objectref;class=java.util.ArrayList";
    JList source = null;
    int[] indices = null;
    int addIndex = -1;
    int addCount = 0;

    public ArrayListTransferHandler() {
        try {
            this.localArrayListFlavor = new DataFlavor(this.localArrayListType);
        }
        catch (ClassNotFoundException e) {
            System.out.println("ArrayListTransferHandler: unable to create data flavor");
        }
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        JList target = null;
        ArrayList alist = null;
        if (!this.canImport(c, t.getTransferDataFlavors())) {
            return false;
        }
        try {
            target = (JList)c;
            if (!this.hasLocalArrayListFlavor(t.getTransferDataFlavors())) {
                return false;
            }
            alist = (ArrayList)t.getTransferData(this.localArrayListFlavor);
        }
        catch (UnsupportedFlavorException ufe) {
            System.out.println("importData: unsupported data flavor");
            return false;
        }
        catch (IOException ioe) {
            System.out.println("importData: I/O exception");
            return false;
        }
        int index = target.getSelectedIndex();
        if (this.source.equals(target) && this.indices != null && index >= this.indices[0] - 1 && index <= this.indices[this.indices.length - 1]) {
            this.indices = null;
            return true;
        }
        ManagePatternsPopupDialog.PatternListModel listModel = (ManagePatternsPopupDialog.PatternListModel)target.getModel();
        int max = listModel.getSize();
        if (index < 0) {
            index = max;
        } else if (++index > max) {
            index = max;
        }
        this.addIndex = index;
        this.addCount = alist.size();
        for (int i = 0; i < alist.size(); ++i) {
            listModel.add(index++, alist.get(i));
        }
        return true;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        if (action == 2 && this.indices != null) {
            int i;
            ManagePatternsPopupDialog.PatternListModel model = (ManagePatternsPopupDialog.PatternListModel)this.source.getModel();
            if (this.addCount > 0) {
                for (i = 0; i < this.indices.length; ++i) {
                    if (this.indices[i] <= this.addIndex) continue;
                    int n = i;
                    this.indices[n] = this.indices[n] + this.addCount;
                }
            }
            for (i = this.indices.length - 1; i >= 0; --i) {
                model.remove(this.indices[i]);
            }
        }
        this.indices = null;
        this.addIndex = -1;
        this.addCount = 0;
    }

    private boolean hasLocalArrayListFlavor(DataFlavor[] flavors) {
        if (this.localArrayListFlavor == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(this.localArrayListFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return this.hasLocalArrayListFlavor(flavors);
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof JList) {
            this.source = (JList)c;
            this.indices = this.source.getSelectedIndices();
            Object[] values = this.source.getSelectedValues();
            if (values == null || values.length == 0) {
                return null;
            }
            ArrayList<String> alist = new ArrayList<String>(values.length);
            for (int i = 0; i < values.length; ++i) {
                Object o = values[i];
                String str = o.toString();
                if (str == null) {
                    str = "";
                }
                alist.add(str);
            }
            return new ArrayListTransferable(alist);
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    public class ArrayListTransferable
    implements Transferable {
        ArrayList data;

        public ArrayListTransferable(ArrayList alist) {
            this.data = alist;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{ArrayListTransferHandler.this.localArrayListFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return ArrayListTransferHandler.this.localArrayListFlavor.equals(flavor);
        }
    }
}

