/*
 * Decompiled with CFR 0.152.
 */
package plugins.map;

import freemind.main.Resources;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.MindMapNode;
import freemind.modes.common.plugins.MapNodePositionHolderBase;
import freemind.modes.mindmapmode.MindMapController;
import freemind.view.mindmapview.NodeView;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import plugins.map.FreeMindMapController;
import plugins.map.Registration;
import plugins.map.TileImage;

public class MapNodePositionHolder
extends MapNodePositionHolderBase {
    private static final String MAP_LOCATION = "map_location";
    private Coordinate mPosition = new Coordinate(0.0, 0.0);
    private Coordinate mMapCenter = new Coordinate(0.0, 0.0);
    private String mTileSource = null;
    private int mZoom = 1;
    private static String sMapLocationGif;

    public void invoke(MindMapNode pNode) {
        super.invoke(pNode);
        this.getRegistration().registerMapNode(this);
    }

    protected Registration getRegistration() {
        return (Registration)this.getPluginBaseClass();
    }

    public void showTooltip() {
        if (this.isTooltipDesired()) {
            if (this.mTooltipLocation != null) {
                File tooltipFile = this.getTooltipFile(false);
                if (tooltipFile.exists()) {
                    this.addTooltip();
                } else {
                    this.createToolTip(false);
                }
            } else {
                this.createToolTip(false);
            }
        }
    }

    public void shutdownMapHook() {
        this.getRegistration().deregisterMapNode(this);
        super.shutdownMapHook();
    }

    public void save(XMLElement xml) {
        super.save(xml);
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("XML_STORAGE_POS_LON", this.toString(this.mPosition.getLon()));
        values.put("XML_STORAGE_POS_LAT", this.toString(this.mPosition.getLat()));
        values.put("XML_STORAGE_MAP_LON", this.toString(this.mMapCenter.getLon()));
        values.put("XML_STORAGE_MAP_LAT", this.toString(this.mMapCenter.getLat()));
        values.put("XML_STORAGE_ZOOM", this.toString(this.mZoom));
        if (this.mTileSource != null) {
            values.put("XML_STORAGE_TILE_SOURCE", this.mTileSource);
        }
        if (this.mTooltipLocation != null) {
            values.put("XML_STORAGE_MAP_TOOLTIP_LOCATION", this.mTooltipLocation);
        }
        this.saveNameValuePairs(values, xml);
    }

    private String toString(double pDouble) {
        return "" + pDouble;
    }

    private String toString(int pInt) {
        return "" + pInt;
    }

    public void loadFrom(XMLElement pChild) {
        super.loadFrom(pChild);
        HashMap values = this.loadNameValuePairs(pChild);
        this.mPosition.setLat(this.fromString(values.get("XML_STORAGE_POS_LAT")));
        this.mPosition.setLon(this.fromString(values.get("XML_STORAGE_POS_LON")));
        this.mMapCenter.setLat(this.fromString(values.get("XML_STORAGE_MAP_LAT")));
        this.mMapCenter.setLon(this.fromString(values.get("XML_STORAGE_MAP_LON")));
        this.mZoom = this.intFromString(values.get("XML_STORAGE_ZOOM"));
        this.mTileSource = (String)values.get("XML_STORAGE_TILE_SOURCE");
    }

    private double fromString(Object pObject) {
        if (pObject == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble((String)pObject);
        }
        catch (Exception e) {
            Resources.getInstance().logException((Throwable)e);
            return 0.0;
        }
    }

    private int intFromString(Object pObject) {
        if (pObject == null) {
            return 1;
        }
        try {
            return Integer.parseInt((String)pObject);
        }
        catch (Exception e) {
            Resources.getInstance().logException((Throwable)e);
            return 1;
        }
    }

    public void changePosition(Coordinate pPosition, Coordinate pMapCenter, int pZoom, String pTileSource) {
        this.getRegistration().changePosition(this, pPosition, pMapCenter, pZoom, pTileSource);
    }

    public Coordinate getPosition() {
        return this.mPosition;
    }

    public static MapNodePositionHolder getHook(MindMapNode node) {
        return (MapNodePositionHolder)MapNodePositionHolder.getBaseHook((MindMapNode)node);
    }

    public void setTileSource(String pTileSource) {
        this.mTileSource = pTileSource;
    }

    public String getTileSource() {
        return this.mTileSource;
    }

    public void setPosition(Coordinate pPosition) {
        this.mPosition = pPosition;
    }

    public Coordinate getMapCenter() {
        return this.mMapCenter;
    }

    public void setMapCenter(Coordinate pMapCenter) {
        this.mMapCenter = pMapCenter;
    }

    public int getZoom() {
        return this.mZoom;
    }

    public void setZoom(int pZoom) {
        this.mZoom = pZoom;
    }

    public MindMapNode getNode() {
        return super.getNode();
    }

    public String getImageHtml() {
        String imageTag = this.getImageTag();
        String imageHtml = "<html><body>" + imageTag + "</body></html>";
        this.logger.fine("Tooltip at " + imageTag);
        return imageHtml;
    }

    protected String getImageTag() {
        String imageTag = "ERROR";
        try {
            imageTag = "<img src=\"" + Tools.fileToUrl((File)this.getTooltipFile(false)) + "\"/>";
        }
        catch (MalformedURLException e) {
            Resources.getInstance().logException((Throwable)e);
        }
        return imageTag;
    }

    public File getTooltipFile(boolean pForce) {
        boolean storeProperty;
        if (this.mTooltipFile != null) {
            return this.mTooltipFile;
        }
        File mapFile = this.getMap().getFile();
        boolean bl = storeProperty = Resources.getInstance().getBoolProperty("node_map_store_tooltip") || pForce;
        if (mapFile == null || !storeProperty) {
            try {
                if (mapFile == null) {
                    this.logger.warning("Creating tooltip in .freemind directory, as we don't know, where the map will be stored.");
                }
                this.mTooltipFile = File.createTempFile("node_map_tooltip_" + this.getNodeId(), ".png", new File(this.getController().getFrame().getFreemindDirectory()));
                if (!pForce) {
                    this.mTooltipFile.deleteOnExit();
                }
            }
            catch (IOException e) {
                Resources.getInstance().logException((Throwable)e);
            }
        } else {
            String createdFileName = mapFile.getAbsolutePath() + "_map_" + this.getNodeId() + ".png";
            this.mTooltipFile = new File(createdFileName);
            if (!pForce) {
                this.mTooltipLocation = this.mTooltipFile.getName();
            }
        }
        return this.mTooltipFile;
    }

    public boolean createToolTip(boolean pForce) {
        boolean success = true;
        TileImage tileImage = this.getRegistration().getImageForTooltip(this.mPosition, this.mZoom, this.mTileSource);
        if (!tileImage.hasErrors()) {
            this.logger.fine("Creating tooltip for " + this.getNode());
            try {
                File tooltipFile = this.getTooltipFile(pForce);
                ImageIO.write(tileImage.getImage(), "png", tooltipFile);
                this.addTooltip();
            }
            catch (IOException e) {
                Resources.getInstance().logException((Throwable)e);
            }
        } else {
            tileImage = null;
            this.logger.warning("Tooltip for node '" + this.getNode() + "' has errors on creation.");
            success = false;
        }
        return success;
    }

    public String getNodeId() {
        return this.getMindMapController().getNodeID(this.getNode());
    }

    private MindMapController getMindMapController() {
        return (MindMapController)this.getController();
    }

    public void recreateTooltip() {
        this.getTooltipFile(false).delete();
        this.mTooltipLocation = null;
        this.showTooltip();
    }

    public boolean hasFoldedParents() {
        return this.getNode().hasFoldedParents();
    }

    public void onViewCreatedHook(NodeView pNodeView) {
        super.onViewCreatedHook(pNodeView);
        this.logger.fine("View created for " + (Object)((Object)this));
        this.getRegistration().fireNodeVisibilityChanged(true, this);
    }

    public void onViewRemovedHook(NodeView pNodeView) {
        super.onViewRemovedHook(pNodeView);
        this.logger.fine("Removed view for " + (Object)((Object)this));
        this.getRegistration().fireNodeVisibilityChanged(false, this);
    }

    public String toString() {
        return "MapNodePositionHolder [mPosition=" + this.mPosition + ", mMapCenter=" + this.mMapCenter + ", mTileSource=" + this.mTileSource + ", mZoom=" + this.mZoom + ", getNode()=" + this.getNode() + "]";
    }

    public void saveHtml(Writer pFileout) throws IOException {
        super.saveHtml(pFileout);
        if (sMapLocationGif == null) {
            sMapLocationGif = this.getController().getFrame().getProperty(MAP_LOCATION);
        }
        String link = FreeMindMapController.getLink(this.mTileSource, this.mPosition, this.mMapCenter, this.mZoom);
        pFileout.append("<a href=\"" + link + "\">" + "<img src=\"" + sMapLocationGif + "\"/></a>");
    }

    public static interface MapNodePositionListener {
        public void registerMapNode(MapNodePositionHolder var1);

        public void deregisterMapNode(MapNodePositionHolder var1);
    }
}

