/*
 * Decompiled with CFR 0.152.
 */
package primitive.collection;

import java.util.Random;
import primitive.collection.FloatFunction;
import primitive.collection.FloatList;
import primitive.collection.IntStatList;

public class FloatStatList
extends FloatList {
    public void each(FloatFunction floatFunction) {
        for (int i = 0; i != this.size(); ++i) {
            floatFunction.apply(this.get(i));
        }
    }

    public float reduce(float f, FloatFunction floatFunction) {
        float f2 = f;
        for (int i = 0; i != this.size(); ++i) {
            f2 = floatFunction.accumulate(f2, this.get(i));
        }
        return f2;
    }

    public float sum() {
        FloatFunction floatFunction = new FloatFunction(){

            @Override
            public float accumulate(float f, float f2) {
                return f + f2;
            }
        };
        return this.reduce(0.0f, floatFunction);
    }

    public FloatStats stats() {
        final FloatStats floatStats = new FloatStats();
        FloatFunction floatFunction = new FloatFunction(){

            @Override
            public void apply(float f) {
                if (f < floatStats.min) {
                    floatStats.min = f;
                }
                if (f > floatStats.max) {
                    floatStats.max = f;
                }
                floatStats.sum += f;
            }
        };
        this.each(floatFunction);
        floatStats.n = this.size();
        floatStats.avg = (double)floatStats.sum / (double)floatStats.n;
        floatFunction = new FloatFunction(){

            @Override
            public void apply(float f) {
                floatStats.var += Math.pow(floatStats.avg - (double)f, 2.0);
            }
        };
        this.each(floatFunction);
        floatStats.var /= (double)floatStats.n;
        floatStats.stdd = Math.pow(floatStats.var, 0.5);
        return floatStats;
    }

    static FloatStatList random(int n) {
        Random random = new Random(0L);
        FloatStatList floatStatList = new FloatStatList();
        for (int i = 0; i != n; ++i) {
            float f = random.nextFloat();
            floatStatList.add(f);
        }
        return floatStatList;
    }

    private static void p(Object object) {
        System.out.println(object);
    }

    public static void main(String[] stringArray) {
        FloatStatList floatStatList = FloatStatList.random(10);
        floatStatList.each(new FloatFunction(){

            @Override
            public void apply(float f) {
                FloatStatList.p(Float.valueOf(f));
            }
        });
        FloatStatList.p(floatStatList.stats());
        FloatStatList.p(Float.valueOf(floatStatList.sum()));
        IntStatList intStatList = new IntStatList();
        for (int i = 1; i < 101; ++i) {
            intStatList.add(i);
        }
        FloatStatList.p(intStatList.stats());
        FloatStatList.p(intStatList.sum());
    }

    class FloatStats {
        public int n;
        public float min = Float.MAX_VALUE;
        public float max = Float.MIN_VALUE;
        public float sum;
        public double avg;
        public double stdd;
        public double var;

        FloatStats() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("n    = ");
            stringBuilder.append(this.n);
            stringBuilder.append("\n");
            stringBuilder.append("min  = ");
            stringBuilder.append(this.min);
            stringBuilder.append("\n");
            stringBuilder.append("max  = ");
            stringBuilder.append(this.max);
            stringBuilder.append("\n");
            stringBuilder.append("sum  = ");
            stringBuilder.append(this.sum);
            stringBuilder.append("\n");
            stringBuilder.append("avg  = ");
            stringBuilder.append(this.avg);
            stringBuilder.append("\n");
            stringBuilder.append("stdd = ");
            stringBuilder.append(this.stdd);
            stringBuilder.append("\n");
            stringBuilder.append("var  = ");
            stringBuilder.append(this.var);
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }
    }
}

