

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Internal Constants{/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Internal Constants</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="style_intro2.html">Prev</a> </td><th width="60%" align="center">Appendix C. GPSBabel XCSV Style Files</th><td width="20%" align="right"> <a accesskey="n" href="style_global.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="styles_internal_const"></a>Internal Constants</h2></div></div></div><p>
A few internal constants are defined in the XCSV parser to make the style
file simpler.  They may or may not be used and are optional in most cases. 
Note that only certain style file directives map these constants.
</p><p>
</p><div class="segmentedlist"><table border="0"><thead><tr class="segtitle"><th>Style Constant</th><th>Maps to Char(s)</th></tr></thead><tbody><tr class="seglistitem"><td class="seg">COMMA</td><td class="seg">,</td></tr><tr class="seglistitem"><td class="seg">COMMASPACE</td><td class="seg">,&lt;space&gt;</td></tr><tr class="seglistitem"><td class="seg">SINGLEQUOTE</td><td class="seg">'</td></tr><tr class="seglistitem"><td class="seg">DOUBLEQUOTE</td><td class="seg">"</td></tr><tr class="seglistitem"><td class="seg">COLON</td><td class="seg">:</td></tr><tr class="seglistitem"><td class="seg">SEMICOLON</td><td class="seg">;</td></tr><tr class="seglistitem"><td class="seg">NEWLINE</td><td class="seg">\n</td></tr><tr class="seglistitem"><td class="seg">CR</td><td class="seg">\r</td></tr><tr class="seglistitem"><td class="seg">CRNEWLINE</td><td class="seg">\r\n</td></tr><tr class="seglistitem"><td class="seg">TAB</td><td class="seg">\t</td></tr><tr class="seglistitem"><td class="seg">SPACE</td><td class="seg">&lt;space&gt;</td></tr><tr class="seglistitem"><td class="seg">HASH</td><td class="seg">#</td></tr><tr class="seglistitem"><td class="seg">PIPE</td><td class="seg">|</td></tr><tr class="seglistitem"><td class="seg">WHITESPACE</td><td class="seg">see below</td></tr></tbody></table></div><p>
</p><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_const_whitespace"></a>WHITESPACE</h3></div></div></div><p>
The WHITESPACE constant has special properties.  When reading data, 
WHITESPACE refers to sequential runs of SPACES and/or TABS.  When
writing data, WHITESPACE is always a single SPACE.
</p><p>
For example, the following line:
</p><pre class="screen">SOME_NAME       30.1208 -91.1365    SOME OTHER NAME
</pre><p>
Parses into the following data fields: 
</p><pre class="screen">SOME_NAME,30.1208,-91.1365,SOME,OTHER,NAME
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_const_comments"></a>COMMENTS</h3></div></div></div><p>
Anything after a hash (#) on a line is not parsed.  For example:
</p><pre class="screen">#THIS ENTIRE LINE IS A COMMENT.
#FIELD	LAT_DECIMAL, "", "%f"   THIS ENTIRE LINE IS A COMMENT
FIELD LAT_DECIMAL, "", "%f"  # ONLY THIS SENTENCE IS A COMMENT.
</pre></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="style_intro2.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="Styles.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="style_global.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Style file overview </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Global Properties of the File</td></tr></table></div>
  
      {/literal}{/block}
  