/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.CompositeArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.FileDependencyArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedFileDependencyResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedFileDependencyResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.LongIdGenerator;

public class FileDependencyCollectingGraphVisitor
implements DependencyGraphVisitor,
VisitedFileDependencyResults {
    private final IdGenerator<Long> idGenerator = new LongIdGenerator();
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final SetMultimap<Long, ArtifactSet> filesByConfiguration = LinkedHashMultimap.create();
    private Map<FileCollectionDependency, ArtifactSet> rootFiles;

    public FileDependencyCollectingGraphVisitor(ImmutableAttributesFactory immutableAttributesFactory) {
        this.immutableAttributesFactory = immutableAttributesFactory;
    }

    @Override
    public void start(DependencyGraphNode root) {
        Set<LocalFileDependencyMetadata> fileDependencies = ((LocalConfigurationMetadata)root.getMetadata()).getFiles();
        this.rootFiles = Maps.newLinkedHashMap();
        for (LocalFileDependencyMetadata fileDependency : fileDependencies) {
            FileDependencyArtifactSet artifactSet = new FileDependencyArtifactSet((Long)this.idGenerator.generateId(), fileDependency, this.immutableAttributesFactory);
            this.rootFiles.put(fileDependency.getSource(), artifactSet);
            this.filesByConfiguration.put((Object)root.getNodeId(), (Object)artifactSet);
        }
    }

    @Override
    public void visitNode(DependencyGraphNode resolvedConfiguration) {
    }

    @Override
    public void visitSelector(DependencyGraphSelector selector) {
    }

    @Override
    public void visitEdges(DependencyGraphNode resolvedConfiguration) {
        ConfigurationMetadata configurationMetadata = resolvedConfiguration.getMetadata();
        if (configurationMetadata instanceof LocalConfigurationMetadata) {
            LocalConfigurationMetadata localConfigurationMetadata = (LocalConfigurationMetadata)configurationMetadata;
            for (DependencyGraphEdge dependencyGraphEdge : resolvedConfiguration.getIncomingEdges()) {
                if (!dependencyGraphEdge.isTransitive()) continue;
                Set<LocalFileDependencyMetadata> fileDependencies = localConfigurationMetadata.getFiles();
                for (LocalFileDependencyMetadata fileDependency : fileDependencies) {
                    this.filesByConfiguration.put((Object)resolvedConfiguration.getNodeId(), (Object)new FileDependencyArtifactSet((Long)this.idGenerator.generateId(), fileDependency, this.immutableAttributesFactory));
                }
            }
        }
    }

    @Override
    public void finish(DependencyGraphNode root) {
    }

    @Override
    public SelectedFileDependencyResults select(Spec<? super ComponentIdentifier> componentFilter, Transformer<ResolvedArtifactSet, Collection<? extends ResolvedVariant>> selector) {
        ImmutableMap.Builder filesByConfigBuilder = ImmutableMap.builder();
        for (Long key : this.filesByConfiguration.keySet()) {
            Set artifactsForConfiguration = this.filesByConfiguration.get((Object)key);
            ArrayList<ResolvedArtifactSet> selectedArtifacts = new ArrayList<ResolvedArtifactSet>(artifactsForConfiguration.size());
            for (ArtifactSet artifactSet : artifactsForConfiguration) {
                selectedArtifacts.add(artifactSet.select(componentFilter, selector));
            }
            filesByConfigBuilder.put((Object)key, (Object)CompositeArtifactSet.of(selectedArtifacts));
        }
        ImmutableMap filesByConfig = filesByConfigBuilder.build();
        ResolvedArtifactSet allFiles = CompositeArtifactSet.of((Collection<? extends ResolvedArtifactSet>)filesByConfig.values());
        ImmutableMap.Builder rootFilesBuilder = ImmutableMap.builder();
        for (Map.Entry<FileCollectionDependency, ArtifactSet> entry : this.rootFiles.entrySet()) {
            rootFilesBuilder.put((Object)entry.getKey(), (Object)entry.getValue().select(componentFilter, selector));
        }
        return new DefaultFileDependencyResults((Map<FileCollectionDependency, ResolvedArtifactSet>)rootFilesBuilder.build(), allFiles, (Map<Long, ResolvedArtifactSet>)filesByConfig);
    }

    private static class DefaultFileDependencyResults
    implements SelectedFileDependencyResults {
        private final Map<FileCollectionDependency, ResolvedArtifactSet> rootFiles;
        private final Map<Long, ResolvedArtifactSet> filesByConfiguration;
        private final ResolvedArtifactSet allArtifacts;

        DefaultFileDependencyResults(Map<FileCollectionDependency, ResolvedArtifactSet> rootFiles, ResolvedArtifactSet allArtifacts, Map<Long, ResolvedArtifactSet> filesByConfiguration) {
            this.rootFiles = rootFiles;
            this.allArtifacts = allArtifacts;
            this.filesByConfiguration = filesByConfiguration;
        }

        @Override
        public Map<FileCollectionDependency, ResolvedArtifactSet> getFirstLevelFiles() {
            return this.rootFiles;
        }

        @Override
        public ResolvedArtifactSet getArtifacts(long id) {
            ResolvedArtifactSet artifacts = this.filesByConfiguration.get(id);
            return artifacts == null ? ResolvedArtifactSet.EMPTY : artifacts;
        }

        @Override
        public ResolvedArtifactSet getArtifacts() {
            return this.allArtifacts;
        }
    }
}

