/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.Arrays;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshotter;
import org.gradle.caching.internal.BuildCacheHasher;

public class ArrayValueSnapshot
implements ValueSnapshot {
    public static final ValueSnapshot EMPTY = new ArrayValueSnapshot(new ValueSnapshot[0]);
    private final ValueSnapshot[] elements;

    public ArrayValueSnapshot(ValueSnapshot[] elements) {
        this.elements = elements;
    }

    public ValueSnapshot[] getElements() {
        return this.elements;
    }

    public void appendToHasher(BuildCacheHasher hasher) {
        hasher.putString("Array");
        hasher.putInt(this.elements.length);
        for (ValueSnapshot element : this.elements) {
            element.appendToHasher(hasher);
        }
    }

    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        ValueSnapshot other = snapshotter.snapshot(value);
        if (other instanceof ArrayValueSnapshot) {
            ArrayValueSnapshot otherArray = (ArrayValueSnapshot)other;
            if (Arrays.equals(this.elements, otherArray.elements)) {
                return this;
            }
        }
        return other;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ArrayValueSnapshot other = (ArrayValueSnapshot)obj;
        return Arrays.equals(this.elements, other.elements);
    }

    public int hashCode() {
        return Arrays.hashCode(this.elements);
    }
}

