/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.hash;

import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.hash.FileHasher;
import org.gradle.internal.nativeintegration.filesystem.FileMetadataSnapshot;
import org.gradle.internal.resource.TextResource;

public class DefaultFileHasher
implements FileHasher {
    private static final byte[] SIGNATURE = Hashing.md5().hashString((CharSequence)DefaultFileHasher.class.getName(), Charsets.UTF_8).asBytes();
    private final Queue<byte[]> buffers = new ArrayBlockingQueue<byte[]>(16);

    public HashCode hash(InputStream inputStream) {
        try {
            return this.doHash(inputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create MD5 hash for file content.", (Throwable)e);
        }
    }

    public HashCode hash(TextResource resource) {
        Hasher hasher = DefaultFileHasher.createFileHasher();
        hasher.putString((CharSequence)resource.getText(), Charsets.UTF_8);
        return hasher.hash();
    }

    public HashCode hash(File file) {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            return this.doHash(inputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create MD5 hash for file '%s'.", file), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashCode doHash(InputStream inputStream) throws IOException {
        try {
            byte[] buffer = this.takeBuffer();
            try {
                int nread;
                Hasher hasher = DefaultFileHasher.createFileHasher();
                while ((nread = inputStream.read(buffer)) >= 0) {
                    hasher.putBytes(buffer, 0, nread);
                }
                HashCode hashCode = hasher.hash();
                this.returnBuffer(buffer);
                return hashCode;
            }
            catch (Throwable throwable) {
                this.returnBuffer(buffer);
                throw throwable;
            }
        }
        finally {
            inputStream.close();
        }
    }

    private void returnBuffer(byte[] buffer) {
        this.buffers.offer(buffer);
    }

    private byte[] takeBuffer() {
        byte[] buffer = this.buffers.poll();
        if (buffer == null) {
            buffer = new byte[8192];
        }
        return buffer;
    }

    public HashCode hash(File file, FileMetadataSnapshot fileDetails) {
        return this.hash(file);
    }

    public HashCode hash(FileTreeElement fileDetails) {
        return this.hash(fileDetails.getFile());
    }

    private static Hasher createFileHasher() {
        Hasher hasher = Hashing.md5().newHasher();
        hasher.putBytes(SIGNATURE);
        return hasher;
    }
}

