/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.util.Arrays;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;

public class ClassLoaderIds {
    private static ClassLoaderId of(Type type, String ... attributes) {
        return new DefaultClassLoaderId(type, attributes);
    }

    public static ClassLoaderId buildScript(String fileName, String operationId) {
        return ClassLoaderIds.of(Type.SCRIPT, fileName, operationId);
    }

    public static ClassLoaderId testTaskClasspath(String testTaskPath) {
        return ClassLoaderIds.of(Type.TEST_TASK_CLASSPATH, testTaskPath);
    }

    private static class DefaultClassLoaderId
    implements ClassLoaderId {
        private final Type type;
        private final String[] attributes;

        public DefaultClassLoaderId(Type type, String[] attributes) {
            this.type = type;
            this.attributes = attributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultClassLoaderId that = (DefaultClassLoaderId)o;
            return this.type == that.type && Arrays.equals(this.attributes, that.attributes);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + Arrays.hashCode(this.attributes);
            return result;
        }

        public String toString() {
            return "ClassLoaderId{type=" + (Object)((Object)this.type) + ", attributes=" + Arrays.toString(this.attributes) + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SCRIPT,
        TEST_TASK_CLASSPATH;

    }
}

