/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildevents;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.tasks.TaskState;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.progress.LoggerProvider;

public class TaskExecutionLogger
implements TaskExecutionListener {
    private final Map<Task, ProgressLogger> currentTasks = new HashMap<Task, ProgressLogger>();
    private final ProgressLoggerFactory progressLoggerFactory;
    private LoggerProvider parentLoggerProvider;

    public TaskExecutionLogger(ProgressLoggerFactory progressLoggerFactory, LoggerProvider parentLoggerProvider) {
        this.progressLoggerFactory = progressLoggerFactory;
        this.parentLoggerProvider = parentLoggerProvider;
    }

    public void beforeExecute(Task task) {
        assert (!this.currentTasks.containsKey(task));
        ProgressLogger currentTask = this.progressLoggerFactory.newOperation(TaskExecutionLogger.class, this.parentLoggerProvider.getLogger());
        String displayName = this.getDisplayName((TaskInternal)task);
        currentTask.setDescription("Execute ".concat(displayName));
        currentTask.setShortDescription(displayName);
        currentTask.setLoggingHeader(displayName);
        currentTask.started();
        this.currentTasks.put(task, currentTask);
    }

    public void afterExecute(Task task, TaskState state) {
        ProgressLogger currentTask = this.currentTasks.remove(task);
        String taskMessage = state.getFailure() != null ? "FAILED" : state.getSkipMessage();
        currentTask.completed(taskMessage);
    }

    private String getDisplayName(TaskInternal task) {
        return task.getIdentityPath().toString();
    }
}

