/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.process.JavaForkOptions;
import org.gradle.util.GUtil;
import org.gradle.util.internal.ArgumentsSplitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmOptions {
    private static final Pattern SYS_PROP_PATTERN = Pattern.compile("(?s)-D(.+?)=(.*)");
    private static final Pattern NO_ARG_SYS_PROP_PATTERN = Pattern.compile("-D([^=]+)");
    private static final Pattern MIN_HEAP_PATTERN = Pattern.compile("-Xms(.+)");
    private static final Pattern MAX_HEAP_PATTERN = Pattern.compile("-Xmx(.+)");
    private static final Pattern BOOTSTRAP_PATTERN = Pattern.compile("-Xbootclasspath:(.+)");
    public static final String FILE_ENCODING_KEY = "file.encoding";
    public static final String USER_LANGUAGE_KEY = "user.language";
    public static final String USER_COUNTRY_KEY = "user.country";
    public static final String USER_VARIANT_KEY = "user.variant";
    public static final String JMX_REMOTE_KEY = "com.sun.management.jmxremote";
    public static final String JAVA_IO_TMPDIR_KEY = "java.io.tmpdir";
    public static final Set<String> IMMUTABLE_SYSTEM_PROPERTIES = ImmutableSet.of((Object)"file.encoding", (Object)"user.language", (Object)"user.country", (Object)"user.variant", (Object)"com.sun.management.jmxremote", (Object)"java.io.tmpdir", (Object[])new String[0]);
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private final List<Object> extraJvmArgs = new ArrayList<Object>();
    private final Map<String, Object> mutableSystemProperties = new TreeMap<String, Object>();
    private DefaultConfigurableFileCollection bootstrapClasspath;
    private String minHeapSize;
    private String maxHeapSize;
    private boolean assertionsEnabled;
    private boolean debug;
    protected final Map<String, Object> immutableSystemProperties = new TreeMap<String, Object>();

    public JvmOptions(PathToFileResolver resolver) {
        this.bootstrapClasspath = new DefaultConfigurableFileCollection(resolver, null, new Object[0]);
        this.immutableSystemProperties.put(FILE_ENCODING_KEY, Charset.defaultCharset().name());
        this.immutableSystemProperties.put(USER_LANGUAGE_KEY, DEFAULT_LOCALE.getLanguage());
        this.immutableSystemProperties.put(USER_COUNTRY_KEY, DEFAULT_LOCALE.getCountry());
        this.immutableSystemProperties.put(USER_VARIANT_KEY, DEFAULT_LOCALE.getVariant());
    }

    public List<String> getAllJvmArgs() {
        LinkedList<String> args = new LinkedList<String>();
        this.formatSystemProperties(this.getMutableSystemProperties(), args);
        args.addAll(this.getAllImmutableJvmArgs());
        return args;
    }

    protected void formatSystemProperties(Map<String, ?> properties, List<String> args) {
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            if (entry.getValue() != null && entry.getValue().toString().length() > 0) {
                args.add("-D" + entry.getKey() + "=" + entry.getValue().toString());
                continue;
            }
            args.add("-D" + entry.getKey());
        }
    }

    public List<String> getAllImmutableJvmArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.getJvmArgs());
        args.addAll(this.getManagedJvmArgs());
        return args;
    }

    public List<String> getManagedJvmArgs() {
        FileCollection bootstrapClasspath;
        ArrayList<String> args = new ArrayList<String>();
        if (this.minHeapSize != null) {
            args.add("-Xms" + this.minHeapSize);
        }
        if (this.maxHeapSize != null) {
            args.add("-Xmx" + this.maxHeapSize);
        }
        if (!(bootstrapClasspath = this.getBootstrapClasspath()).isEmpty()) {
            args.add("-Xbootclasspath:" + bootstrapClasspath.getAsPath());
        }
        this.formatSystemProperties(this.immutableSystemProperties, args);
        if (this.assertionsEnabled) {
            args.add("-ea");
        }
        if (this.debug) {
            args.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005");
        }
        return args;
    }

    public void setAllJvmArgs(Iterable<?> arguments) {
        this.mutableSystemProperties.clear();
        this.minHeapSize = null;
        this.maxHeapSize = null;
        this.extraJvmArgs.clear();
        this.assertionsEnabled = false;
        this.debug = false;
        this.jvmArgs(arguments);
    }

    public List<String> getJvmArgs() {
        ArrayList<String> args = new ArrayList<String>();
        for (Object extraJvmArg : this.extraJvmArgs) {
            args.add(extraJvmArg.toString());
        }
        return args;
    }

    public void setJvmArgs(Iterable<?> arguments) {
        this.extraJvmArgs.clear();
        this.jvmArgs(arguments);
    }

    public void jvmArgs(Iterable<?> arguments) {
        for (Object argument : arguments) {
            String argStr = argument.toString();
            Matcher matcher = SYS_PROP_PATTERN.matcher(argStr);
            if (matcher.matches()) {
                this.systemProperty(matcher.group(1), matcher.group(2));
                continue;
            }
            matcher = NO_ARG_SYS_PROP_PATTERN.matcher(argStr);
            if (matcher.matches()) {
                this.systemProperty(matcher.group(1), "");
                continue;
            }
            matcher = MIN_HEAP_PATTERN.matcher(argStr);
            if (matcher.matches()) {
                this.minHeapSize = matcher.group(1);
                continue;
            }
            matcher = MAX_HEAP_PATTERN.matcher(argStr);
            if (matcher.matches()) {
                this.maxHeapSize = matcher.group(1);
                continue;
            }
            matcher = BOOTSTRAP_PATTERN.matcher(argStr);
            if (matcher.matches()) {
                this.setBootstrapClasspath(matcher.group(1).split(Pattern.quote(File.pathSeparator)));
                continue;
            }
            if (argStr.equals("-ea") || argStr.equals("-enableassertions")) {
                this.assertionsEnabled = true;
                continue;
            }
            if (argStr.equals("-da") || argStr.equals("-disableassertions")) {
                this.assertionsEnabled = false;
                continue;
            }
            this.extraJvmArgs.add(argument);
        }
        boolean xdebugFound = false;
        boolean xrunjdwpFound = false;
        boolean xagentlibJdwpFound = false;
        HashSet<Object> matches = new HashSet<Object>();
        for (Object extraJvmArg : this.extraJvmArgs) {
            if (extraJvmArg.toString().equals("-Xdebug")) {
                xdebugFound = true;
                matches.add(extraJvmArg);
                continue;
            }
            if (extraJvmArg.toString().equals("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005")) {
                xrunjdwpFound = true;
                matches.add(extraJvmArg);
                continue;
            }
            if (!extraJvmArg.toString().equals("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005")) continue;
            xagentlibJdwpFound = true;
            matches.add(extraJvmArg);
        }
        if (xdebugFound && xrunjdwpFound || xagentlibJdwpFound) {
            this.debug = true;
            this.extraJvmArgs.removeAll(matches);
        }
    }

    public void jvmArgs(Object ... arguments) {
        this.jvmArgs(Arrays.asList(arguments));
    }

    public Map<String, Object> getMutableSystemProperties() {
        return this.mutableSystemProperties;
    }

    public Map<String, Object> getImmutableSystemProperties() {
        return this.immutableSystemProperties;
    }

    public void setSystemProperties(Map<String, ?> properties) {
        this.mutableSystemProperties.clear();
        this.systemProperties(properties);
    }

    public void systemProperties(Map<String, ?> properties) {
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            this.systemProperty(entry.getKey(), entry.getValue());
        }
    }

    public void systemProperty(String name, Object value) {
        if (IMMUTABLE_SYSTEM_PROPERTIES.contains(name)) {
            this.immutableSystemProperties.put(name, value);
        } else {
            this.mutableSystemProperties.put(name, value);
        }
    }

    public FileCollection getBootstrapClasspath() {
        return this.bootstrapClasspath;
    }

    public void setBootstrapClasspath(FileCollection classpath) {
        this.bootstrapClasspath.setFrom(classpath);
    }

    public void setBootstrapClasspath(Object ... classpath) {
        this.bootstrapClasspath.setFrom(classpath);
    }

    public void bootstrapClasspath(Object ... classpath) {
        this.bootstrapClasspath.from(classpath);
    }

    public String getMinHeapSize() {
        return this.minHeapSize;
    }

    public void setMinHeapSize(String heapSize) {
        this.minHeapSize = heapSize;
    }

    public String getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(String heapSize) {
        this.maxHeapSize = heapSize;
    }

    public String getDefaultCharacterEncoding() {
        return this.immutableSystemProperties.get(FILE_ENCODING_KEY).toString();
    }

    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.immutableSystemProperties.put(FILE_ENCODING_KEY, GUtil.isTrue((Object)defaultCharacterEncoding) ? defaultCharacterEncoding : Charset.defaultCharset().name());
    }

    public boolean getEnableAssertions() {
        return this.assertionsEnabled;
    }

    public void setEnableAssertions(boolean enabled) {
        this.assertionsEnabled = enabled;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean enabled) {
        this.debug = enabled;
    }

    public void copyTo(JavaForkOptions target) {
        target.setJvmArgs(this.extraJvmArgs);
        target.setSystemProperties(this.mutableSystemProperties);
        target.setMinHeapSize(this.minHeapSize);
        target.setMaxHeapSize(this.maxHeapSize);
        target.setBootstrapClasspath(this.bootstrapClasspath);
        target.setEnableAssertions(this.assertionsEnabled);
        target.setDebug(this.debug);
        target.systemProperties(this.immutableSystemProperties);
    }

    public static List<String> fromString(String input) {
        return ArgumentsSplitter.split(input);
    }
}

