/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.HashSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.BuildSuccess;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.internal.BuilderCommon;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.lifecycle.internal.MojoExecutor;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=LifecycleModuleBuilder.class)
public class LifecycleModuleBuilder {
    @Requirement
    private MojoExecutor mojoExecutor;
    @Requirement
    private BuilderCommon builderCommon;
    @Requirement
    private ExecutionEventCatapult eventCatapult;

    public void buildProject(MavenSession session, ReactorContext reactorContext, MavenProject currentProject, TaskSegment taskSegment) {
        this.buildProject(session, session, reactorContext, currentProject, taskSegment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildProject(MavenSession session, MavenSession rootSession, ReactorContext reactorContext, MavenProject currentProject, TaskSegment taskSegment) {
        session.setCurrentProject(currentProject);
        long buildStartTime = System.currentTimeMillis();
        try {
            if (reactorContext.getReactorBuildStatus().isHaltedOrBlacklisted(currentProject)) {
                this.eventCatapult.fire(ExecutionEvent.Type.ProjectSkipped, session, null);
                return;
            }
            this.eventCatapult.fire(ExecutionEvent.Type.ProjectStarted, session, null);
            BuilderCommon.attachToThread(currentProject);
            MavenExecutionPlan executionPlan = this.builderCommon.resolveBuildPlan(session, currentProject, taskSegment, new HashSet<Artifact>());
            this.mojoExecutor.execute(session, executionPlan.getMojoExecutions(), reactorContext.getProjectIndex());
            long buildEndTime = System.currentTimeMillis();
            reactorContext.getResult().addBuildSummary(new BuildSuccess(currentProject, buildEndTime - buildStartTime));
            this.eventCatapult.fire(ExecutionEvent.Type.ProjectSucceeded, session, null);
        }
        catch (Exception e) {
            this.builderCommon.handleBuildError(reactorContext, rootSession, currentProject, e, buildStartTime);
        }
        finally {
            session.setCurrentProject(null);
            Thread.currentThread().setContextClassLoader(reactorContext.getOriginalContextClassLoader());
        }
    }
}

